/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.auth;

import com.teamscale.service.framework.authentication.RequiresNoLogin;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import com.teamscale.service.framework.authorization.RequiresComplexPermission;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.authorization.RequiresUserPermission;
import com.teamscale.service.framework.impl.auth.AuthServiceFeature;
import com.teamscale.service.framework.util.ServiceAnnotationUtils;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;

@Provider
public class PermissionAnnotationCheckFeature
implements DynamicFeature {
    private static final Collection<Class<? extends Annotation>> PERMISSION_ANNOTATIONS = Set.of(RequiresProjectPermission.class, RequiresGlobalPermission.class, RequiresUserPermission.class, RequiresBasicPermission.class, RequiresComplexPermission.class, RequiresNoPermission.class, RequiresNoLogin.class);

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        if (AuthServiceFeature.isJerseyOptionsMethodProcessor(resourceInfo)) {
            return;
        }
        boolean hasPermissionAnnotation = false;
        for (Class<? extends Annotation> permissionAnnotation : PERMISSION_ANNOTATIONS) {
            hasPermissionAnnotation |= ServiceAnnotationUtils.getMethodAnnotation((ResourceInfo)resourceInfo, permissionAnnotation).isPresent();
        }
        if (!hasPermissionAnnotation) {
            throw PermissionAnnotationCheckFeature.reportProblemForResource("Service method needs at least one permission annotation: ", resourceInfo);
        }
        PermissionAnnotationCheckFeature.ensureBasicPermissionSpecifiesAnEntity(resourceInfo);
    }

    private static void ensureBasicPermissionSpecifiesAnEntity(ResourceInfo resourceInfo) {
        Optional basicPermission = ServiceAnnotationUtils.getMethodAnnotation((ResourceInfo)resourceInfo, RequiresBasicPermission.class);
        if (basicPermission.isPresent() && ((RequiresBasicPermission)basicPermission.get()).entityPathParameter().isEmpty() == ((RequiresBasicPermission)basicPermission.get()).entityQueryParameter().isEmpty()) {
            throw PermissionAnnotationCheckFeature.reportProblemForResource("Either a path or a query parameter must be given to check permissions on at: ", resourceInfo);
        }
    }

    private static IllegalStateException reportProblemForResource(String message, ResourceInfo resourceInfo) {
        String fullMessage = message + String.valueOf(resourceInfo.getResourceMethod());
        LogManager.getLogger().fatal(fullMessage);
        return new IllegalStateException(fullMessage);
    }
}

