/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.authorization;

import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.framework.impl.authorization.AnnotatedPermissionCheckerBase;
import com.teamscale.service.framework.impl.authorization.BasicPermissionChecker;
import com.teamscale.service.framework.impl.authorization.ComplexPermissionChecker;
import com.teamscale.service.framework.impl.authorization.GlobalPermissionChecker;
import com.teamscale.service.framework.impl.authorization.ProjectPermissionChecker;
import com.teamscale.service.framework.impl.authorization.UserPermissionChecker;
import jakarta.annotation.Priority;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import org.conqat.engine.persistence.store.StorageException;

@Priority(value=2000)
public class AuthorizationCheckFilter
implements ContainerRequestFilter {
    @Context
    private ITeamscaleServiceInfo serviceInfo;
    @Context
    private ResourceInfo resourceInfo;
    @Context
    private UriInfo uriInfo;
    private final ArrayList<AnnotatedPermissionCheckerBase> permissionCheckers = new ArrayList();

    public AuthorizationCheckFilter() {
        this.permissionCheckers.add(new ProjectPermissionChecker());
        this.permissionCheckers.add(new GlobalPermissionChecker());
        this.permissionCheckers.add(new UserPermissionChecker());
        this.permissionCheckers.add(new BasicPermissionChecker());
        this.permissionCheckers.add(new ComplexPermissionChecker());
    }

    public void filter(ContainerRequestContext requestContext) {
        try {
            for (AnnotatedPermissionCheckerBase checker : this.permissionCheckers) {
                checker.check(this.resourceInfo, this.uriInfo, this.serviceInfo);
            }
        }
        catch (StorageException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }
}

