/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.cache;

import com.teamscale.service.framework.impl.cache.CacheEntry;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ServerCache {
    private static ServerCache instance;
    private final Map<String, Map<MediaType, CacheEntry>> cache = new ConcurrentHashMap<String, Map<MediaType, CacheEntry>>();

    public static synchronized ServerCache getInstance() {
        if (instance == null) {
            instance = new ServerCache();
        }
        return instance;
    }

    private ServerCache() {
    }

    public CacheEntry add(String uri, MediaType mediaType, CacheControl cc, MultivaluedMap<String, Object> headers, byte[] entity, EntityTag etag, MultivaluedMap<String, String> varyHeaders) {
        CacheEntry cacheEntry = new CacheEntry(headers, entity, cc.getMaxAge(), etag, varyHeaders);
        Map entry = this.cache.computeIfAbsent(uri, key -> new ConcurrentHashMap());
        entry.put(mediaType, cacheEntry);
        return cacheEntry;
    }

    public CacheEntry get(String uri, List<MediaType> acceptedMediaTypes, MultivaluedMap<String, String> headers) {
        Map<MediaType, CacheEntry> entry = this.cache.get(uri);
        if (entry == null || entry.isEmpty()) {
            return null;
        }
        for (Map.Entry<MediaType, CacheEntry> produce : entry.entrySet()) {
            for (MediaType acceptedMediaType : acceptedMediaTypes) {
                if (!acceptedMediaType.isCompatible(produce.getKey()) || !ServerCache.doVaryHeadersMatch(produce.getValue(), headers)) continue;
                return produce.getValue();
            }
        }
        return null;
    }

    public void remove(String uri) {
        this.cache.remove(uri);
    }

    public void clear() {
        this.cache.clear();
    }

    private static boolean doVaryHeadersMatch(CacheEntry cached, MultivaluedMap<String, String> currentRequestHeaders) {
        for (Map.Entry entry : cached.getVaryHeaders().entrySet()) {
            String headerName = (String)entry.getKey();
            if (currentRequestHeaders.containsKey((Object)headerName) && ((List)currentRequestHeaders.get((Object)headerName)).containsAll((Collection)entry.getValue())) continue;
            return false;
        }
        return true;
    }
}

