/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.error;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.teamscale.core.utils.HttpRequestUtils;
import com.teamscale.service.framework.authentication.Badge;
import com.teamscale.service.framework.badge.info.InfoBadgeCreator;
import com.teamscale.service.framework.logging.IRequestInfo;
import com.teamscale.service.framework.logging.UncriticalStatusCode;
import com.teamscale.service.framework.util.ServiceAnnotationUtils;
import jakarta.inject.Provider;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.logging.ELogLevel;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.io.EofException;

public abstract class ExceptionMapperBase<T extends Throwable>
implements ExceptionMapper<T> {
    protected static final Logger LOGGER = LogManager.getLogger();
    public static final ImmutableSet<Response.Status.Family> ERROR_STATUS_FAMILIES = Sets.immutableEnumSet((Enum)Response.Status.Family.CLIENT_ERROR, (Enum[])new Response.Status.Family[]{Response.Status.Family.SERVER_ERROR});
    public static final String EXCEPTIONAL_PARAMETER = "exceptional";
    private static final MediaType TEXT_PLAIN_EXCEPTION_TYPE = new MediaType(MediaType.TEXT_PLAIN_TYPE.getType(), MediaType.TEXT_PLAIN_TYPE.getSubtype(), Map.ofEntries(Map.entry("exceptional", "true")));
    @Context
    protected Provider<ContainerRequestContext> requestProvider;
    @Context
    protected Provider<ResourceInfo> resourceInfoProvider;
    @Context
    protected Provider<IRequestInfo> requestInfoProvider;

    protected Response buildResponse(Response.Status httpStatusCode, T e) {
        ContainerRequestContext requestContext = (ContainerRequestContext)this.requestProvider.get();
        Method resourceMethod = ((ResourceInfo)this.resourceInfoProvider.get()).getResourceMethod();
        return ExceptionMapperBase.buildResponse(requestContext, resourceMethod, httpStatusCode, e);
    }

    public static <T extends Throwable> Response buildResponse(ContainerRequestContext requestContext, Method resourceMethod, Response.Status httpStatusCode, T e) {
        Response.ResponseBuilder errorResponse = Response.status((Response.Status)httpStatusCode);
        Optional badge = Optional.empty();
        if (resourceMethod != null) {
            badge = ServiceAnnotationUtils.getMethodAnnotation(Badge.class, (Method)resourceMethod);
        }
        if (httpStatusCode == Response.Status.NOT_FOUND && HttpRequestUtils.isHtmlRequest((ContainerRequestContext)requestContext)) {
            errorResponse.type(MediaType.TEXT_HTML_TYPE).entity((Object)HttpRequestUtils.getHttp404ErrorPageHtml((ContainerRequestContext)requestContext));
        } else {
            if (badge.isPresent()) {
                return ExceptionMapperBase.buildBadgeResponse(httpStatusCode, e);
            }
            errorResponse.type(TEXT_PLAIN_EXCEPTION_TYPE).entity((Object)HttpRequestUtils.getHttpExceptionPage((ContainerRequestContext)requestContext, (Response.Status)httpStatusCode, e));
        }
        return errorResponse.build();
    }

    private static <T extends Throwable> Response buildBadgeResponse(Response.Status httpStatusCode, T e) {
        byte[] badge = httpStatusCode == Response.Status.UNAUTHORIZED ? InfoBadgeCreator.createUnauthorizedBadge() : (httpStatusCode == Response.Status.FORBIDDEN ? InfoBadgeCreator.createInsufficientRightsBadge() : InfoBadgeCreator.createErrorBadgeWithMessage((String)e.getMessage()));
        return Response.status((Response.Status)httpStatusCode).type("image/svg+xml").entity((Object)badge).build();
    }

    protected void logException(Exception e, Response.Status status) {
        if (this.shouldSkipLoggingException(e, status)) {
            return;
        }
        List uncriticalStatusCodes = ServiceAnnotationUtils.getMethodAnnotations((ResourceInfo)((ResourceInfo)this.resourceInfoProvider.get()), UncriticalStatusCode.class);
        ELogLevel logLevel = uncriticalStatusCodes.stream().filter(uncriticalStatusCode -> uncriticalStatusCode.value() == status).findFirst().map(UncriticalStatusCode::logLevel).orElse(ELogLevel.ERROR);
        LOGGER.log(logLevel.getLog4JLevel(), ExceptionMapperBase.getLogMessage(status, e), (Throwable)e);
    }

    private boolean shouldSkipLoggingException(Exception e, Response.Status status) {
        if (this.getRequestHttpMethod() == HttpMethod.HEAD && status == Response.Status.NOT_FOUND) {
            return true;
        }
        if (e instanceof EofException) {
            return true;
        }
        return !ERROR_STATUS_FAMILIES.contains((Object)status.getFamily());
    }

    private HttpMethod getRequestHttpMethod() {
        return HttpMethod.fromString((String)((IRequestInfo)this.requestInfoProvider.get()).httpMethod().name());
    }

    private static String getLogMessage(Response.Status status, Exception e) {
        return "Status " + status.getStatusCode() + " " + status.getReasonPhrase() + ": " + e.getMessage();
    }
}

