/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.filter.respone;

import com.teamscale.core.rest.MoreMediaTypes;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Provider;
import java.nio.charset.StandardCharsets;

@Provider
@Priority(value=3000)
public class CharsetResponseFilter
implements ContainerResponseFilter {
    public void filter(ContainerRequestContext request, ContainerResponseContext response) {
        MediaType responseMediaType = response.getMediaType();
        if (responseMediaType == null || !responseMediaType.getType().equals(MediaType.TEXT_PLAIN_TYPE.getType()) || responseMediaType.getSubtype().equals(MoreMediaTypes.TEXT_JAVASCRIPT_TYPE.getSubtype()) || responseMediaType.getParameters().containsKey("charset")) {
            return;
        }
        response.getHeaders().putSingle((Object)"Content-Type", (Object)responseMediaType.withCharset(StandardCharsets.UTF_8.name()));
    }
}

