/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.filter.respone;

import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.string.StringUtils;

@Provider
@Priority(value=2999)
public class ContentEncodingAndContentLengthFilter
implements ContainerResponseFilter {
    private static final Logger LOGGER = LogManager.getLogger();

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        String encoding = responseContext.getHeaderString("Content-Encoding");
        if ("identity".equals(encoding)) {
            responseContext.getHeaders().remove((Object)"Content-Encoding");
        } else if (!StringUtils.isEmpty((String)encoding) && responseContext.getHeaders().containsKey((Object)"Content-Length")) {
            LOGGER.warn("Content-Length was set without specifying Content-Encoding: identity");
            responseContext.getHeaders().remove((Object)"Content-Length");
        }
    }
}

