/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.logging;

import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import com.teamscale.service.framework.IStaticServiceContext;
import com.teamscale.service.framework.logging.ICriticalEventLogger;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.Nullable;

public class CriticalEventLogger
implements ICriticalEventLogger {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String CRITICAL_EVENT_KEY = "teamscale-critical-event";
    private final ContainerRequestContext requestContext;
    private final IStaticServiceContext staticServiceContext;

    public CriticalEventLogger(ContainerRequestContext requestContext, IStaticServiceContext staticServiceContext) {
        this.requestContext = requestContext;
        this.staticServiceContext = staticServiceContext;
    }

    public void logCriticalEventMessage(IProjectId projectId, String message, UUID rollbackId) {
        InternalProjectId internalId;
        if (projectId.isInternal()) {
            internalId = (InternalProjectId)projectId;
        } else if (SchedulingConstants.isMaintenance((IProjectId)projectId)) {
            internalId = SchedulingConstants.MAINTENANCE_PROJECT_INTERNAL_ID;
        } else {
            try {
                Optional projectInfo = this.staticServiceContext.getProjectIndex().tryResolveProject(projectId);
                if (projectInfo.isPresent()) {
                    internalId = ((ProjectInfo)projectInfo.get()).getInternalId();
                } else {
                    this.storeCriticalEvent(new CriticalEvent(SchedulingConstants.MAINTENANCE_PROJECT_INTERNAL_ID, "Unable to find project: " + String.valueOf(projectId), null));
                    internalId = SchedulingConstants.MAINTENANCE_PROJECT_INTERNAL_ID;
                }
            }
            catch (StorageException e) {
                LOGGER.error("Unable to obtain internal project ID for %s".formatted(projectId), (Throwable)e);
                return;
            }
        }
        this.storeCriticalEvent(new CriticalEvent(internalId, message, rollbackId));
    }

    private void storeCriticalEvent(CriticalEvent e) {
        List<CriticalEvent> criticalEvents = CriticalEventLogger.getCriticalEventsInternal(this.requestContext);
        criticalEvents.add(e);
        this.requestContext.setProperty(CRITICAL_EVENT_KEY, criticalEvents);
    }

    private static List<CriticalEvent> getCriticalEventsInternal(ContainerRequestContext requestContext) {
        ArrayList criticalEvents = (ArrayList)requestContext.getProperty(CRITICAL_EVENT_KEY);
        if (criticalEvents == null) {
            criticalEvents = new ArrayList();
        }
        return criticalEvents;
    }

    public static List<CriticalEvent> getCriticalEvents(ContainerRequestContext requestContext) {
        return new ArrayList<CriticalEvent>(CriticalEventLogger.getCriticalEventsInternal(requestContext));
    }

    public record CriticalEvent(InternalProjectId projectId, String message, @Nullable UUID rollbackId) {
        public CriticalEvent(InternalProjectId projectId, String message, @Nullable UUID rollbackId) {
            Objects.requireNonNull(projectId, "projectId");
            Objects.requireNonNull(message, "message");
        }
    }
}

