/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.provider;

import com.teamscale.service.framework.impl.provider.FunctionalConverter;
import com.teamscale.service.framework.impl.provider.InvalidValueException;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.function.Function;

@Provider
public class JavaTimeConverterProvider
implements ParamConverterProvider {
    private static final Map<Class<?>, Function<String, ?>> CONVERTERS = Map.ofEntries(Map.entry(Instant.class, JavaTimeConverterProvider::convertInstant), Map.entry(LocalDate.class, LocalDate::parse), Map.entry(LocalTime.class, LocalTime::parse), Map.entry(LocalDateTime.class, LocalDateTime::parse), Map.entry(ZonedDateTime.class, ZonedDateTime::parse), Map.entry(OffsetDateTime.class, OffsetDateTime::parse), Map.entry(Duration.class, Duration::parse), Map.entry(Period.class, Period::parse), Map.entry(MonthDay.class, MonthDay::parse), Map.entry(OffsetTime.class, OffsetTime::parse), Map.entry(Year.class, Year::parse), Map.entry(YearMonth.class, YearMonth::parse), Map.entry(ZoneId.class, ZoneId::of), Map.entry(ZoneOffset.class, ZoneOffset::of));

    public <P> ParamConverter<P> getConverter(Class<P> rawType, Type genericType, Annotation[] annotations) {
        Function<String, ?> converter = CONVERTERS.get(rawType);
        if (converter == null) {
            return null;
        }
        return new FunctionalConverter(annotations, v -> JavaTimeConverterProvider.convert(v, rawType, converter));
    }

    private static Instant convertInstant(String value) {
        try {
            long millis = Long.parseLong(value);
            return Instant.ofEpochMilli(millis);
        }
        catch (NumberFormatException e) {
            return Instant.parse(value);
        }
    }

    private static <T> T convert(String value, Class<T> target, Function<String, ?> converter) throws InvalidValueException {
        try {
            return target.cast(converter.apply(value));
        }
        catch (DateTimeException e) {
            throw new InvalidValueException("Unable to parse '%s' to %s".formatted(value, target), e);
        }
    }
}

