/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.provider;

import com.teamscale.service.framework.impl.provider.FunctionalConverter;
import com.teamscale.service.framework.impl.provider.InvalidValueException;
import com.teamscale.wia.TeamscaleIssueId;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.conqat.lib.commons.string.StringUtils;

@Provider
public class TeamscaleIssueIdConverterProvider
implements ParamConverterProvider {
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (TeamscaleIssueId.class.equals(rawType)) {
            FunctionalConverter converter = new FunctionalConverter(annotations, TeamscaleIssueIdConverterProvider::convert);
            return converter;
        }
        return null;
    }

    private static TeamscaleIssueId convert(String issueId) throws InvalidValueException {
        if (StringUtils.isEmpty((String)issueId)) {
            return null;
        }
        try {
            return TeamscaleIssueId.fromInternalId((String)issueId);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidValueException(e.getMessage(), e);
        }
    }
}

