/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.provider;

import com.teamscale.service.framework.impl.provider.GenericConverterBase;
import com.teamscale.service.framework.impl.provider.InvalidValueException;
import com.teamscale.service.framework.parameter.ResolveToCodePath;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.conqat.lib.commons.uniformpath.IUniformPath;
import org.conqat.lib.commons.uniformpath.IVirtualCodeUniformPath;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Provider
public class UniformPathConverterProvider
implements ParamConverterProvider {
    public <P> ParamConverter<P> getConverter(Class<P> rawType, Type genericType, Annotation[] annotations) {
        if (UniformPath.class.isAssignableFrom(rawType)) {
            return new UniformPathConverter<UniformPath>(annotations, rawType.asSubclass(UniformPath.class));
        }
        if (IUniformPath.class.isAssignableFrom(rawType)) {
            return new UniformPathConverter<IUniformPath>(annotations, rawType.asSubclass(IUniformPath.class));
        }
        return null;
    }

    private static class UniformPathConverter<P>
    extends GenericConverterBase<P> {
        private final boolean resolveToCodePath;
        private final Class<P> targetType;

        private UniformPathConverter(Annotation[] annotations, Class<P> targetType) {
            super(annotations);
            this.resolveToCodePath = Arrays.stream(annotations).anyMatch(annotation -> annotation.annotationType().equals(ResolveToCodePath.class));
            this.targetType = targetType;
        }

        @Override
        protected P convert(String uniformPath) throws InvalidValueException {
            UniformPath converted;
            if (uniformPath == null) {
                return null;
            }
            try {
                converted = UniformPath.parse((String)uniformPath);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidValueException(e.getMessage(), e);
            }
            if (this.resolveToCodePath && converted instanceof IVirtualCodeUniformPath) {
                IVirtualCodeUniformPath virtualPath = (IVirtualCodeUniformPath)converted;
                converted = virtualPath.resolveToCodePath();
            }
            if (!this.targetType.isInstance(converted)) {
                throw new InvalidValueException("Expected %s to be of type %s but was %s".formatted(converted, this.targetType, converted.getClass()));
            }
            return this.targetType.cast(converted);
        }
    }
}

