/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.security;

import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.service.framework.impl.cache.ServerCacheInterceptor;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.ext.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import org.conqat.engine.core.configuration.EFeatureToggle;

@Provider
@Priority(value=3000)
public class SecuritySettingsHeaderFilter
implements ContainerResponseFilter {
    private static final String REFERRER_POLICY = System.getProperty("com.teamscale.server.referrer-policy", "same-origin");
    private static final String CSP_FRAME_ANCESTORS_SETTING = System.getProperty("com.teamscale.server.csp-frame-ancestors", "'self' https://dev.azure.com https://cqsegmbh.gallerycdn.vsassets.io https://*.visualstudio.com");

    public void filter(ContainerRequestContext request, ContainerResponseContext response) {
        if (ServerCacheInterceptor.isCachedResponse(request)) {
            return;
        }
        response.getHeaders().putSingle((Object)"X-Content-Type-Options", (Object)"nosniff");
        response.getHeaders().putSingle((Object)"Referrer-Policy", (Object)REFERRER_POLICY);
        if (EFeatureToggle.isInUiDevServerMode()) {
            response.getHeaders().putSingle((Object)"Access-Control-Allow-Origin", (Object)"http://localhost:9090");
        }
        SecuritySettingsHeaderFilter.appendCspHeader(response);
        response.getHeaders().putSingle((Object)"X-XSS-Protection", (Object)"1; mode=block");
    }

    private static void appendCspHeader(ContainerResponseContext response) {
        CspBuilder cspBuilder = new CspBuilder().add(ECspDirective.DEFAULT_SRC, "'self'").add(ECspDirective.CONNECT_SRC, "'self'").add(ECspDirective.SCRIPT_SRC, "'self'", SecuritySettingsHeaderFilter.getAdditionalHash(response)).add(ECspDirective.FONT_SRC, "'self'", "data:").add(ECspDirective.FRAME_SRC, "'self'", "*").add(ECspDirective.WORKER_SRC, "'self'", "blob:").add(ECspDirective.IMG_SRC, "'self'", "data:").add(ECspDirective.STYLE_SRC, "'self'", "'unsafe-inline'").add(ECspDirective.FRAME_ANCESTORS, CSP_FRAME_ANCESTORS_SETTING);
        if (EFeatureToggle.isInUiDevServerMode()) {
            cspBuilder.add(List.of(ECspDirective.SCRIPT_SRC, ECspDirective.CONNECT_SRC), "http://localhost:9090/", "http://127.0.0.1:9090/", "ws://localhost:9090/", "ws://127.0.0.1:9090/", "'unsafe-inline'");
        } else {
            cspBuilder.add(ECspDirective.SCRIPT_SRC, "'sha256-3rMeRozBZInpdDjEZ5gzQxveZr+JqCzrmwXyxW8gOGo='");
        }
        if (EFeatureToggle.isInUiTestServerMode()) {
            cspBuilder.add(List.of(ECspDirective.CONNECT_SRC, ECspDirective.SCRIPT_SRC, ECspDirective.WORKER_SRC), "ws:");
        }
        if (TeamscaleSystemProperties.HUBSPOT_CHAT_PORTAL_ID.getValue().isPresent()) {
            cspBuilder.add(ECspDirective.SCRIPT_SRC, "https://*.hs-scripts.com/", "https://*.hs-banner.com/", "https://*.hs-analytics.net/", "https://*.usemessages.com/").add(ECspDirective.CONNECT_SRC, "https://*.hubspot.com/").add(ECspDirective.IMG_SRC, "https://*.hubspot.com/");
        }
        if (EFeatureToggle.ENABLE_DEV_MODE.isEnabled()) {
            cspBuilder.add(ECspDirective.IMG_SRC, "https://*.githubusercontent.com/").add(ECspDirective.IMG_SRC, "https://*.wikimedia.org/");
        }
        response.getHeaders().putSingle((Object)"Content-Security-Policy", (Object)cspBuilder.toString());
    }

    private static String getAdditionalHash(ContainerResponseContext responseContext) {
        List headers = (List)responseContext.getStringHeaders().get((Object)"X-ALLOWED-CSP-SCRIPT-HASH");
        if (headers == null) {
            return "";
        }
        responseContext.getHeaders().remove((Object)"X-ALLOWED-CSP-SCRIPT-HASH");
        return String.join((CharSequence)" ", headers);
    }

    static class CspBuilder {
        public static final String SELF = "'self'";
        public static final String UNSAFE_INLINE = "'unsafe-inline'";
        public static final String DATA = "data:";
        public static final String BLOB = "blob:";
        private final EnumMap<ECspDirective, List<String>> directives = new EnumMap(ECspDirective.class);

        CspBuilder() {
        }

        public CspBuilder add(ECspDirective directive, String ... sources) {
            this.directives.computeIfAbsent(directive, x -> new ArrayList()).addAll(Arrays.asList(sources));
            return this;
        }

        public CspBuilder add(Collection<ECspDirective> directives, String ... sources) {
            directives.forEach(directive -> this.add((ECspDirective)((Object)directive), sources));
            return this;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (ECspDirective directive : ECspDirective.values()) {
                List<String> sources = this.directives.get((Object)directive);
                if (sources == null || sources.isEmpty()) continue;
                builder.append((Object)directive);
                sources.forEach(source -> builder.append(' ').append((String)source));
                builder.append("; ");
            }
            return builder.toString().trim();
        }
    }

    static enum ECspDirective {
        DEFAULT_SRC,
        CONNECT_SRC,
        SCRIPT_SRC,
        FONT_SRC,
        FRAME_SRC,
        WORKER_SRC,
        IMG_SRC,
        STYLE_SRC,
        FRAME_ANCESTORS;


        public String toString() {
            return this.name().toLowerCase().replace('_', '-');
        }
    }
}

