/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.versioning;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.service.framework.util.ServiceAnnotationUtils;
import com.teamscale.service.framework.versioning.PublicApi;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.configuration.EFeatureToggle;

@Provider
public class AutoDisablingDeprecatedVersionFeature
implements DynamicFeature {
    private static final Logger LOGGER = LogManager.getLogger();

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        PublicApi publicApi = resourceInfo.getResourceMethod().getAnnotation(PublicApi.class);
        if (publicApi != null && ServiceAnnotationUtils.isDeprecated((PublicApi)publicApi)) {
            context.register(VersionServiceFilter.class);
        }
    }

    public static class VersionServiceFilter
    implements ContainerRequestFilter {
        @Context
        private ResourceInfo resourceInfo;

        public void filter(ContainerRequestContext requestContext) throws IOException {
            ETeamscaleVersion deprecatedVersion = this.resourceInfo.getResourceMethod().getAnnotation(PublicApi.class).deprecatedSince();
            int majorDiff = ETeamscaleVersion.CURRENT_VERSION.getMajor() - deprecatedVersion.getMajor();
            Level level = switch (majorDiff) {
                case 0 -> Level.INFO;
                case 1 -> Level.WARN;
                default -> Level.ERROR;
            };
            LOGGER.log(level, "Service {} {} is deprecated since Teamscale v{} and will be removed in a future version. Please refer to the API Reference for alternatives.", (Object)requestContext.getMethod(), (Object)requestContext.getUriInfo().getPath(), (Object)deprecatedVersion);
            if (ETeamscaleVersion.MIN_SUPPORTED_API_VERSION.compareTo((Enum)deprecatedVersion) > 0 && !EFeatureToggle.ENABLE_DEPRECATED_API.isEnabled()) {
                LOGGER.error("Service is disabled by default. To temporarily re-enable it, set the system property '{}' to 'true'.", (Object)EFeatureToggle.ENABLE_DEPRECATED_API.getId());
                requestContext.abortWith(Response.status((Response.Status)Response.Status.GONE).build());
            }
        }
    }
}

