/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.teamfoundation.build.webapi;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.alm.teamfoundation.build.webapi.BuildDefinition;
import com.microsoft.alm.teamfoundation.build.webapi.BuildDefinitionReference;
import com.microsoft.alm.teamfoundation.build.webapi.DefinitionReference;
import com.microsoft.alm.teamfoundation.build.webapi.DefinitionType;
import com.microsoft.alm.teamfoundation.build.webapi.XamlBuildDefinition;
import java.io.IOException;

public class DefinitionReferenceDeserializer
extends JsonDeserializer<DefinitionReference> {
    public DefinitionReference deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)parser.getCodec();
        JsonNode rootNode = (JsonNode)mapper.readTree(parser);
        JsonNode typeNode = rootNode.findValue("type");
        if (typeNode != null) {
            DefinitionType definitionType = DefinitionType.BUILD;
            definitionType = typeNode.isInt() && typeNode.asInt() == DefinitionType.XAML.getValue() ? DefinitionType.XAML : (typeNode.isTextual() && DefinitionType.XAML.toString().equalsIgnoreCase(typeNode.asText()) ? DefinitionType.XAML : DefinitionType.BUILD);
            switch (definitionType) {
                case XAML: {
                    return (DefinitionReference)rootNode.traverse((ObjectCodec)mapper).readValueAs(XamlBuildDefinition.class);
                }
            }
            try {
                return (DefinitionReference)rootNode.traverse((ObjectCodec)mapper).readValueAs(BuildDefinition.class);
            }
            catch (Exception exception) {
                try {
                    return (DefinitionReference)rootNode.traverse((ObjectCodec)mapper).readValueAs(BuildDefinitionReference.class);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

