/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.teamfoundation.work.webapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.HttpMethod;
import com.microsoft.alm.client.VssHttpClientBase;
import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.VssRestRequest;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.teamfoundation.work.webapi.Board;
import com.microsoft.alm.teamfoundation.work.webapi.BoardCardRuleSettings;
import com.microsoft.alm.teamfoundation.work.webapi.BoardCardSettings;
import com.microsoft.alm.teamfoundation.work.webapi.BoardChart;
import com.microsoft.alm.teamfoundation.work.webapi.BoardChartReference;
import com.microsoft.alm.teamfoundation.work.webapi.BoardColumn;
import com.microsoft.alm.teamfoundation.work.webapi.BoardFilterSettings;
import com.microsoft.alm.teamfoundation.work.webapi.BoardReference;
import com.microsoft.alm.teamfoundation.work.webapi.BoardRow;
import com.microsoft.alm.teamfoundation.work.webapi.BoardSuggestedValue;
import com.microsoft.alm.teamfoundation.work.webapi.BoardUserSettings;
import com.microsoft.alm.teamfoundation.work.webapi.CapacityPatch;
import com.microsoft.alm.teamfoundation.work.webapi.CreatePlan;
import com.microsoft.alm.teamfoundation.work.webapi.DeliveryViewData;
import com.microsoft.alm.teamfoundation.work.webapi.ParentChildWIMap;
import com.microsoft.alm.teamfoundation.work.webapi.Plan;
import com.microsoft.alm.teamfoundation.work.webapi.TeamFieldValues;
import com.microsoft.alm.teamfoundation.work.webapi.TeamFieldValuesPatch;
import com.microsoft.alm.teamfoundation.work.webapi.TeamMemberCapacity;
import com.microsoft.alm.teamfoundation.work.webapi.TeamSetting;
import com.microsoft.alm.teamfoundation.work.webapi.TeamSettingsDaysOff;
import com.microsoft.alm.teamfoundation.work.webapi.TeamSettingsDaysOffPatch;
import com.microsoft.alm.teamfoundation.work.webapi.TeamSettingsIteration;
import com.microsoft.alm.teamfoundation.work.webapi.TeamSettingsPatch;
import com.microsoft.alm.teamfoundation.work.webapi.contracts.ProcessConfiguration;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class WorkHttpClientBase
extends VssHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected WorkHttpClientBase(VssRestClientHandler clientHandler, URI baseUrl) {
        super(clientHandler, baseUrl);
    }

    @Override
    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public ArrayList<BoardSuggestedValue> getColumnSuggestedValues() {
        UUID locationId = UUID.fromString("eb7ec5a3-1ba3-4fd1-b834-49a5a387e57d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardSuggestedValue>>(){});
    }

    public ArrayList<BoardSuggestedValue> getColumnSuggestedValues(String project) {
        UUID locationId = UUID.fromString("eb7ec5a3-1ba3-4fd1-b834-49a5a387e57d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardSuggestedValue>>(){});
    }

    public ArrayList<BoardSuggestedValue> getColumnSuggestedValues(UUID project) {
        UUID locationId = UUID.fromString("eb7ec5a3-1ba3-4fd1-b834-49a5a387e57d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardSuggestedValue>>(){});
    }

    public BoardFilterSettings getBoardFilterSettings(String project, String board) {
        UUID locationId = UUID.fromString("cfe2d81b-12ba-4083-9e5a-859818c763e4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, BoardFilterSettings.class);
    }

    public BoardFilterSettings getBoardFilterSettings(UUID project, String board) {
        UUID locationId = UUID.fromString("cfe2d81b-12ba-4083-9e5a-859818c763e4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, BoardFilterSettings.class);
    }

    public BoardFilterSettings getBoardFilterSettings(String project, String team, String board) {
        UUID locationId = UUID.fromString("cfe2d81b-12ba-4083-9e5a-859818c763e4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, BoardFilterSettings.class);
    }

    public BoardFilterSettings getBoardFilterSettings(UUID project, UUID team, String board) {
        UUID locationId = UUID.fromString("cfe2d81b-12ba-4083-9e5a-859818c763e4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, BoardFilterSettings.class);
    }

    public BoardFilterSettings updateBoardFilterSettings(BoardFilterSettings filterSettings, String project, String board) {
        UUID locationId = UUID.fromString("cfe2d81b-12ba-4083-9e5a-859818c763e4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, filterSettings, "application/json", "application/json");
        return super.sendRequest(httpRequest, BoardFilterSettings.class);
    }

    public BoardFilterSettings updateBoardFilterSettings(BoardFilterSettings filterSettings, UUID project, String board) {
        UUID locationId = UUID.fromString("cfe2d81b-12ba-4083-9e5a-859818c763e4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, filterSettings, "application/json", "application/json");
        return super.sendRequest(httpRequest, BoardFilterSettings.class);
    }

    public BoardFilterSettings updateBoardFilterSettings(BoardFilterSettings filterSettings, String project, String team, String board) {
        UUID locationId = UUID.fromString("cfe2d81b-12ba-4083-9e5a-859818c763e4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, filterSettings, "application/json", "application/json");
        return super.sendRequest(httpRequest, BoardFilterSettings.class);
    }

    public BoardFilterSettings updateBoardFilterSettings(BoardFilterSettings filterSettings, UUID project, UUID team, String board) {
        UUID locationId = UUID.fromString("cfe2d81b-12ba-4083-9e5a-859818c763e4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, filterSettings, "application/json", "application/json");
        return super.sendRequest(httpRequest, BoardFilterSettings.class);
    }

    public ArrayList<ParentChildWIMap> getBoardMappingParentItems(String project, String team, String childBacklogContextCategoryRefName, List<Integer> workitemIds) {
        UUID locationId = UUID.fromString("186abea3-5c35-432f-9e28-7a15b4312a0e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("childBacklogContextCategoryRefName", childBacklogContextCategoryRefName);
        queryParameters.addIfNotNull("workitemIds", workitemIds);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ParentChildWIMap>>(){});
    }

    public ArrayList<ParentChildWIMap> getBoardMappingParentItems(UUID project, UUID team, String childBacklogContextCategoryRefName, List<Integer> workitemIds) {
        UUID locationId = UUID.fromString("186abea3-5c35-432f-9e28-7a15b4312a0e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("childBacklogContextCategoryRefName", childBacklogContextCategoryRefName);
        queryParameters.addIfNotNull("workitemIds", workitemIds);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ParentChildWIMap>>(){});
    }

    public ArrayList<ParentChildWIMap> getBoardMappingParentItems(String project, String childBacklogContextCategoryRefName, List<Integer> workitemIds) {
        UUID locationId = UUID.fromString("186abea3-5c35-432f-9e28-7a15b4312a0e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("childBacklogContextCategoryRefName", childBacklogContextCategoryRefName);
        queryParameters.addIfNotNull("workitemIds", workitemIds);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ParentChildWIMap>>(){});
    }

    public ArrayList<ParentChildWIMap> getBoardMappingParentItems(UUID project, String childBacklogContextCategoryRefName, List<Integer> workitemIds) {
        UUID locationId = UUID.fromString("186abea3-5c35-432f-9e28-7a15b4312a0e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("childBacklogContextCategoryRefName", childBacklogContextCategoryRefName);
        queryParameters.addIfNotNull("workitemIds", workitemIds);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ParentChildWIMap>>(){});
    }

    public ArrayList<BoardSuggestedValue> getRowSuggestedValues() {
        UUID locationId = UUID.fromString("bb494cc6-a0f5-4c6c-8dca-ea6912e79eb9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardSuggestedValue>>(){});
    }

    public ArrayList<BoardSuggestedValue> getRowSuggestedValues(String project) {
        UUID locationId = UUID.fromString("bb494cc6-a0f5-4c6c-8dca-ea6912e79eb9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardSuggestedValue>>(){});
    }

    public ArrayList<BoardSuggestedValue> getRowSuggestedValues(UUID project) {
        UUID locationId = UUID.fromString("bb494cc6-a0f5-4c6c-8dca-ea6912e79eb9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardSuggestedValue>>(){});
    }

    public Board getBoard(String project, String id) {
        UUID locationId = UUID.fromString("23ad19fc-3b8e-4877-8462-b3f92bc06b40");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, Board.class);
    }

    public Board getBoard(UUID project, String id) {
        UUID locationId = UUID.fromString("23ad19fc-3b8e-4877-8462-b3f92bc06b40");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, Board.class);
    }

    public Board getBoard(String project, String team, String id) {
        UUID locationId = UUID.fromString("23ad19fc-3b8e-4877-8462-b3f92bc06b40");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, Board.class);
    }

    public Board getBoard(UUID project, UUID team, String id) {
        UUID locationId = UUID.fromString("23ad19fc-3b8e-4877-8462-b3f92bc06b40");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, Board.class);
    }

    public ArrayList<BoardReference> getBoards(String project) {
        UUID locationId = UUID.fromString("23ad19fc-3b8e-4877-8462-b3f92bc06b40");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardReference>>(){});
    }

    public ArrayList<BoardReference> getBoards(UUID project) {
        UUID locationId = UUID.fromString("23ad19fc-3b8e-4877-8462-b3f92bc06b40");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardReference>>(){});
    }

    public ArrayList<BoardReference> getBoards(String project, String team) {
        UUID locationId = UUID.fromString("23ad19fc-3b8e-4877-8462-b3f92bc06b40");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardReference>>(){});
    }

    public ArrayList<BoardReference> getBoards(UUID project, UUID team) {
        UUID locationId = UUID.fromString("23ad19fc-3b8e-4877-8462-b3f92bc06b40");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardReference>>(){});
    }

    public HashMap<String, String> setBoardOptions(Map<String, String> options, String project, String id) {
        UUID locationId = UUID.fromString("23ad19fc-3b8e-4877-8462-b3f92bc06b40");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, options, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<HashMap<String, String>>(){});
    }

    public HashMap<String, String> setBoardOptions(Map<String, String> options, UUID project, String id) {
        UUID locationId = UUID.fromString("23ad19fc-3b8e-4877-8462-b3f92bc06b40");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, options, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<HashMap<String, String>>(){});
    }

    public HashMap<String, String> setBoardOptions(Map<String, String> options, String project, String team, String id) {
        UUID locationId = UUID.fromString("23ad19fc-3b8e-4877-8462-b3f92bc06b40");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, options, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<HashMap<String, String>>(){});
    }

    public HashMap<String, String> setBoardOptions(Map<String, String> options, UUID project, UUID team, String id) {
        UUID locationId = UUID.fromString("23ad19fc-3b8e-4877-8462-b3f92bc06b40");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, options, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<HashMap<String, String>>(){});
    }

    public BoardUserSettings getBoardUserSettings(String project, String board) {
        UUID locationId = UUID.fromString("b30d9f58-1891-4b0a-b168-c46408f919b0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, BoardUserSettings.class);
    }

    public BoardUserSettings getBoardUserSettings(UUID project, String board) {
        UUID locationId = UUID.fromString("b30d9f58-1891-4b0a-b168-c46408f919b0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, BoardUserSettings.class);
    }

    public BoardUserSettings getBoardUserSettings(String project, String team, String board) {
        UUID locationId = UUID.fromString("b30d9f58-1891-4b0a-b168-c46408f919b0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, BoardUserSettings.class);
    }

    public BoardUserSettings getBoardUserSettings(UUID project, UUID team, String board) {
        UUID locationId = UUID.fromString("b30d9f58-1891-4b0a-b168-c46408f919b0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, BoardUserSettings.class);
    }

    public BoardUserSettings updateBoardUserSettings(Map<String, String> boardUserSettings, String project, String board) {
        UUID locationId = UUID.fromString("b30d9f58-1891-4b0a-b168-c46408f919b0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, boardUserSettings, "application/json", "application/json");
        return super.sendRequest(httpRequest, BoardUserSettings.class);
    }

    public BoardUserSettings updateBoardUserSettings(Map<String, String> boardUserSettings, UUID project, String board) {
        UUID locationId = UUID.fromString("b30d9f58-1891-4b0a-b168-c46408f919b0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, boardUserSettings, "application/json", "application/json");
        return super.sendRequest(httpRequest, BoardUserSettings.class);
    }

    public BoardUserSettings updateBoardUserSettings(Map<String, String> boardUserSettings, String project, String team, String board) {
        UUID locationId = UUID.fromString("b30d9f58-1891-4b0a-b168-c46408f919b0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, boardUserSettings, "application/json", "application/json");
        return super.sendRequest(httpRequest, BoardUserSettings.class);
    }

    public BoardUserSettings updateBoardUserSettings(Map<String, String> boardUserSettings, UUID project, UUID team, String board) {
        UUID locationId = UUID.fromString("b30d9f58-1891-4b0a-b168-c46408f919b0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, boardUserSettings, "application/json", "application/json");
        return super.sendRequest(httpRequest, BoardUserSettings.class);
    }

    public ArrayList<TeamMemberCapacity> getCapacities(String project, UUID iterationId) {
        UUID locationId = UUID.fromString("74412d15-8c1a-4352-a48d-ef1ed5587d57");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TeamMemberCapacity>>(){});
    }

    public ArrayList<TeamMemberCapacity> getCapacities(UUID project, UUID iterationId) {
        UUID locationId = UUID.fromString("74412d15-8c1a-4352-a48d-ef1ed5587d57");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TeamMemberCapacity>>(){});
    }

    public ArrayList<TeamMemberCapacity> getCapacities(String project, String team, UUID iterationId) {
        UUID locationId = UUID.fromString("74412d15-8c1a-4352-a48d-ef1ed5587d57");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TeamMemberCapacity>>(){});
    }

    public ArrayList<TeamMemberCapacity> getCapacities(UUID project, UUID team, UUID iterationId) {
        UUID locationId = UUID.fromString("74412d15-8c1a-4352-a48d-ef1ed5587d57");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TeamMemberCapacity>>(){});
    }

    public TeamMemberCapacity getCapacity(String project, UUID iterationId, UUID teamMemberId) {
        UUID locationId = UUID.fromString("74412d15-8c1a-4352-a48d-ef1ed5587d57");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("iterationId", iterationId);
        routeValues.put("teamMemberId", teamMemberId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TeamMemberCapacity.class);
    }

    public TeamMemberCapacity getCapacity(UUID project, UUID iterationId, UUID teamMemberId) {
        UUID locationId = UUID.fromString("74412d15-8c1a-4352-a48d-ef1ed5587d57");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("iterationId", iterationId);
        routeValues.put("teamMemberId", teamMemberId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TeamMemberCapacity.class);
    }

    public TeamMemberCapacity getCapacity(String project, String team, UUID iterationId, UUID teamMemberId) {
        UUID locationId = UUID.fromString("74412d15-8c1a-4352-a48d-ef1ed5587d57");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("iterationId", iterationId);
        routeValues.put("teamMemberId", teamMemberId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TeamMemberCapacity.class);
    }

    public TeamMemberCapacity getCapacity(UUID project, UUID team, UUID iterationId, UUID teamMemberId) {
        UUID locationId = UUID.fromString("74412d15-8c1a-4352-a48d-ef1ed5587d57");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("iterationId", iterationId);
        routeValues.put("teamMemberId", teamMemberId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TeamMemberCapacity.class);
    }

    public ArrayList<TeamMemberCapacity> replaceCapacities(List<TeamMemberCapacity> capacities, String project, UUID iterationId) {
        UUID locationId = UUID.fromString("74412d15-8c1a-4352-a48d-ef1ed5587d57");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, capacities, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TeamMemberCapacity>>(){});
    }

    public ArrayList<TeamMemberCapacity> replaceCapacities(List<TeamMemberCapacity> capacities, UUID project, UUID iterationId) {
        UUID locationId = UUID.fromString("74412d15-8c1a-4352-a48d-ef1ed5587d57");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, capacities, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TeamMemberCapacity>>(){});
    }

    public ArrayList<TeamMemberCapacity> replaceCapacities(List<TeamMemberCapacity> capacities, String project, String team, UUID iterationId) {
        UUID locationId = UUID.fromString("74412d15-8c1a-4352-a48d-ef1ed5587d57");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, capacities, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TeamMemberCapacity>>(){});
    }

    public ArrayList<TeamMemberCapacity> replaceCapacities(List<TeamMemberCapacity> capacities, UUID project, UUID team, UUID iterationId) {
        UUID locationId = UUID.fromString("74412d15-8c1a-4352-a48d-ef1ed5587d57");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, capacities, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TeamMemberCapacity>>(){});
    }

    public TeamMemberCapacity updateCapacity(CapacityPatch patch, String project, UUID iterationId, UUID teamMemberId) {
        UUID locationId = UUID.fromString("74412d15-8c1a-4352-a48d-ef1ed5587d57");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("iterationId", iterationId);
        routeValues.put("teamMemberId", teamMemberId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, patch, "application/json", "application/json");
        return super.sendRequest(httpRequest, TeamMemberCapacity.class);
    }

    public TeamMemberCapacity updateCapacity(CapacityPatch patch, UUID project, UUID iterationId, UUID teamMemberId) {
        UUID locationId = UUID.fromString("74412d15-8c1a-4352-a48d-ef1ed5587d57");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("iterationId", iterationId);
        routeValues.put("teamMemberId", teamMemberId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, patch, "application/json", "application/json");
        return super.sendRequest(httpRequest, TeamMemberCapacity.class);
    }

    public TeamMemberCapacity updateCapacity(CapacityPatch patch, String project, String team, UUID iterationId, UUID teamMemberId) {
        UUID locationId = UUID.fromString("74412d15-8c1a-4352-a48d-ef1ed5587d57");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("iterationId", iterationId);
        routeValues.put("teamMemberId", teamMemberId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, patch, "application/json", "application/json");
        return super.sendRequest(httpRequest, TeamMemberCapacity.class);
    }

    public TeamMemberCapacity updateCapacity(CapacityPatch patch, UUID project, UUID team, UUID iterationId, UUID teamMemberId) {
        UUID locationId = UUID.fromString("74412d15-8c1a-4352-a48d-ef1ed5587d57");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("iterationId", iterationId);
        routeValues.put("teamMemberId", teamMemberId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, patch, "application/json", "application/json");
        return super.sendRequest(httpRequest, TeamMemberCapacity.class);
    }

    public BoardCardRuleSettings getBoardCardRuleSettings(String project, String board) {
        UUID locationId = UUID.fromString("b044a3d9-02ea-49c7-91a1-b730949cc896");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, BoardCardRuleSettings.class);
    }

    public BoardCardRuleSettings getBoardCardRuleSettings(UUID project, String board) {
        UUID locationId = UUID.fromString("b044a3d9-02ea-49c7-91a1-b730949cc896");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, BoardCardRuleSettings.class);
    }

    public BoardCardRuleSettings getBoardCardRuleSettings(String project, String team, String board) {
        UUID locationId = UUID.fromString("b044a3d9-02ea-49c7-91a1-b730949cc896");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, BoardCardRuleSettings.class);
    }

    public BoardCardRuleSettings getBoardCardRuleSettings(UUID project, UUID team, String board) {
        UUID locationId = UUID.fromString("b044a3d9-02ea-49c7-91a1-b730949cc896");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, BoardCardRuleSettings.class);
    }

    public BoardCardRuleSettings updateBoardCardRuleSettings(BoardCardRuleSettings boardCardRuleSettings, String project, String board) {
        UUID locationId = UUID.fromString("b044a3d9-02ea-49c7-91a1-b730949cc896");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, boardCardRuleSettings, "application/json", "application/json");
        return super.sendRequest(httpRequest, BoardCardRuleSettings.class);
    }

    public BoardCardRuleSettings updateBoardCardRuleSettings(BoardCardRuleSettings boardCardRuleSettings, UUID project, String board) {
        UUID locationId = UUID.fromString("b044a3d9-02ea-49c7-91a1-b730949cc896");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, boardCardRuleSettings, "application/json", "application/json");
        return super.sendRequest(httpRequest, BoardCardRuleSettings.class);
    }

    public BoardCardRuleSettings updateBoardCardRuleSettings(BoardCardRuleSettings boardCardRuleSettings, String project, String team, String board) {
        UUID locationId = UUID.fromString("b044a3d9-02ea-49c7-91a1-b730949cc896");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, boardCardRuleSettings, "application/json", "application/json");
        return super.sendRequest(httpRequest, BoardCardRuleSettings.class);
    }

    public BoardCardRuleSettings updateBoardCardRuleSettings(BoardCardRuleSettings boardCardRuleSettings, UUID project, UUID team, String board) {
        UUID locationId = UUID.fromString("b044a3d9-02ea-49c7-91a1-b730949cc896");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, boardCardRuleSettings, "application/json", "application/json");
        return super.sendRequest(httpRequest, BoardCardRuleSettings.class);
    }

    public BoardCardSettings getBoardCardSettings(String project, String board) {
        UUID locationId = UUID.fromString("07c3b467-bc60-4f05-8e34-599ce288fafc");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, BoardCardSettings.class);
    }

    public BoardCardSettings getBoardCardSettings(UUID project, String board) {
        UUID locationId = UUID.fromString("07c3b467-bc60-4f05-8e34-599ce288fafc");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, BoardCardSettings.class);
    }

    public BoardCardSettings getBoardCardSettings(String project, String team, String board) {
        UUID locationId = UUID.fromString("07c3b467-bc60-4f05-8e34-599ce288fafc");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, BoardCardSettings.class);
    }

    public BoardCardSettings getBoardCardSettings(UUID project, UUID team, String board) {
        UUID locationId = UUID.fromString("07c3b467-bc60-4f05-8e34-599ce288fafc");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, BoardCardSettings.class);
    }

    public BoardCardSettings updateBoardCardSettings(BoardCardSettings boardCardSettingsToSave, String project, String board) {
        UUID locationId = UUID.fromString("07c3b467-bc60-4f05-8e34-599ce288fafc");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, boardCardSettingsToSave, "application/json", "application/json");
        return super.sendRequest(httpRequest, BoardCardSettings.class);
    }

    public BoardCardSettings updateBoardCardSettings(BoardCardSettings boardCardSettingsToSave, UUID project, String board) {
        UUID locationId = UUID.fromString("07c3b467-bc60-4f05-8e34-599ce288fafc");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, boardCardSettingsToSave, "application/json", "application/json");
        return super.sendRequest(httpRequest, BoardCardSettings.class);
    }

    public BoardCardSettings updateBoardCardSettings(BoardCardSettings boardCardSettingsToSave, String project, String team, String board) {
        UUID locationId = UUID.fromString("07c3b467-bc60-4f05-8e34-599ce288fafc");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, boardCardSettingsToSave, "application/json", "application/json");
        return super.sendRequest(httpRequest, BoardCardSettings.class);
    }

    public BoardCardSettings updateBoardCardSettings(BoardCardSettings boardCardSettingsToSave, UUID project, UUID team, String board) {
        UUID locationId = UUID.fromString("07c3b467-bc60-4f05-8e34-599ce288fafc");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, boardCardSettingsToSave, "application/json", "application/json");
        return super.sendRequest(httpRequest, BoardCardSettings.class);
    }

    public BoardChart getBoardChart(String project, String board, String name) {
        UUID locationId = UUID.fromString("45fe888c-239e-49fd-958c-df1a1ab21d97");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        routeValues.put("name", name);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, BoardChart.class);
    }

    public BoardChart getBoardChart(UUID project, String board, String name) {
        UUID locationId = UUID.fromString("45fe888c-239e-49fd-958c-df1a1ab21d97");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        routeValues.put("name", name);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, BoardChart.class);
    }

    public BoardChart getBoardChart(String project, String team, String board, String name) {
        UUID locationId = UUID.fromString("45fe888c-239e-49fd-958c-df1a1ab21d97");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        routeValues.put("name", name);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, BoardChart.class);
    }

    public BoardChart getBoardChart(UUID project, UUID team, String board, String name) {
        UUID locationId = UUID.fromString("45fe888c-239e-49fd-958c-df1a1ab21d97");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        routeValues.put("name", name);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, BoardChart.class);
    }

    public ArrayList<BoardChartReference> getBoardCharts(String project, String board) {
        UUID locationId = UUID.fromString("45fe888c-239e-49fd-958c-df1a1ab21d97");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardChartReference>>(){});
    }

    public ArrayList<BoardChartReference> getBoardCharts(UUID project, String board) {
        UUID locationId = UUID.fromString("45fe888c-239e-49fd-958c-df1a1ab21d97");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardChartReference>>(){});
    }

    public ArrayList<BoardChartReference> getBoardCharts(String project, String team, String board) {
        UUID locationId = UUID.fromString("45fe888c-239e-49fd-958c-df1a1ab21d97");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardChartReference>>(){});
    }

    public ArrayList<BoardChartReference> getBoardCharts(UUID project, UUID team, String board) {
        UUID locationId = UUID.fromString("45fe888c-239e-49fd-958c-df1a1ab21d97");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardChartReference>>(){});
    }

    public BoardChart updateBoardChart(BoardChart chart, String project, String board, String name) {
        UUID locationId = UUID.fromString("45fe888c-239e-49fd-958c-df1a1ab21d97");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        routeValues.put("name", name);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, chart, "application/json", "application/json");
        return super.sendRequest(httpRequest, BoardChart.class);
    }

    public BoardChart updateBoardChart(BoardChart chart, UUID project, String board, String name) {
        UUID locationId = UUID.fromString("45fe888c-239e-49fd-958c-df1a1ab21d97");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        routeValues.put("name", name);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, chart, "application/json", "application/json");
        return super.sendRequest(httpRequest, BoardChart.class);
    }

    public BoardChart updateBoardChart(BoardChart chart, String project, String team, String board, String name) {
        UUID locationId = UUID.fromString("45fe888c-239e-49fd-958c-df1a1ab21d97");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        routeValues.put("name", name);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, chart, "application/json", "application/json");
        return super.sendRequest(httpRequest, BoardChart.class);
    }

    public BoardChart updateBoardChart(BoardChart chart, UUID project, UUID team, String board, String name) {
        UUID locationId = UUID.fromString("45fe888c-239e-49fd-958c-df1a1ab21d97");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        routeValues.put("name", name);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, chart, "application/json", "application/json");
        return super.sendRequest(httpRequest, BoardChart.class);
    }

    public ArrayList<BoardColumn> getBoardColumns(String project, String board) {
        UUID locationId = UUID.fromString("c555d7ff-84e1-47df-9923-a3fe0cd8751b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardColumn>>(){});
    }

    public ArrayList<BoardColumn> getBoardColumns(UUID project, String board) {
        UUID locationId = UUID.fromString("c555d7ff-84e1-47df-9923-a3fe0cd8751b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardColumn>>(){});
    }

    public ArrayList<BoardColumn> getBoardColumns(String project, String team, String board) {
        UUID locationId = UUID.fromString("c555d7ff-84e1-47df-9923-a3fe0cd8751b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardColumn>>(){});
    }

    public ArrayList<BoardColumn> getBoardColumns(UUID project, UUID team, String board) {
        UUID locationId = UUID.fromString("c555d7ff-84e1-47df-9923-a3fe0cd8751b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardColumn>>(){});
    }

    public ArrayList<BoardColumn> updateBoardColumns(List<BoardColumn> boardColumns, String project, String board) {
        UUID locationId = UUID.fromString("c555d7ff-84e1-47df-9923-a3fe0cd8751b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, boardColumns, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardColumn>>(){});
    }

    public ArrayList<BoardColumn> updateBoardColumns(List<BoardColumn> boardColumns, UUID project, String board) {
        UUID locationId = UUID.fromString("c555d7ff-84e1-47df-9923-a3fe0cd8751b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, boardColumns, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardColumn>>(){});
    }

    public ArrayList<BoardColumn> updateBoardColumns(List<BoardColumn> boardColumns, String project, String team, String board) {
        UUID locationId = UUID.fromString("c555d7ff-84e1-47df-9923-a3fe0cd8751b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, boardColumns, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardColumn>>(){});
    }

    public ArrayList<BoardColumn> updateBoardColumns(List<BoardColumn> boardColumns, UUID project, UUID team, String board) {
        UUID locationId = UUID.fromString("c555d7ff-84e1-47df-9923-a3fe0cd8751b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, boardColumns, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardColumn>>(){});
    }

    public DeliveryViewData getDeliveryTimelineData(String project, String team, String id, Date startDate, Date endDate, List<UUID> teamIds) {
        UUID locationId = UUID.fromString("bdd0834e-101f-49f0-a6ae-509f384a12b4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("startDate", startDate);
        queryParameters.addIfNotNull("endDate", endDate);
        queryParameters.addIfNotNull("teamIds", teamIds);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, DeliveryViewData.class);
    }

    public DeliveryViewData getDeliveryTimelineData(UUID project, UUID team, String id, Date startDate, Date endDate, List<UUID> teamIds) {
        UUID locationId = UUID.fromString("bdd0834e-101f-49f0-a6ae-509f384a12b4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("startDate", startDate);
        queryParameters.addIfNotNull("endDate", endDate);
        queryParameters.addIfNotNull("teamIds", teamIds);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, DeliveryViewData.class);
    }

    public DeliveryViewData getDeliveryTimelineData(String project, String id, Date startDate, Date endDate, List<UUID> teamIds) {
        UUID locationId = UUID.fromString("bdd0834e-101f-49f0-a6ae-509f384a12b4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("startDate", startDate);
        queryParameters.addIfNotNull("endDate", endDate);
        queryParameters.addIfNotNull("teamIds", teamIds);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, DeliveryViewData.class);
    }

    public DeliveryViewData getDeliveryTimelineData(UUID project, String id, Date startDate, Date endDate, List<UUID> teamIds) {
        UUID locationId = UUID.fromString("bdd0834e-101f-49f0-a6ae-509f384a12b4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("startDate", startDate);
        queryParameters.addIfNotNull("endDate", endDate);
        queryParameters.addIfNotNull("teamIds", teamIds);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, DeliveryViewData.class);
    }

    public void deleteTeamIteration(String project, UUID id) {
        UUID locationId = UUID.fromString("c9175577-28a1-4b06-9197-8636af9f64ad");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteTeamIteration(UUID project, UUID id) {
        UUID locationId = UUID.fromString("c9175577-28a1-4b06-9197-8636af9f64ad");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteTeamIteration(String project, String team, UUID id) {
        UUID locationId = UUID.fromString("c9175577-28a1-4b06-9197-8636af9f64ad");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteTeamIteration(UUID project, UUID team, UUID id) {
        UUID locationId = UUID.fromString("c9175577-28a1-4b06-9197-8636af9f64ad");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public TeamSettingsIteration getTeamIteration(String project, UUID id) {
        UUID locationId = UUID.fromString("c9175577-28a1-4b06-9197-8636af9f64ad");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TeamSettingsIteration.class);
    }

    public TeamSettingsIteration getTeamIteration(UUID project, UUID id) {
        UUID locationId = UUID.fromString("c9175577-28a1-4b06-9197-8636af9f64ad");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TeamSettingsIteration.class);
    }

    public TeamSettingsIteration getTeamIteration(String project, String team, UUID id) {
        UUID locationId = UUID.fromString("c9175577-28a1-4b06-9197-8636af9f64ad");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TeamSettingsIteration.class);
    }

    public TeamSettingsIteration getTeamIteration(UUID project, UUID team, UUID id) {
        UUID locationId = UUID.fromString("c9175577-28a1-4b06-9197-8636af9f64ad");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TeamSettingsIteration.class);
    }

    public ArrayList<TeamSettingsIteration> getTeamIterations(String project, String team, String timeframe) {
        UUID locationId = UUID.fromString("c9175577-28a1-4b06-9197-8636af9f64ad");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("$timeframe", timeframe);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TeamSettingsIteration>>(){});
    }

    public ArrayList<TeamSettingsIteration> getTeamIterations(UUID project, UUID team, String timeframe) {
        UUID locationId = UUID.fromString("c9175577-28a1-4b06-9197-8636af9f64ad");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("$timeframe", timeframe);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TeamSettingsIteration>>(){});
    }

    public ArrayList<TeamSettingsIteration> getTeamIterations(String project, String timeframe) {
        UUID locationId = UUID.fromString("c9175577-28a1-4b06-9197-8636af9f64ad");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("$timeframe", timeframe);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TeamSettingsIteration>>(){});
    }

    public ArrayList<TeamSettingsIteration> getTeamIterations(UUID project, String timeframe) {
        UUID locationId = UUID.fromString("c9175577-28a1-4b06-9197-8636af9f64ad");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("$timeframe", timeframe);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TeamSettingsIteration>>(){});
    }

    public TeamSettingsIteration postTeamIteration(TeamSettingsIteration iteration, String project) {
        UUID locationId = UUID.fromString("c9175577-28a1-4b06-9197-8636af9f64ad");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, iteration, "application/json", "application/json");
        return super.sendRequest(httpRequest, TeamSettingsIteration.class);
    }

    public TeamSettingsIteration postTeamIteration(TeamSettingsIteration iteration, UUID project) {
        UUID locationId = UUID.fromString("c9175577-28a1-4b06-9197-8636af9f64ad");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, iteration, "application/json", "application/json");
        return super.sendRequest(httpRequest, TeamSettingsIteration.class);
    }

    public TeamSettingsIteration postTeamIteration(TeamSettingsIteration iteration, String project, String team) {
        UUID locationId = UUID.fromString("c9175577-28a1-4b06-9197-8636af9f64ad");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, iteration, "application/json", "application/json");
        return super.sendRequest(httpRequest, TeamSettingsIteration.class);
    }

    public TeamSettingsIteration postTeamIteration(TeamSettingsIteration iteration, UUID project, UUID team) {
        UUID locationId = UUID.fromString("c9175577-28a1-4b06-9197-8636af9f64ad");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, iteration, "application/json", "application/json");
        return super.sendRequest(httpRequest, TeamSettingsIteration.class);
    }

    public Plan createPlan(CreatePlan postedPlan, String project) {
        UUID locationId = UUID.fromString("0b42cb47-cd73-4810-ac90-19c9ba147453");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, postedPlan, "application/json", "application/json");
        return super.sendRequest(httpRequest, Plan.class);
    }

    public Plan createPlan(CreatePlan postedPlan, UUID project) {
        UUID locationId = UUID.fromString("0b42cb47-cd73-4810-ac90-19c9ba147453");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, postedPlan, "application/json", "application/json");
        return super.sendRequest(httpRequest, Plan.class);
    }

    public Plan createPlan(CreatePlan postedPlan, String project, String team) {
        UUID locationId = UUID.fromString("0b42cb47-cd73-4810-ac90-19c9ba147453");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, postedPlan, "application/json", "application/json");
        return super.sendRequest(httpRequest, Plan.class);
    }

    public Plan createPlan(CreatePlan postedPlan, UUID project, UUID team) {
        UUID locationId = UUID.fromString("0b42cb47-cd73-4810-ac90-19c9ba147453");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, postedPlan, "application/json", "application/json");
        return super.sendRequest(httpRequest, Plan.class);
    }

    public void deletePlan(String project, String id) {
        UUID locationId = UUID.fromString("0b42cb47-cd73-4810-ac90-19c9ba147453");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deletePlan(UUID project, String id) {
        UUID locationId = UUID.fromString("0b42cb47-cd73-4810-ac90-19c9ba147453");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deletePlan(String project, String team, String id) {
        UUID locationId = UUID.fromString("0b42cb47-cd73-4810-ac90-19c9ba147453");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deletePlan(UUID project, UUID team, String id) {
        UUID locationId = UUID.fromString("0b42cb47-cd73-4810-ac90-19c9ba147453");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public Plan getPlan(String project, String id) {
        UUID locationId = UUID.fromString("0b42cb47-cd73-4810-ac90-19c9ba147453");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, Plan.class);
    }

    public Plan getPlan(UUID project, String id) {
        UUID locationId = UUID.fromString("0b42cb47-cd73-4810-ac90-19c9ba147453");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, Plan.class);
    }

    public Plan getPlan(String project, String team, String id) {
        UUID locationId = UUID.fromString("0b42cb47-cd73-4810-ac90-19c9ba147453");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, Plan.class);
    }

    public Plan getPlan(UUID project, UUID team, String id) {
        UUID locationId = UUID.fromString("0b42cb47-cd73-4810-ac90-19c9ba147453");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, Plan.class);
    }

    public ArrayList<Plan> getPlans(String project) {
        UUID locationId = UUID.fromString("0b42cb47-cd73-4810-ac90-19c9ba147453");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Plan>>(){});
    }

    public ArrayList<Plan> getPlans(UUID project) {
        UUID locationId = UUID.fromString("0b42cb47-cd73-4810-ac90-19c9ba147453");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Plan>>(){});
    }

    public ArrayList<Plan> getPlans(String project, String team) {
        UUID locationId = UUID.fromString("0b42cb47-cd73-4810-ac90-19c9ba147453");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Plan>>(){});
    }

    public ArrayList<Plan> getPlans(UUID project, UUID team) {
        UUID locationId = UUID.fromString("0b42cb47-cd73-4810-ac90-19c9ba147453");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<Plan>>(){});
    }

    public ProcessConfiguration getProcessConfiguration(String project) {
        UUID locationId = UUID.fromString("f901ba42-86d2-4b0c-89c1-3f86d06daa84");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, ProcessConfiguration.class);
    }

    public ProcessConfiguration getProcessConfiguration(UUID project) {
        UUID locationId = UUID.fromString("f901ba42-86d2-4b0c-89c1-3f86d06daa84");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, ProcessConfiguration.class);
    }

    public ArrayList<BoardRow> getBoardRows(String project, String board) {
        UUID locationId = UUID.fromString("0863355d-aefd-4d63-8669-984c9b7b0e78");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardRow>>(){});
    }

    public ArrayList<BoardRow> getBoardRows(UUID project, String board) {
        UUID locationId = UUID.fromString("0863355d-aefd-4d63-8669-984c9b7b0e78");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardRow>>(){});
    }

    public ArrayList<BoardRow> getBoardRows(String project, String team, String board) {
        UUID locationId = UUID.fromString("0863355d-aefd-4d63-8669-984c9b7b0e78");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardRow>>(){});
    }

    public ArrayList<BoardRow> getBoardRows(UUID project, UUID team, String board) {
        UUID locationId = UUID.fromString("0863355d-aefd-4d63-8669-984c9b7b0e78");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardRow>>(){});
    }

    public ArrayList<BoardRow> updateBoardRows(List<BoardRow> boardRows, String project, String board) {
        UUID locationId = UUID.fromString("0863355d-aefd-4d63-8669-984c9b7b0e78");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, boardRows, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardRow>>(){});
    }

    public ArrayList<BoardRow> updateBoardRows(List<BoardRow> boardRows, UUID project, String board) {
        UUID locationId = UUID.fromString("0863355d-aefd-4d63-8669-984c9b7b0e78");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, boardRows, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardRow>>(){});
    }

    public ArrayList<BoardRow> updateBoardRows(List<BoardRow> boardRows, String project, String team, String board) {
        UUID locationId = UUID.fromString("0863355d-aefd-4d63-8669-984c9b7b0e78");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, boardRows, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardRow>>(){});
    }

    public ArrayList<BoardRow> updateBoardRows(List<BoardRow> boardRows, UUID project, UUID team, String board) {
        UUID locationId = UUID.fromString("0863355d-aefd-4d63-8669-984c9b7b0e78");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("board", board);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, boardRows, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<BoardRow>>(){});
    }

    public TeamSettingsDaysOff getTeamDaysOff(String project, UUID iterationId) {
        UUID locationId = UUID.fromString("2d4faa2e-9150-4cbf-a47a-932b1b4a0773");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TeamSettingsDaysOff.class);
    }

    public TeamSettingsDaysOff getTeamDaysOff(UUID project, UUID iterationId) {
        UUID locationId = UUID.fromString("2d4faa2e-9150-4cbf-a47a-932b1b4a0773");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TeamSettingsDaysOff.class);
    }

    public TeamSettingsDaysOff getTeamDaysOff(String project, String team, UUID iterationId) {
        UUID locationId = UUID.fromString("2d4faa2e-9150-4cbf-a47a-932b1b4a0773");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TeamSettingsDaysOff.class);
    }

    public TeamSettingsDaysOff getTeamDaysOff(UUID project, UUID team, UUID iterationId) {
        UUID locationId = UUID.fromString("2d4faa2e-9150-4cbf-a47a-932b1b4a0773");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TeamSettingsDaysOff.class);
    }

    public TeamSettingsDaysOff updateTeamDaysOff(TeamSettingsDaysOffPatch daysOffPatch, String project, UUID iterationId) {
        UUID locationId = UUID.fromString("2d4faa2e-9150-4cbf-a47a-932b1b4a0773");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, daysOffPatch, "application/json", "application/json");
        return super.sendRequest(httpRequest, TeamSettingsDaysOff.class);
    }

    public TeamSettingsDaysOff updateTeamDaysOff(TeamSettingsDaysOffPatch daysOffPatch, UUID project, UUID iterationId) {
        UUID locationId = UUID.fromString("2d4faa2e-9150-4cbf-a47a-932b1b4a0773");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, daysOffPatch, "application/json", "application/json");
        return super.sendRequest(httpRequest, TeamSettingsDaysOff.class);
    }

    public TeamSettingsDaysOff updateTeamDaysOff(TeamSettingsDaysOffPatch daysOffPatch, String project, String team, UUID iterationId) {
        UUID locationId = UUID.fromString("2d4faa2e-9150-4cbf-a47a-932b1b4a0773");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, daysOffPatch, "application/json", "application/json");
        return super.sendRequest(httpRequest, TeamSettingsDaysOff.class);
    }

    public TeamSettingsDaysOff updateTeamDaysOff(TeamSettingsDaysOffPatch daysOffPatch, UUID project, UUID team, UUID iterationId) {
        UUID locationId = UUID.fromString("2d4faa2e-9150-4cbf-a47a-932b1b4a0773");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("iterationId", iterationId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, daysOffPatch, "application/json", "application/json");
        return super.sendRequest(httpRequest, TeamSettingsDaysOff.class);
    }

    public TeamFieldValues getTeamFieldValues(String project) {
        UUID locationId = UUID.fromString("07ced576-58ed-49e6-9c1e-5cb53ab8bf2a");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TeamFieldValues.class);
    }

    public TeamFieldValues getTeamFieldValues(UUID project) {
        UUID locationId = UUID.fromString("07ced576-58ed-49e6-9c1e-5cb53ab8bf2a");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TeamFieldValues.class);
    }

    public TeamFieldValues getTeamFieldValues(String project, String team) {
        UUID locationId = UUID.fromString("07ced576-58ed-49e6-9c1e-5cb53ab8bf2a");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TeamFieldValues.class);
    }

    public TeamFieldValues getTeamFieldValues(UUID project, UUID team) {
        UUID locationId = UUID.fromString("07ced576-58ed-49e6-9c1e-5cb53ab8bf2a");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TeamFieldValues.class);
    }

    public TeamFieldValues updateTeamFieldValues(TeamFieldValuesPatch patch, String project) {
        UUID locationId = UUID.fromString("07ced576-58ed-49e6-9c1e-5cb53ab8bf2a");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, patch, "application/json", "application/json");
        return super.sendRequest(httpRequest, TeamFieldValues.class);
    }

    public TeamFieldValues updateTeamFieldValues(TeamFieldValuesPatch patch, UUID project) {
        UUID locationId = UUID.fromString("07ced576-58ed-49e6-9c1e-5cb53ab8bf2a");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, patch, "application/json", "application/json");
        return super.sendRequest(httpRequest, TeamFieldValues.class);
    }

    public TeamFieldValues updateTeamFieldValues(TeamFieldValuesPatch patch, String project, String team) {
        UUID locationId = UUID.fromString("07ced576-58ed-49e6-9c1e-5cb53ab8bf2a");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, patch, "application/json", "application/json");
        return super.sendRequest(httpRequest, TeamFieldValues.class);
    }

    public TeamFieldValues updateTeamFieldValues(TeamFieldValuesPatch patch, UUID project, UUID team) {
        UUID locationId = UUID.fromString("07ced576-58ed-49e6-9c1e-5cb53ab8bf2a");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, patch, "application/json", "application/json");
        return super.sendRequest(httpRequest, TeamFieldValues.class);
    }

    public TeamSetting getTeamSettings(String project) {
        UUID locationId = UUID.fromString("c3c1012b-bea7-49d7-b45e-1664e566f84c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TeamSetting.class);
    }

    public TeamSetting getTeamSettings(UUID project) {
        UUID locationId = UUID.fromString("c3c1012b-bea7-49d7-b45e-1664e566f84c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TeamSetting.class);
    }

    public TeamSetting getTeamSettings(String project, String team) {
        UUID locationId = UUID.fromString("c3c1012b-bea7-49d7-b45e-1664e566f84c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TeamSetting.class);
    }

    public TeamSetting getTeamSettings(UUID project, UUID team) {
        UUID locationId = UUID.fromString("c3c1012b-bea7-49d7-b45e-1664e566f84c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TeamSetting.class);
    }

    public TeamSetting updateTeamSettings(TeamSettingsPatch teamSettingsPatch, String project) {
        UUID locationId = UUID.fromString("c3c1012b-bea7-49d7-b45e-1664e566f84c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, teamSettingsPatch, "application/json", "application/json");
        return super.sendRequest(httpRequest, TeamSetting.class);
    }

    public TeamSetting updateTeamSettings(TeamSettingsPatch teamSettingsPatch, UUID project) {
        UUID locationId = UUID.fromString("c3c1012b-bea7-49d7-b45e-1664e566f84c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, teamSettingsPatch, "application/json", "application/json");
        return super.sendRequest(httpRequest, TeamSetting.class);
    }

    public TeamSetting updateTeamSettings(TeamSettingsPatch teamSettingsPatch, String project, String team) {
        UUID locationId = UUID.fromString("c3c1012b-bea7-49d7-b45e-1664e566f84c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, teamSettingsPatch, "application/json", "application/json");
        return super.sendRequest(httpRequest, TeamSetting.class);
    }

    public TeamSetting updateTeamSettings(TeamSettingsPatch teamSettingsPatch, UUID project, UUID team) {
        UUID locationId = UUID.fromString("c3c1012b-bea7-49d7-b45e-1664e566f84c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, teamSettingsPatch, "application/json", "application/json");
        return super.sendRequest(httpRequest, TeamSetting.class);
    }
}

