/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.teamfoundation.workitemtracking.webapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.HttpMethod;
import com.microsoft.alm.client.VssHttpClientBase;
import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.VssRestRequest;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.AttachmentReference;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.CommentSortOrder;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.FieldDependentRule;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.FieldsToEvaluate;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.GetFieldsExpand;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.ProvisioningResult;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.QueryExpand;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.QueryHierarchyItem;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.ReportingRevisionsExpand;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.ReportingWorkItemLinksBatch;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.ReportingWorkItemRevisionsBatch;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.ReportingWorkItemRevisionsFilter;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.TreeStructureGroup;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.Wiql;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.WorkItem;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.WorkItemClassificationNode;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.WorkItemComment;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.WorkItemComments;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.WorkItemDelete;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.WorkItemDeleteReference;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.WorkItemDeleteUpdate;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.WorkItemErrorPolicy;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.WorkItemExpand;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.WorkItemField;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.WorkItemHistory;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.WorkItemQueryResult;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.WorkItemRelationType;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.WorkItemTemplate;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.WorkItemTemplateReference;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.WorkItemType;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.WorkItemTypeCategory;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.WorkItemTypeTemplate;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.WorkItemTypeTemplateUpdateModel;
import com.microsoft.alm.teamfoundation.workitemtracking.webapi.models.WorkItemUpdate;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import com.microsoft.alm.visualstudio.services.webapi.patch.json.JsonPatchDocument;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class WorkItemTrackingHttpClientBase
extends VssHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected WorkItemTrackingHttpClientBase(VssRestClientHandler clientHandler, URI baseUrl) {
        super(clientHandler, baseUrl);
    }

    @Override
    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public AttachmentReference createAttachment(InputStream uploadStream, String fileName, String uploadType) {
        UUID locationId = UUID.fromString("e07b5fa4-1499-494d-a496-64b860fd64ff");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("fileName", fileName);
        queryParameters.addIfNotEmpty("uploadType", uploadType);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, uploadStream, "application/octet-stream", queryParameters, "application/json");
        return super.sendRequest(httpRequest, AttachmentReference.class);
    }

    public InputStream getAttachmentContent(UUID id, String fileName) {
        UUID locationId = UUID.fromString("e07b5fa4-1499-494d-a496-64b860fd64ff");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/octet-stream");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getAttachmentZip(UUID id, String fileName) {
        UUID locationId = UUID.fromString("e07b5fa4-1499-494d-a496-64b860fd64ff");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("fileName", fileName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public ArrayList<WorkItemClassificationNode> getRootNodes(String project, Integer depth) {
        UUID locationId = UUID.fromString("a70579d1-f53a-48ee-a5be-7be8659023b9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$depth", depth);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<WorkItemClassificationNode>>(){});
    }

    public ArrayList<WorkItemClassificationNode> getRootNodes(UUID project, Integer depth) {
        UUID locationId = UUID.fromString("a70579d1-f53a-48ee-a5be-7be8659023b9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$depth", depth);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<WorkItemClassificationNode>>(){});
    }

    public WorkItemClassificationNode createOrUpdateClassificationNode(WorkItemClassificationNode postedNode, String project, TreeStructureGroup structureGroup, String path) {
        UUID locationId = UUID.fromString("5a172953-1b41-49d3-840a-33f79c3ce89f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("structureGroup", (Object)structureGroup);
        routeValues.put("path", path);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, postedNode, "application/json", "application/json");
        return super.sendRequest(httpRequest, WorkItemClassificationNode.class);
    }

    public WorkItemClassificationNode createOrUpdateClassificationNode(WorkItemClassificationNode postedNode, UUID project, TreeStructureGroup structureGroup, String path) {
        UUID locationId = UUID.fromString("5a172953-1b41-49d3-840a-33f79c3ce89f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("structureGroup", (Object)structureGroup);
        routeValues.put("path", path);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, postedNode, "application/json", "application/json");
        return super.sendRequest(httpRequest, WorkItemClassificationNode.class);
    }

    public void deleteClassificationNode(String project, TreeStructureGroup structureGroup, String path, Integer reclassifyId) {
        UUID locationId = UUID.fromString("5a172953-1b41-49d3-840a-33f79c3ce89f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("structureGroup", (Object)structureGroup);
        routeValues.put("path", path);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$reclassifyId", reclassifyId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, queryParameters, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteClassificationNode(UUID project, TreeStructureGroup structureGroup, String path, Integer reclassifyId) {
        UUID locationId = UUID.fromString("5a172953-1b41-49d3-840a-33f79c3ce89f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("structureGroup", (Object)structureGroup);
        routeValues.put("path", path);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$reclassifyId", reclassifyId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, queryParameters, "application/json");
        super.sendRequest(httpRequest);
    }

    public WorkItemClassificationNode getClassificationNode(String project, TreeStructureGroup structureGroup, String path, Integer depth) {
        UUID locationId = UUID.fromString("5a172953-1b41-49d3-840a-33f79c3ce89f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("structureGroup", (Object)structureGroup);
        routeValues.put("path", path);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$depth", depth);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, WorkItemClassificationNode.class);
    }

    public WorkItemClassificationNode getClassificationNode(UUID project, TreeStructureGroup structureGroup, String path, Integer depth) {
        UUID locationId = UUID.fromString("5a172953-1b41-49d3-840a-33f79c3ce89f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("structureGroup", (Object)structureGroup);
        routeValues.put("path", path);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$depth", depth);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, WorkItemClassificationNode.class);
    }

    public WorkItemClassificationNode updateClassificationNode(WorkItemClassificationNode postedNode, String project, TreeStructureGroup structureGroup, String path) {
        UUID locationId = UUID.fromString("5a172953-1b41-49d3-840a-33f79c3ce89f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("structureGroup", (Object)structureGroup);
        routeValues.put("path", path);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, postedNode, "application/json", "application/json");
        return super.sendRequest(httpRequest, WorkItemClassificationNode.class);
    }

    public WorkItemClassificationNode updateClassificationNode(WorkItemClassificationNode postedNode, UUID project, TreeStructureGroup structureGroup, String path) {
        UUID locationId = UUID.fromString("5a172953-1b41-49d3-840a-33f79c3ce89f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("structureGroup", (Object)structureGroup);
        routeValues.put("path", path);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, postedNode, "application/json", "application/json");
        return super.sendRequest(httpRequest, WorkItemClassificationNode.class);
    }

    public WorkItemComment getComment(int id, int revision) {
        UUID locationId = UUID.fromString("19335ae7-22f7-4308-93d8-261f9384b7cf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        routeValues.put("revision", revision);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, WorkItemComment.class);
    }

    public WorkItemComments getComments(int id, Integer fromRevision, Integer top, CommentSortOrder order) {
        UUID locationId = UUID.fromString("19335ae7-22f7-4308-93d8-261f9384b7cf");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("fromRevision", fromRevision);
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("order", order);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, WorkItemComments.class);
    }

    public WorkItemField getField(String field) {
        UUID locationId = UUID.fromString("b51fd764-e5c2-4b9b-aaf7-3395cf4bdd94");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("field", field);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, WorkItemField.class);
    }

    public ArrayList<WorkItemField> getFields(GetFieldsExpand expand) {
        UUID locationId = UUID.fromString("b51fd764-e5c2-4b9b-aaf7-3395cf4bdd94");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$expand", expand);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<WorkItemField>>(){});
    }

    public ArrayList<WorkItemHistory> getHistory(int id, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("f74eba29-47a1-4152-9381-84040aced527");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<WorkItemHistory>>(){});
    }

    public WorkItemHistory getHistoryById(int id, int revisionNumber) {
        UUID locationId = UUID.fromString("f74eba29-47a1-4152-9381-84040aced527");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        routeValues.put("revisionNumber", revisionNumber);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, WorkItemHistory.class);
    }

    public QueryHierarchyItem createQuery(QueryHierarchyItem postedQuery, String project, String query) {
        UUID locationId = UUID.fromString("a67d190c-c41f-424b-814d-0e906f659301");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("query", query);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, postedQuery, "application/json", "application/json");
        return super.sendRequest(httpRequest, QueryHierarchyItem.class);
    }

    public QueryHierarchyItem createQuery(QueryHierarchyItem postedQuery, UUID project, String query) {
        UUID locationId = UUID.fromString("a67d190c-c41f-424b-814d-0e906f659301");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("query", query);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, postedQuery, "application/json", "application/json");
        return super.sendRequest(httpRequest, QueryHierarchyItem.class);
    }

    public void deleteQuery(String project, String query) {
        UUID locationId = UUID.fromString("a67d190c-c41f-424b-814d-0e906f659301");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("query", query);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteQuery(UUID project, String query) {
        UUID locationId = UUID.fromString("a67d190c-c41f-424b-814d-0e906f659301");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("query", query);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public ArrayList<QueryHierarchyItem> getQueries(String project, QueryExpand expand, Integer depth, Boolean includeDeleted) {
        UUID locationId = UUID.fromString("a67d190c-c41f-424b-814d-0e906f659301");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$expand", expand);
        queryParameters.addIfNotNull("$depth", depth);
        queryParameters.addIfNotNull("$includeDeleted", includeDeleted);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<QueryHierarchyItem>>(){});
    }

    public ArrayList<QueryHierarchyItem> getQueries(UUID project, QueryExpand expand, Integer depth, Boolean includeDeleted) {
        UUID locationId = UUID.fromString("a67d190c-c41f-424b-814d-0e906f659301");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$expand", expand);
        queryParameters.addIfNotNull("$depth", depth);
        queryParameters.addIfNotNull("$includeDeleted", includeDeleted);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<QueryHierarchyItem>>(){});
    }

    public QueryHierarchyItem getQuery(String project, String query, QueryExpand expand, Integer depth, Boolean includeDeleted) {
        UUID locationId = UUID.fromString("a67d190c-c41f-424b-814d-0e906f659301");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("query", query);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$expand", expand);
        queryParameters.addIfNotNull("$depth", depth);
        queryParameters.addIfNotNull("$includeDeleted", includeDeleted);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, QueryHierarchyItem.class);
    }

    public QueryHierarchyItem getQuery(UUID project, String query, QueryExpand expand, Integer depth, Boolean includeDeleted) {
        UUID locationId = UUID.fromString("a67d190c-c41f-424b-814d-0e906f659301");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("query", query);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$expand", expand);
        queryParameters.addIfNotNull("$depth", depth);
        queryParameters.addIfNotNull("$includeDeleted", includeDeleted);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, QueryHierarchyItem.class);
    }

    public QueryHierarchyItem updateQuery(QueryHierarchyItem queryUpdate, String project, String query, Boolean undeleteDescendants) {
        UUID locationId = UUID.fromString("a67d190c-c41f-424b-814d-0e906f659301");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("query", query);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$undeleteDescendants", undeleteDescendants);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, queryUpdate, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, QueryHierarchyItem.class);
    }

    public QueryHierarchyItem updateQuery(QueryHierarchyItem queryUpdate, UUID project, String query, Boolean undeleteDescendants) {
        UUID locationId = UUID.fromString("a67d190c-c41f-424b-814d-0e906f659301");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("query", query);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$undeleteDescendants", undeleteDescendants);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, queryUpdate, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, QueryHierarchyItem.class);
    }

    public void destroyWorkItem(int id) {
        UUID locationId = UUID.fromString("b70d8d39-926c-465e-b927-b1bf0e5ca0e0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void destroyWorkItem(String project, int id) {
        UUID locationId = UUID.fromString("b70d8d39-926c-465e-b927-b1bf0e5ca0e0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void destroyWorkItem(UUID project, int id) {
        UUID locationId = UUID.fromString("b70d8d39-926c-465e-b927-b1bf0e5ca0e0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public WorkItemDelete getDeletedWorkItem(int id) {
        UUID locationId = UUID.fromString("b70d8d39-926c-465e-b927-b1bf0e5ca0e0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, WorkItemDelete.class);
    }

    public WorkItemDelete getDeletedWorkItem(String project, int id) {
        UUID locationId = UUID.fromString("b70d8d39-926c-465e-b927-b1bf0e5ca0e0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, WorkItemDelete.class);
    }

    public WorkItemDelete getDeletedWorkItem(UUID project, int id) {
        UUID locationId = UUID.fromString("b70d8d39-926c-465e-b927-b1bf0e5ca0e0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, WorkItemDelete.class);
    }

    public ArrayList<WorkItemDeleteReference> getDeletedWorkItems() {
        UUID locationId = UUID.fromString("b70d8d39-926c-465e-b927-b1bf0e5ca0e0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<WorkItemDeleteReference>>(){});
    }

    public ArrayList<WorkItemDeleteReference> getDeletedWorkItems(String project) {
        UUID locationId = UUID.fromString("b70d8d39-926c-465e-b927-b1bf0e5ca0e0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<WorkItemDeleteReference>>(){});
    }

    public ArrayList<WorkItemDeleteReference> getDeletedWorkItems(UUID project) {
        UUID locationId = UUID.fromString("b70d8d39-926c-465e-b927-b1bf0e5ca0e0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<WorkItemDeleteReference>>(){});
    }

    public ArrayList<WorkItemDeleteReference> getDeletedWorkItems(String project, List<Integer> ids) {
        UUID locationId = UUID.fromString("b70d8d39-926c-465e-b927-b1bf0e5ca0e0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("ids", ids);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<WorkItemDeleteReference>>(){});
    }

    public ArrayList<WorkItemDeleteReference> getDeletedWorkItems(UUID project, List<Integer> ids) {
        UUID locationId = UUID.fromString("b70d8d39-926c-465e-b927-b1bf0e5ca0e0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("ids", ids);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<WorkItemDeleteReference>>(){});
    }

    public ArrayList<WorkItemDeleteReference> getDeletedWorkItems(List<Integer> ids) {
        UUID locationId = UUID.fromString("b70d8d39-926c-465e-b927-b1bf0e5ca0e0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("ids", ids);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<WorkItemDeleteReference>>(){});
    }

    public WorkItemDelete restoreWorkItem(WorkItemDeleteUpdate payload, int id) {
        UUID locationId = UUID.fromString("b70d8d39-926c-465e-b927-b1bf0e5ca0e0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, payload, "application/json", "application/json");
        return super.sendRequest(httpRequest, WorkItemDelete.class);
    }

    public WorkItemDelete restoreWorkItem(WorkItemDeleteUpdate payload, String project, int id) {
        UUID locationId = UUID.fromString("b70d8d39-926c-465e-b927-b1bf0e5ca0e0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, payload, "application/json", "application/json");
        return super.sendRequest(httpRequest, WorkItemDelete.class);
    }

    public WorkItemDelete restoreWorkItem(WorkItemDeleteUpdate payload, UUID project, int id) {
        UUID locationId = UUID.fromString("b70d8d39-926c-465e-b927-b1bf0e5ca0e0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("id", id);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, payload, "application/json", "application/json");
        return super.sendRequest(httpRequest, WorkItemDelete.class);
    }

    public WorkItem getRevision(int id, int revisionNumber, WorkItemExpand expand) {
        UUID locationId = UUID.fromString("a00c85a5-80fa-4565-99c3-bcd2181434bb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        routeValues.put("revisionNumber", revisionNumber);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$expand", expand);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, WorkItem.class);
    }

    public ArrayList<WorkItem> getRevisions(int id, Integer top, Integer skip, WorkItemExpand expand) {
        UUID locationId = UUID.fromString("a00c85a5-80fa-4565-99c3-bcd2181434bb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        queryParameters.addIfNotNull("$expand", expand);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<WorkItem>>(){});
    }

    public void evaluateRulesOnField(FieldsToEvaluate ruleEngineInput) {
        UUID locationId = UUID.fromString("1a3a1536-dca6-4509-b9c3-dd9bb2981506");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, ruleEngineInput, "application/json", "application/json");
        super.sendRequest(httpRequest);
    }

    public WorkItemTemplate createTemplate(WorkItemTemplate template, String project, String team) {
        UUID locationId = UUID.fromString("6a90345f-a676-4969-afce-8e163e1d5642");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, template, "application/json", "application/json");
        return super.sendRequest(httpRequest, WorkItemTemplate.class);
    }

    public WorkItemTemplate createTemplate(WorkItemTemplate template, UUID project, UUID team) {
        UUID locationId = UUID.fromString("6a90345f-a676-4969-afce-8e163e1d5642");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, template, "application/json", "application/json");
        return super.sendRequest(httpRequest, WorkItemTemplate.class);
    }

    public ArrayList<WorkItemTemplateReference> getTemplates(String project, String team, String workitemtypename) {
        UUID locationId = UUID.fromString("6a90345f-a676-4969-afce-8e163e1d5642");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("workitemtypename", workitemtypename);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<WorkItemTemplateReference>>(){});
    }

    public ArrayList<WorkItemTemplateReference> getTemplates(UUID project, UUID team, String workitemtypename) {
        UUID locationId = UUID.fromString("6a90345f-a676-4969-afce-8e163e1d5642");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("workitemtypename", workitemtypename);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<WorkItemTemplateReference>>(){});
    }

    public void deleteTemplate(String project, String team, UUID templateId) {
        UUID locationId = UUID.fromString("fb10264a-8836-48a0-8033-1b0ccd2748d5");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("templateId", templateId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteTemplate(UUID project, UUID team, UUID templateId) {
        UUID locationId = UUID.fromString("fb10264a-8836-48a0-8033-1b0ccd2748d5");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("templateId", templateId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public WorkItemTemplate getTemplate(String project, String team, UUID templateId) {
        UUID locationId = UUID.fromString("fb10264a-8836-48a0-8033-1b0ccd2748d5");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("templateId", templateId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, WorkItemTemplate.class);
    }

    public WorkItemTemplate getTemplate(UUID project, UUID team, UUID templateId) {
        UUID locationId = UUID.fromString("fb10264a-8836-48a0-8033-1b0ccd2748d5");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("templateId", templateId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, WorkItemTemplate.class);
    }

    public WorkItemTemplate replaceTemplate(WorkItemTemplate templateContent, String project, String team, UUID templateId) {
        UUID locationId = UUID.fromString("fb10264a-8836-48a0-8033-1b0ccd2748d5");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("templateId", templateId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, templateContent, "application/json", "application/json");
        return super.sendRequest(httpRequest, WorkItemTemplate.class);
    }

    public WorkItemTemplate replaceTemplate(WorkItemTemplate templateContent, UUID project, UUID team, UUID templateId) {
        UUID locationId = UUID.fromString("fb10264a-8836-48a0-8033-1b0ccd2748d5");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("templateId", templateId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, templateContent, "application/json", "application/json");
        return super.sendRequest(httpRequest, WorkItemTemplate.class);
    }

    public WorkItemUpdate getUpdate(int id, int updateNumber) {
        UUID locationId = UUID.fromString("6570bf97-d02c-4a91-8d93-3abe9895b1a9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        routeValues.put("updateNumber", updateNumber);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, WorkItemUpdate.class);
    }

    public ArrayList<WorkItemUpdate> getUpdates(int id, Integer top, Integer skip) {
        UUID locationId = UUID.fromString("6570bf97-d02c-4a91-8d93-3abe9895b1a9");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", top);
        queryParameters.addIfNotNull("$skip", skip);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<WorkItemUpdate>>(){});
    }

    public WorkItemQueryResult queryByWiql(Wiql wiql, Boolean timePrecision, Integer top) {
        UUID locationId = UUID.fromString("1a9c53f7-f243-4447-b110-35ef023636e4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("timePrecision", timePrecision);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, wiql, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, WorkItemQueryResult.class);
    }

    public WorkItemQueryResult queryByWiql(Wiql wiql, String project, Boolean timePrecision, Integer top) {
        UUID locationId = UUID.fromString("1a9c53f7-f243-4447-b110-35ef023636e4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("timePrecision", timePrecision);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, wiql, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, WorkItemQueryResult.class);
    }

    public WorkItemQueryResult queryByWiql(Wiql wiql, UUID project, Boolean timePrecision, Integer top) {
        UUID locationId = UUID.fromString("1a9c53f7-f243-4447-b110-35ef023636e4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("timePrecision", timePrecision);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, wiql, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, WorkItemQueryResult.class);
    }

    public WorkItemQueryResult queryByWiql(Wiql wiql, String project, String team, Boolean timePrecision, Integer top) {
        UUID locationId = UUID.fromString("1a9c53f7-f243-4447-b110-35ef023636e4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("timePrecision", timePrecision);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, wiql, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, WorkItemQueryResult.class);
    }

    public WorkItemQueryResult queryByWiql(Wiql wiql, UUID project, UUID team, Boolean timePrecision, Integer top) {
        UUID locationId = UUID.fromString("1a9c53f7-f243-4447-b110-35ef023636e4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("timePrecision", timePrecision);
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, wiql, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, WorkItemQueryResult.class);
    }

    public WorkItemQueryResult queryById(String project, String team, UUID id, Boolean timePrecision) {
        UUID locationId = UUID.fromString("a02355f5-5f8a-4671-8e32-369d23aac83d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("timePrecision", timePrecision);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, WorkItemQueryResult.class);
    }

    public WorkItemQueryResult queryById(UUID project, UUID team, UUID id, Boolean timePrecision) {
        UUID locationId = UUID.fromString("a02355f5-5f8a-4671-8e32-369d23aac83d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("team", team);
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("timePrecision", timePrecision);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, WorkItemQueryResult.class);
    }

    public WorkItemQueryResult queryById(String project, UUID id, Boolean timePrecision) {
        UUID locationId = UUID.fromString("a02355f5-5f8a-4671-8e32-369d23aac83d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("timePrecision", timePrecision);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, WorkItemQueryResult.class);
    }

    public WorkItemQueryResult queryById(UUID project, UUID id, Boolean timePrecision) {
        UUID locationId = UUID.fromString("a02355f5-5f8a-4671-8e32-369d23aac83d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("timePrecision", timePrecision);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, WorkItemQueryResult.class);
    }

    public WorkItemQueryResult queryById(UUID id, Boolean timePrecision) {
        UUID locationId = UUID.fromString("a02355f5-5f8a-4671-8e32-369d23aac83d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("timePrecision", timePrecision);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, WorkItemQueryResult.class);
    }

    public ReportingWorkItemLinksBatch getReportingLinks(String project, List<String> types, String continuationToken, Date startDateTime) {
        UUID locationId = UUID.fromString("b5b5b6d0-0308-40a1-b3f4-b9bb3c66878f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("types", types);
        queryParameters.addIfNotEmpty("continuationToken", continuationToken);
        queryParameters.addIfNotNull("startDateTime", startDateTime);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, ReportingWorkItemLinksBatch.class);
    }

    public ReportingWorkItemLinksBatch getReportingLinks(UUID project, List<String> types, String continuationToken, Date startDateTime) {
        UUID locationId = UUID.fromString("b5b5b6d0-0308-40a1-b3f4-b9bb3c66878f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("types", types);
        queryParameters.addIfNotEmpty("continuationToken", continuationToken);
        queryParameters.addIfNotNull("startDateTime", startDateTime);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, ReportingWorkItemLinksBatch.class);
    }

    public ReportingWorkItemLinksBatch getReportingLinks(List<String> types, String continuationToken, Date startDateTime) {
        UUID locationId = UUID.fromString("b5b5b6d0-0308-40a1-b3f4-b9bb3c66878f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("types", types);
        queryParameters.addIfNotEmpty("continuationToken", continuationToken);
        queryParameters.addIfNotNull("startDateTime", startDateTime);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, ReportingWorkItemLinksBatch.class);
    }

    public WorkItemRelationType getRelationType(String relation) {
        UUID locationId = UUID.fromString("f5d33bc9-5b49-4a3c-a9bd-f3cd46dd2165");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("relation", relation);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, WorkItemRelationType.class);
    }

    public ArrayList<WorkItemRelationType> getRelationTypes() {
        UUID locationId = UUID.fromString("f5d33bc9-5b49-4a3c-a9bd-f3cd46dd2165");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<WorkItemRelationType>>(){});
    }

    public ReportingWorkItemRevisionsBatch readReportingRevisionsGet(String project, List<String> fields, List<String> types, String continuationToken, Date startDateTime, Boolean includeIdentityRef, Boolean includeDeleted, Boolean includeTagRef, Boolean includeLatestOnly, ReportingRevisionsExpand expand) {
        UUID locationId = UUID.fromString("f828fe59-dd87-495d-a17c-7a8d6211ca6c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("fields", fields);
        queryParameters.addIfNotNull("types", types);
        queryParameters.addIfNotEmpty("continuationToken", continuationToken);
        queryParameters.addIfNotNull("startDateTime", startDateTime);
        queryParameters.addIfNotNull("includeIdentityRef", includeIdentityRef);
        queryParameters.addIfNotNull("includeDeleted", includeDeleted);
        queryParameters.addIfNotNull("includeTagRef", includeTagRef);
        queryParameters.addIfNotNull("includeLatestOnly", includeLatestOnly);
        queryParameters.addIfNotNull("$expand", expand);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, ReportingWorkItemRevisionsBatch.class);
    }

    public ReportingWorkItemRevisionsBatch readReportingRevisionsGet(UUID project, List<String> fields, List<String> types, String continuationToken, Date startDateTime, Boolean includeIdentityRef, Boolean includeDeleted, Boolean includeTagRef, Boolean includeLatestOnly, ReportingRevisionsExpand expand) {
        UUID locationId = UUID.fromString("f828fe59-dd87-495d-a17c-7a8d6211ca6c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("fields", fields);
        queryParameters.addIfNotNull("types", types);
        queryParameters.addIfNotEmpty("continuationToken", continuationToken);
        queryParameters.addIfNotNull("startDateTime", startDateTime);
        queryParameters.addIfNotNull("includeIdentityRef", includeIdentityRef);
        queryParameters.addIfNotNull("includeDeleted", includeDeleted);
        queryParameters.addIfNotNull("includeTagRef", includeTagRef);
        queryParameters.addIfNotNull("includeLatestOnly", includeLatestOnly);
        queryParameters.addIfNotNull("$expand", expand);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, ReportingWorkItemRevisionsBatch.class);
    }

    public ReportingWorkItemRevisionsBatch readReportingRevisionsGet(List<String> fields, List<String> types, String continuationToken, Date startDateTime, Boolean includeIdentityRef, Boolean includeDeleted, Boolean includeTagRef, Boolean includeLatestOnly, ReportingRevisionsExpand expand) {
        UUID locationId = UUID.fromString("f828fe59-dd87-495d-a17c-7a8d6211ca6c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("fields", fields);
        queryParameters.addIfNotNull("types", types);
        queryParameters.addIfNotEmpty("continuationToken", continuationToken);
        queryParameters.addIfNotNull("startDateTime", startDateTime);
        queryParameters.addIfNotNull("includeIdentityRef", includeIdentityRef);
        queryParameters.addIfNotNull("includeDeleted", includeDeleted);
        queryParameters.addIfNotNull("includeTagRef", includeTagRef);
        queryParameters.addIfNotNull("includeLatestOnly", includeLatestOnly);
        queryParameters.addIfNotNull("$expand", expand);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, ReportingWorkItemRevisionsBatch.class);
    }

    public ReportingWorkItemRevisionsBatch readReportingRevisionsPost(ReportingWorkItemRevisionsFilter filter, String continuationToken, Date startDateTime, ReportingRevisionsExpand expand) {
        UUID locationId = UUID.fromString("f828fe59-dd87-495d-a17c-7a8d6211ca6c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("continuationToken", continuationToken);
        queryParameters.addIfNotNull("startDateTime", startDateTime);
        queryParameters.addIfNotNull("$expand", expand);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, filter, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, ReportingWorkItemRevisionsBatch.class);
    }

    public ReportingWorkItemRevisionsBatch readReportingRevisionsPost(ReportingWorkItemRevisionsFilter filter, String project, String continuationToken, Date startDateTime, ReportingRevisionsExpand expand) {
        UUID locationId = UUID.fromString("f828fe59-dd87-495d-a17c-7a8d6211ca6c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("continuationToken", continuationToken);
        queryParameters.addIfNotNull("startDateTime", startDateTime);
        queryParameters.addIfNotNull("$expand", expand);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, filter, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, ReportingWorkItemRevisionsBatch.class);
    }

    public ReportingWorkItemRevisionsBatch readReportingRevisionsPost(ReportingWorkItemRevisionsFilter filter, UUID project, String continuationToken, Date startDateTime, ReportingRevisionsExpand expand) {
        UUID locationId = UUID.fromString("f828fe59-dd87-495d-a17c-7a8d6211ca6c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("continuationToken", continuationToken);
        queryParameters.addIfNotNull("startDateTime", startDateTime);
        queryParameters.addIfNotNull("$expand", expand);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, filter, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, ReportingWorkItemRevisionsBatch.class);
    }

    public WorkItemDelete deleteWorkItem(int id, Boolean destroy) {
        UUID locationId = UUID.fromString("72c7ddf8-2cdc-4f60-90cd-ab71c14a399b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("destroy", destroy);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, WorkItemDelete.class);
    }

    public WorkItem getWorkItem(int id, List<String> fields, Date asOf, WorkItemExpand expand) {
        UUID locationId = UUID.fromString("72c7ddf8-2cdc-4f60-90cd-ab71c14a399b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("fields", fields);
        queryParameters.addIfNotNull("asOf", asOf);
        queryParameters.addIfNotNull("$expand", expand);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, WorkItem.class);
    }

    public ArrayList<WorkItem> getWorkItems(List<Integer> ids, List<String> fields, Date asOf, WorkItemExpand expand, WorkItemErrorPolicy errorPolicy) {
        UUID locationId = UUID.fromString("72c7ddf8-2cdc-4f60-90cd-ab71c14a399b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("ids", ids);
        queryParameters.addIfNotNull("fields", fields);
        queryParameters.addIfNotNull("asOf", asOf);
        queryParameters.addIfNotNull("$expand", expand);
        queryParameters.addIfNotNull("errorPolicy", errorPolicy);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<WorkItem>>(){});
    }

    public WorkItem updateWorkItem(JsonPatchDocument document, int id, Boolean validateOnly, Boolean bypassRules) {
        UUID locationId = UUID.fromString("72c7ddf8-2cdc-4f60-90cd-ab71c14a399b");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("id", id);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("validateOnly", validateOnly);
        queryParameters.addIfNotNull("bypassRules", bypassRules);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, document, "application/json-patch+json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, WorkItem.class);
    }

    public WorkItem createWorkItem(JsonPatchDocument document, String project, String type, Boolean validateOnly, Boolean bypassRules) {
        UUID locationId = UUID.fromString("62d3d110-0047-428c-ad3c-4fe872c91c74");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("type", type);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("validateOnly", validateOnly);
        queryParameters.addIfNotNull("bypassRules", bypassRules);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, document, "application/json-patch+json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, WorkItem.class);
    }

    public WorkItem createWorkItem(JsonPatchDocument document, UUID project, String type, Boolean validateOnly, Boolean bypassRules) {
        UUID locationId = UUID.fromString("62d3d110-0047-428c-ad3c-4fe872c91c74");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("type", type);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("validateOnly", validateOnly);
        queryParameters.addIfNotNull("bypassRules", bypassRules);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, document, "application/json-patch+json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, WorkItem.class);
    }

    public WorkItem getWorkItemTemplate(String project, String type, String fields, Date asOf, WorkItemExpand expand) {
        UUID locationId = UUID.fromString("62d3d110-0047-428c-ad3c-4fe872c91c74");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("type", type);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("fields", fields);
        queryParameters.addIfNotNull("asOf", asOf);
        queryParameters.addIfNotNull("$expand", expand);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, WorkItem.class);
    }

    public WorkItem getWorkItemTemplate(UUID project, String type, String fields, Date asOf, WorkItemExpand expand) {
        UUID locationId = UUID.fromString("62d3d110-0047-428c-ad3c-4fe872c91c74");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("type", type);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("fields", fields);
        queryParameters.addIfNotNull("asOf", asOf);
        queryParameters.addIfNotNull("$expand", expand);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, WorkItem.class);
    }

    public ArrayList<WorkItemTypeCategory> getWorkItemTypeCategories(String project) {
        UUID locationId = UUID.fromString("9b9f5734-36c8-415e-ba67-f83b45c31408");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<WorkItemTypeCategory>>(){});
    }

    public ArrayList<WorkItemTypeCategory> getWorkItemTypeCategories(UUID project) {
        UUID locationId = UUID.fromString("9b9f5734-36c8-415e-ba67-f83b45c31408");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<WorkItemTypeCategory>>(){});
    }

    public WorkItemTypeCategory getWorkItemTypeCategory(String project, String category) {
        UUID locationId = UUID.fromString("9b9f5734-36c8-415e-ba67-f83b45c31408");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("category", category);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, WorkItemTypeCategory.class);
    }

    public WorkItemTypeCategory getWorkItemTypeCategory(UUID project, String category) {
        UUID locationId = UUID.fromString("9b9f5734-36c8-415e-ba67-f83b45c31408");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("category", category);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, WorkItemTypeCategory.class);
    }

    public WorkItemType getWorkItemType(String project, String type) {
        UUID locationId = UUID.fromString("7c8d7a76-4a09-43e8-b5df-bd792f4ac6aa");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("type", type);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, WorkItemType.class);
    }

    public WorkItemType getWorkItemType(UUID project, String type) {
        UUID locationId = UUID.fromString("7c8d7a76-4a09-43e8-b5df-bd792f4ac6aa");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("type", type);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, WorkItemType.class);
    }

    public ArrayList<WorkItemType> getWorkItemTypes(String project) {
        UUID locationId = UUID.fromString("7c8d7a76-4a09-43e8-b5df-bd792f4ac6aa");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<WorkItemType>>(){});
    }

    public ArrayList<WorkItemType> getWorkItemTypes(UUID project) {
        UUID locationId = UUID.fromString("7c8d7a76-4a09-43e8-b5df-bd792f4ac6aa");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<WorkItemType>>(){});
    }

    public FieldDependentRule getDependentFields(String project, String type, String field) {
        UUID locationId = UUID.fromString("bd293ce5-3d25-4192-8e67-e8092e879efb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("type", type);
        routeValues.put("field", field);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, FieldDependentRule.class);
    }

    public FieldDependentRule getDependentFields(UUID project, String type, String field) {
        UUID locationId = UUID.fromString("bd293ce5-3d25-4192-8e67-e8092e879efb");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("type", type);
        routeValues.put("field", field);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, FieldDependentRule.class);
    }

    public WorkItemTypeTemplate exportWorkItemTypeDefinition(String project, String type, Boolean exportGlobalLists) {
        UUID locationId = UUID.fromString("8637ac8b-5eb6-4f90-b3f7-4f2ff576a459");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("type", type);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("exportGlobalLists", exportGlobalLists);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, WorkItemTypeTemplate.class);
    }

    public WorkItemTypeTemplate exportWorkItemTypeDefinition(UUID project, String type, Boolean exportGlobalLists) {
        UUID locationId = UUID.fromString("8637ac8b-5eb6-4f90-b3f7-4f2ff576a459");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("type", type);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("exportGlobalLists", exportGlobalLists);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, WorkItemTypeTemplate.class);
    }

    public WorkItemTypeTemplate exportWorkItemTypeDefinition(String type, Boolean exportGlobalLists) {
        UUID locationId = UUID.fromString("8637ac8b-5eb6-4f90-b3f7-4f2ff576a459");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("type", type);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("exportGlobalLists", exportGlobalLists);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, WorkItemTypeTemplate.class);
    }

    public ProvisioningResult updateWorkItemTypeDefinition(WorkItemTypeTemplateUpdateModel updateModel) {
        UUID locationId = UUID.fromString("8637ac8b-5eb6-4f90-b3f7-4f2ff576a459");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, updateModel, "application/json", "application/json");
        return super.sendRequest(httpRequest, ProvisioningResult.class);
    }

    public ProvisioningResult updateWorkItemTypeDefinition(WorkItemTypeTemplateUpdateModel updateModel, String project) {
        UUID locationId = UUID.fromString("8637ac8b-5eb6-4f90-b3f7-4f2ff576a459");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, updateModel, "application/json", "application/json");
        return super.sendRequest(httpRequest, ProvisioningResult.class);
    }

    public ProvisioningResult updateWorkItemTypeDefinition(WorkItemTypeTemplateUpdateModel updateModel, UUID project) {
        UUID locationId = UUID.fromString("8637ac8b-5eb6-4f90-b3f7-4f2ff576a459");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, updateModel, "application/json", "application/json");
        return super.sendRequest(httpRequest, ProvisioningResult.class);
    }
}

