/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.visualstudio.services.extensionmanagement.webapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.HttpMethod;
import com.microsoft.alm.client.VssHttpClientBase;
import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.VssRestRequest;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.visualstudio.services.extensionmanagement.webapi.DataProviderQuery;
import com.microsoft.alm.visualstudio.services.extensionmanagement.webapi.DataProviderResult;
import com.microsoft.alm.visualstudio.services.extensionmanagement.webapi.InstalledExtension;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class ContributionsHttpClientBase
extends VssHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected ContributionsHttpClientBase(VssRestClientHandler clientHandler, URI baseUrl) {
        super(clientHandler, baseUrl);
    }

    @Override
    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public DataProviderResult queryDataProviders(DataProviderQuery query) {
        UUID locationId = UUID.fromString("738368db-35ee-4b85-9f94-77ed34af2b0d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, query, "application/json", "application/json");
        return super.sendRequest(httpRequest, DataProviderResult.class);
    }

    public ArrayList<InstalledExtension> getInstalledExtensions(List<String> contributionIds, Boolean includeDisabledApps, List<String> assetTypes) {
        UUID locationId = UUID.fromString("2648442b-fd63-4b9a-902f-0c913510f139");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("contributionIds", contributionIds);
        queryParameters.addIfNotNull("includeDisabledApps", includeDisabledApps);
        queryParameters.addIfNotNull("assetTypes", assetTypes);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<InstalledExtension>>(){});
    }

    public InstalledExtension getInstalledExtensionByName(String publisherName, String extensionName, List<String> assetTypes) {
        UUID locationId = UUID.fromString("3e2f6668-0798-4dcb-b592-bfe2fa57fde2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("assetTypes", assetTypes);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, InstalledExtension.class);
    }
}

