/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.visualstudio.services.filecontainer.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.HttpMethod;
import com.microsoft.alm.client.VssHttpClientBase;
import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.VssRestRequest;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.visualstudio.services.filecontainer.FileContainer;
import com.microsoft.alm.visualstudio.services.filecontainer.FileContainerItem;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import com.microsoft.alm.visualstudio.services.webapi.VssJsonCollectionWrapper;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class FileContainerHttpClientBase
extends VssHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected FileContainerHttpClientBase(VssRestClientHandler clientHandler, URI baseUrl) {
        super(clientHandler, baseUrl);
    }

    @Override
    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public FileContainerItem createItem(InputStream uploadStream, int containerId, String itemPath) {
        UUID locationId = UUID.fromString("e4f5c81e-e250-447b-9fef-bd48471bea5e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.3");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("containerId", containerId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("itemPath", itemPath);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, uploadStream, "application/octet-stream", queryParameters, "application/json");
        return super.sendRequest(httpRequest, FileContainerItem.class);
    }

    public FileContainerItem createItem(InputStream uploadStream, int containerId, String itemPath, UUID scope) {
        UUID locationId = UUID.fromString("e4f5c81e-e250-447b-9fef-bd48471bea5e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.3");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("containerId", containerId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("itemPath", itemPath);
        queryParameters.addIfNotNull("scope", scope);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, uploadStream, "application/octet-stream", queryParameters, "application/json");
        return super.sendRequest(httpRequest, FileContainerItem.class);
    }

    public ArrayList<FileContainerItem> createItems(VssJsonCollectionWrapper<List<FileContainerItem>> items, int containerId) {
        UUID locationId = UUID.fromString("e4f5c81e-e250-447b-9fef-bd48471bea5e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.3");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("containerId", containerId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, items, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<FileContainerItem>>(){});
    }

    public ArrayList<FileContainerItem> createItems(VssJsonCollectionWrapper<List<FileContainerItem>> items, int containerId, UUID scope) {
        UUID locationId = UUID.fromString("e4f5c81e-e250-447b-9fef-bd48471bea5e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.3");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("containerId", containerId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("scope", scope);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, items, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<FileContainerItem>>(){});
    }

    public void deleteItem(long containerId, String itemPath) {
        UUID locationId = UUID.fromString("e4f5c81e-e250-447b-9fef-bd48471bea5e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.3");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("containerId", containerId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("itemPath", itemPath);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, queryParameters, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteItem(long containerId, String itemPath, UUID scope) {
        UUID locationId = UUID.fromString("e4f5c81e-e250-447b-9fef-bd48471bea5e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.3");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("containerId", containerId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("itemPath", itemPath);
        queryParameters.addIfNotNull("scope", scope);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, queryParameters, "application/json");
        super.sendRequest(httpRequest);
    }

    public ArrayList<FileContainer> getContainers(String artifactUris) {
        UUID locationId = UUID.fromString("e4f5c81e-e250-447b-9fef-bd48471bea5e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.3");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("artifactUris", artifactUris);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<FileContainer>>(){});
    }

    public ArrayList<FileContainer> getContainers(UUID scope, String artifactUris) {
        UUID locationId = UUID.fromString("e4f5c81e-e250-447b-9fef-bd48471bea5e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.3");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("scope", scope);
        queryParameters.addIfNotEmpty("artifactUris", artifactUris);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<FileContainer>>(){});
    }

    public ArrayList<FileContainerItem> getItems(long containerId, String itemPath, Boolean metadata, String format, String downloadFileName, Boolean includeDownloadTickets, Boolean isShallow) {
        UUID locationId = UUID.fromString("e4f5c81e-e250-447b-9fef-bd48471bea5e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.3");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("containerId", containerId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("itemPath", itemPath);
        queryParameters.addIfNotNull("metadata", metadata);
        queryParameters.addIfNotEmpty("$format", format);
        queryParameters.addIfNotEmpty("downloadFileName", downloadFileName);
        queryParameters.addIfNotNull("includeDownloadTickets", includeDownloadTickets);
        queryParameters.addIfNotNull("isShallow", isShallow);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<FileContainerItem>>(){});
    }

    public ArrayList<FileContainerItem> getItems(long containerId, UUID scope, String itemPath, Boolean metadata, String format, String downloadFileName, Boolean includeDownloadTickets, Boolean isShallow) {
        UUID locationId = UUID.fromString("e4f5c81e-e250-447b-9fef-bd48471bea5e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.3");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("containerId", containerId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("scope", scope);
        queryParameters.addIfNotEmpty("itemPath", itemPath);
        queryParameters.addIfNotNull("metadata", metadata);
        queryParameters.addIfNotEmpty("$format", format);
        queryParameters.addIfNotEmpty("downloadFileName", downloadFileName);
        queryParameters.addIfNotNull("includeDownloadTickets", includeDownloadTickets);
        queryParameters.addIfNotNull("isShallow", isShallow);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<FileContainerItem>>(){});
    }

    public ArrayList<FileContainerItem> browseItems(long container, String itemPath) {
        UUID locationId = UUID.fromString("e71a64ac-b2b5-4230-a4c0-dad657cf97e2");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.3");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("container", container);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("itemPath", itemPath);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<FileContainerItem>>(){});
    }
}

