/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.flags;

import com.microsoft.tfs.util.BitField;
import ms.tfs.build.buildservice._04._BuildStatus;

public class BuildStatus
extends BitField
implements Comparable {
    public static final BuildStatus NONE = new BuildStatus(0, _BuildStatus._BuildStatus_Flag.None);
    public static final BuildStatus IN_PROGRESS = new BuildStatus(1, _BuildStatus._BuildStatus_Flag.InProgress);
    public static final BuildStatus SUCCEEDED = new BuildStatus(2, _BuildStatus._BuildStatus_Flag.Succeeded);
    public static final BuildStatus PARTIALLY_SUCCEEDED = new BuildStatus(4, _BuildStatus._BuildStatus_Flag.PartiallySucceeded);
    public static final BuildStatus FAILED = new BuildStatus(8, _BuildStatus._BuildStatus_Flag.Failed);
    public static final BuildStatus STOPPED = new BuildStatus(16, _BuildStatus._BuildStatus_Flag.Stopped);
    public static final BuildStatus NOT_STARTED = new BuildStatus(32, _BuildStatus._BuildStatus_Flag.NotStarted);
    public static final BuildStatus ALL = new BuildStatus(63, _BuildStatus._BuildStatus_Flag.All);

    private BuildStatus(int flags, _BuildStatus._BuildStatus_Flag flag) {
        super(flags);
        BuildStatus.registerStringValue(this.getClass(), flags, flag.toString());
    }

    private BuildStatus(int flags) {
        super(flags);
    }

    public _BuildStatus getWebServiceObject() {
        return new _BuildStatus(this.toFullStringValues());
    }

    public static BuildStatus fromWebServiceObject(_BuildStatus buildStatus) {
        if (buildStatus == null) {
            return null;
        }
        return new BuildStatus(BuildStatus.webServiceObjectToFlags(buildStatus));
    }

    private static int webServiceObjectToFlags(_BuildStatus buildStatus) {
        _BuildStatus._BuildStatus_Flag[] flagArray = buildStatus.getFlags();
        String[] flagStrings = new String[flagArray.length];
        for (int i = 0; i < flagArray.length; ++i) {
            flagStrings[i] = flagArray[i].toString();
        }
        return BuildStatus.fromStringValues(flagStrings, BuildStatus.class);
    }

    public static BuildStatus combine(BuildStatus[] buildStatus) {
        return new BuildStatus(BitField.combine(buildStatus));
    }

    public boolean containsAll(BuildStatus other) {
        return this.containsAllInternal(other);
    }

    public boolean contains(BuildStatus other) {
        return this.containsInternal(other);
    }

    public boolean containsAny(BuildStatus other) {
        return this.containsAnyInternal(other);
    }

    public BuildStatus remove(BuildStatus other) {
        return new BuildStatus(this.removeInternal(other));
    }

    public BuildStatus retain(BuildStatus other) {
        return new BuildStatus(this.retainInternal(other));
    }

    public BuildStatus combine(BuildStatus other) {
        return new BuildStatus(this.combineInternal(other));
    }

    public int compareTo(Object o) {
        int thisSortPosition = BuildStatus.getSortPosition(this);
        int otherSortposition = BuildStatus.getSortPosition((BuildStatus)o);
        return thisSortPosition - otherSortposition;
    }

    private static final int getSortPosition(BuildStatus buildStatus) {
        if (buildStatus.contains(IN_PROGRESS)) {
            return 1;
        }
        if (buildStatus.contains(SUCCEEDED)) {
            return 2;
        }
        if (buildStatus.contains(PARTIALLY_SUCCEEDED)) {
            return 5;
        }
        if (buildStatus.contains(FAILED)) {
            return 3;
        }
        if (buildStatus.contains(STOPPED)) {
            return 4;
        }
        if (buildStatus.contains(NOT_STARTED)) {
            return 0;
        }
        return 0;
    }
}

