/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.soapextensions;

import com.microsoft.tfs.core.clients.build.IRetentionPolicy;
import com.microsoft.tfs.core.clients.build.ISchedule;
import com.microsoft.tfs.core.clients.build.flags.BuildServerVersion;
import com.microsoft.tfs.core.clients.build.flags.DefinitionQueueStatus;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDefinition;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildGroupItem2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.ProcessTemplate2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.RetentionPolicy2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.Schedule2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.TFS2010Helper;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.WorkspaceTemplate;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.WorkspaceTemplate2010;
import com.microsoft.tfs.core.clients.build.internal.utils.XamlHelper;
import com.microsoft.tfs.core.clients.build.soapextensions.ContinuousIntegrationType;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.util.StringUtil;
import java.util.Properties;
import ms.tfs.build.buildservice._03._BuildDefinition;
import ms.tfs.build.buildservice._03._ContinuousIntegrationType;
import ms.tfs.build.buildservice._03._ProcessTemplate;
import ms.tfs.build.buildservice._03._RetentionPolicy;
import ms.tfs.build.buildservice._03._Schedule;
import ms.tfs.build.buildservice._03._WorkspaceTemplate;

public class BuildDefinition2010
extends BuildGroupItem2010 {
    public BuildDefinition2010(_BuildDefinition webServiceObject) {
        super(webServiceObject);
    }

    public BuildDefinition2010(BuildServerVersion version, BuildDefinition definition) {
        super(new _BuildDefinition());
        this.setBuildControllerURI(definition.getBuildControllerURI());
        this.setContinuousIntegrationQuietPeriod(definition.getContinuousIntegrationQuietPeriod());
        this.setContinuousIntegrationType(TFS2010Helper.convert(definition.getTriggerType()));
        this.setDefaultDropLocation(definition.getDefaultDropLocation());
        this.setDescription(definition.getDescription());
        this.setEnabled(definition.getQueueStatus().equals(DefinitionQueueStatus.ENABLED) || definition.getQueueStatus().equals(DefinitionQueueStatus.PAUSED));
        this.setLastBuildUri(definition.getLastBuildURI());
        this.setLastGoodBuildLabel(definition.getLastGoodBuildLabel());
        this.setLastGoodBuildUri(definition.getLastGoodBuildURI());
        IRetentionPolicy[] policies = definition.getRetentionPolicies();
        this.setRetentionPolicies(TFS2010Helper.convert(policies));
        ISchedule[] schedules = definition.getSchedules();
        this.setSchedules(TFS2010Helper.convert(schedules));
        this.setURI(definition.getURI());
        this.setWorkspaceTemplate(TFS2010Helper.convert((WorkspaceTemplate)definition.getWorkspace()));
        this.setFullPath(definition.getWebServiceObject().getFullPath());
        if (version.isV2()) {
            this.setDefaultBuildAgentURI(this.getBuildControllerURI());
            if (!StringUtil.isNullOrEmpty(definition.getProcessParameters())) {
                Properties parameters = XamlHelper.loadPartial(definition.getProcessParameters());
                String key = "ConfigurationFolderPath";
                if (parameters != null && parameters.containsKey("ConfigurationFolderPath")) {
                    String configurationFolderPath = (String)parameters.get("ConfigurationFolderPath");
                    this.setConfigurationFolderURI(definition.getConfigurationFolderUri(configurationFolderPath));
                }
            } else if (definition.getConfigurationFolderPath() != null) {
                this.setConfigurationFolderURI(definition.getConfigurationFolderUri(definition.getConfigurationFolderPath()));
            }
        } else if (version.isV3()) {
            this.setProcess(TFS2010Helper.convert(definition.getProcess()));
            this.setProcessParameters(definition.getProcessParameters());
        }
    }

    @Override
    public _BuildDefinition getWebServiceObject() {
        return (_BuildDefinition)this.webServiceObject;
    }

    public String getBuildControllerURI() {
        return this.getWebServiceObject().getBuildControllerUri();
    }

    public String getConfigurationFolderURI() {
        return this.getWebServiceObject().getConfigurationFolderUri();
    }

    public int getContinuousIntegrationQuietPeriod() {
        return this.getWebServiceObject().getContinuousIntegrationQuietPeriod();
    }

    public ContinuousIntegrationType getContinuousIntegrationType() {
        _ContinuousIntegrationType _cit = this.getWebServiceObject().getContinuousIntegrationType();
        return _cit == null ? null : new ContinuousIntegrationType(_cit);
    }

    public String getDefaultBuildAgentURI() {
        return this.getWebServiceObject().getDefaultBuildAgentUri();
    }

    public String getDefaultDropLocation() {
        return this.getWebServiceObject().getDefaultDropLocation();
    }

    public String getDescription() {
        return this.getWebServiceObject().getDescription();
    }

    public boolean isEnabled() {
        return this.getWebServiceObject().isEnabled();
    }

    public String getLastBuildURI() {
        return this.getWebServiceObject().getLastBuildUri();
    }

    public String getLastGoodBuildLabel() {
        return this.getWebServiceObject().getLastGoodBuildLabel();
    }

    public String getLastGoodBuildURI() {
        return this.getWebServiceObject().getLastGoodBuildUri();
    }

    public int getMaxTimeout() {
        return this.getWebServiceObject().getMaxTimeout();
    }

    public ProcessTemplate2010 getProcess() {
        _ProcessTemplate _process = this.getWebServiceObject().getProcess();
        return _process == null ? null : new ProcessTemplate2010(_process);
    }

    public String getProcessParameters() {
        return this.getWebServiceObject().getProcessParameters();
    }

    public RetentionPolicy2010[] getRetentionPolicies() {
        return (RetentionPolicy2010[])WrapperUtils.wrap(RetentionPolicy2010.class, this.getWebServiceObject().getRetentionPolicies());
    }

    public Schedule2010[] getSchedules() {
        return (Schedule2010[])WrapperUtils.wrap(Schedule2010.class, this.getWebServiceObject().getSchedules());
    }

    public WorkspaceTemplate2010 getWorkspaceTemplate() {
        _WorkspaceTemplate _template = this.getWebServiceObject().getWorkspaceTemplate();
        return _template == null ? null : new WorkspaceTemplate2010(_template);
    }

    public void setBuildControllerURI(String value) {
        this.getWebServiceObject().setBuildControllerUri(value);
    }

    public void setConfigurationFolderURI(String value) {
        this.getWebServiceObject().setConfigurationFolderUri(value);
    }

    public void setContinuousIntegrationQuietPeriod(int value) {
        this.getWebServiceObject().setContinuousIntegrationQuietPeriod(value);
    }

    public void setContinuousIntegrationType(ContinuousIntegrationType continuousIntegrationType) {
        this.getWebServiceObject().setContinuousIntegrationType(continuousIntegrationType.getWebServiceObject());
    }

    public void setDefaultBuildAgentURI(String value) {
        this.getWebServiceObject().setDefaultBuildAgentUri(value);
    }

    public void setDefaultDropLocation(String value) {
        this.getWebServiceObject().setDefaultDropLocation(value);
    }

    public void setDescription(String description) {
        this.getWebServiceObject().setDescription(description);
    }

    public void setEnabled(boolean enabled) {
        this.getWebServiceObject().setEnabled(enabled);
    }

    public void setLastBuildUri(String value) {
        this.getWebServiceObject().setLastBuildUri(value);
    }

    public void setLastGoodBuildLabel(String value) {
        this.getWebServiceObject().setLastGoodBuildLabel(value);
    }

    public void setLastGoodBuildUri(String value) {
        this.getWebServiceObject().setLastGoodBuildUri(value);
    }

    public void setMaxTimeout(int value) {
        this.getWebServiceObject().setMaxTimeout(value);
    }

    public void setProcess(ProcessTemplate2010 value) {
        this.getWebServiceObject().setProcess(value.getWebServiceObject());
    }

    public void setProcessParameters(String processParamaters) {
        this.getWebServiceObject().setProcessParameters(processParamaters);
    }

    public void setRetentionPolicies(RetentionPolicy2010[] value) {
        this.getWebServiceObject().setRetentionPolicies((_RetentionPolicy[])WrapperUtils.unwrap(_RetentionPolicy.class, value));
    }

    public void setSchedules(Schedule2010[] value) {
        this.getWebServiceObject().setSchedules((_Schedule[])WrapperUtils.unwrap(_Schedule.class, value));
    }

    public void setWorkspaceTemplate(WorkspaceTemplate2010 value) {
        this.getWebServiceObject().setWorkspaceTemplate(value.getWebServiceObject());
    }

    @Override
    public void setURI(String value) {
        this.getWebServiceObject().setUri(value);
    }
}

