/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.soapextensions;

import com.microsoft.tfs.core.clients.build.IBuildInformation;
import com.microsoft.tfs.core.clients.build.IBuildInformationNode;
import com.microsoft.tfs.core.clients.build.InformationNodeConverters;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDetail;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildInformationNode;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildServer;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.InformationChangeRequest;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.InformationDeleteRequest;
import com.microsoft.tfs.core.clients.build.internal.utils.BuildTypeConvertor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BuildInformation
implements IBuildInformation {
    private static final Log log = LogFactory.getLog(BuildInformation.class);
    private final BuildDetail build;
    private final List<BuildInformationNode> nodes;
    private final BuildInformationNode owner;

    public BuildInformation(BuildDetail build, BuildInformationNode[] informationNodes) {
        this(build, (BuildInformationNode)null);
        if (informationNodes.length > 0) {
            Map<Integer, BuildInformationNode> children;
            HashMap nodeParentDict = new HashMap();
            for (BuildInformationNode node : informationNodes) {
                children = (HashMap)nodeParentDict.get(node.getParentID());
                if (children == null) {
                    children = new HashMap();
                    nodeParentDict.put(node.getParentID(), children);
                }
                node.setBuild(build);
                if (!children.containsKey(node.getID())) {
                    children.put(node.getID(), node);
                    continue;
                }
                log.warn((Object)"Duplicate information nodes present in a build!");
            }
            for (BuildInformationNode node : informationNodes) {
                children = (Map)nodeParentDict.get(node.getID());
                if (children == null) continue;
                BuildInformation theChildren = (BuildInformation)node.getChildren();
                Collection values = children.values();
                Object[] array = values.toArray(new BuildInformationNode[values.size()]);
                Arrays.sort(array);
                for (Object child : array) {
                    ((BuildInformationNode)child).setParent(node);
                    ((BuildInformationNode)child).setOwner(theChildren);
                    theChildren.add((BuildInformationNode)child);
                }
            }
            for (BuildInformationNode node : informationNodes) {
                if (node.getParent() != null) continue;
                node.setOwner(this);
                this.add(node);
            }
        }
    }

    public BuildInformation(BuildDetail build, BuildInformationNode owner) {
        this.build = build;
        this.owner = owner;
        this.nodes = new ArrayList<BuildInformationNode>();
    }

    @Override
    public IBuildInformationNode[] getNodes() {
        return this.nodes.toArray(new IBuildInformationNode[this.nodes.size()]);
    }

    @Override
    public IBuildInformationNode createNode() {
        BuildInformationNode newNode = this.owner == null ? new BuildInformationNode(this.build, this) : new BuildInformationNode(this.build, this.owner);
        this.nodes.add(newNode);
        return newNode;
    }

    public void deleteNode(IBuildInformationNode node) {
        this.nodes.remove(node);
    }

    public void add(BuildInformationNode node) {
        node.setParent(this.owner);
        this.nodes.add(node);
    }

    @Override
    public void delete() {
        ArrayList<InformationDeleteRequest> requests = new ArrayList<InformationDeleteRequest>();
        for (IBuildInformationNode node : this.getNodes()) {
            if (node.getID() <= 0) continue;
            InformationDeleteRequest deleteRequest = new InformationDeleteRequest();
            deleteRequest.setBuildURI(this.build.getURI());
            deleteRequest.setNodeID(node.getID());
            requests.add(deleteRequest);
        }
        if (requests.size() > 0) {
            BuildServer buildServer = (BuildServer)this.build.getBuildServer();
            InformationChangeRequest[] changes = requests.toArray(new InformationChangeRequest[requests.size()]);
            if (buildServer.getBuildServerVersion().isV2()) {
                buildServer.getBuild2008Helper().updateBuildInformation(changes);
            } else if (buildServer.getBuildServerVersion().isV3()) {
                buildServer.getBuild2010Helper().updateBuildInformation(changes);
            } else {
                buildServer.getBuildService().updateBuildInformation(changes);
            }
        }
        this.nodes.clear();
    }

    @Override
    public IBuildInformationNode getNode(int id) {
        IBuildInformationNode result = null;
        for (IBuildInformationNode node : this.getNodes()) {
            result = node.getID() == id ? node : node.getChildren().getNode(id);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    @Override
    public IBuildInformationNode[] getNodesByType(String type) {
        return this.getNodesByType(type, false);
    }

    @Override
    public IBuildInformationNode[] getNodesByType(String type, boolean recursive) {
        ArrayList<IBuildInformationNode> result = new ArrayList<IBuildInformationNode>();
        for (IBuildInformationNode node : this.getNodes()) {
            if (node.getType().equals(type)) {
                result.add(node);
            }
            if (!recursive) continue;
            IBuildInformationNode[] children = node.getChildren().getNodesByType(type, true);
            BuildTypeConvertor.addArrayToList(result, children);
        }
        return result.toArray(new IBuildInformationNode[result.size()]);
    }

    @Override
    public IBuildInformationNode[] getNodesByTypes(String[] types) {
        return this.getNodesByTypes(types, false);
    }

    @Override
    public IBuildInformationNode[] getNodesByTypes(String[] types, boolean recursive) {
        ArrayList<IBuildInformationNode> result = new ArrayList<IBuildInformationNode>();
        for (IBuildInformationNode node : this.getNodes()) {
            for (String type : types) {
                if (!node.getType().equals(type)) continue;
                result.add(node);
            }
            if (!recursive) continue;
            IBuildInformationNode[] children = node.getChildren().getNodesByTypes(types, true);
            BuildTypeConvertor.addArrayToList(result, children);
        }
        return result.toArray(new IBuildInformationNode[result.size()]);
    }

    @Override
    public IBuildInformationNode[] getSortedNodesByType(String type, Comparator<IBuildInformationNode> comparator) {
        ArrayList<IBuildInformationNode> result = new ArrayList<IBuildInformationNode>();
        IBuildInformationNode[] nodes = this.getNodesByType(type);
        Arrays.sort(nodes, comparator);
        for (IBuildInformationNode node : nodes) {
            result.add(node);
            IBuildInformationNode[] children = node.getChildren().getSortedNodesByType(type, comparator);
            BuildTypeConvertor.addArrayToList(result, children);
        }
        return result.toArray(new IBuildInformationNode[result.size()]);
    }

    @Override
    public IBuildInformationNode[] getSortedNodesByTypes(String[] types, Comparator<IBuildInformationNode> comparator) {
        ArrayList<IBuildInformationNode> result = new ArrayList<IBuildInformationNode>();
        IBuildInformationNode[] list = this.getNodesByTypes(types);
        Arrays.sort(list, comparator);
        for (IBuildInformationNode node : list) {
            result.add(node);
            IBuildInformationNode[] children = node.getChildren().getSortedNodesByTypes(types, comparator);
            BuildTypeConvertor.addArrayToList(result, children);
        }
        return result.toArray(new IBuildInformationNode[result.size()]);
    }

    @Override
    public IBuildInformationNode[] getSortedNodes(Comparator<IBuildInformationNode> comparator) {
        ArrayList<IBuildInformationNode> result = new ArrayList<IBuildInformationNode>();
        IBuildInformationNode[] nodes = this.getNodes();
        Arrays.sort(nodes, comparator);
        for (IBuildInformationNode node : nodes) {
            result.add(node);
            IBuildInformationNode[] children = node.getChildren().getSortedNodes(comparator);
            BuildTypeConvertor.addArrayToList(result, children);
        }
        return result.toArray(new IBuildInformationNode[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        Object object = this.build.syncSave;
        synchronized (object) {
            ArrayList<InformationChangeRequest> requests = new ArrayList<InformationChangeRequest>();
            if (this.owner != null) {
                requests.addAll(this.owner.getRequests(true));
            } else {
                for (IBuildInformationNode node : this.getNodes()) {
                    requests.addAll(((BuildInformationNode)node).getRequests(false));
                }
            }
            InformationNodeConverters.bulkUpdateInformationNodes(this.build, requests);
        }
    }

    public BuildDetail getBuild() {
        return this.build;
    }

    public static <T> void addToList(List<T> list, T[] items) {
        for (T item : items) {
            list.add(item);
        }
    }
}

