/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.soapextensions;

import com.microsoft.tfs.core.clients.build.IBuildAgent;
import com.microsoft.tfs.core.clients.build.IBuildController;
import com.microsoft.tfs.core.clients.build.IBuildServer;
import com.microsoft.tfs.core.clients.build.IBuildServiceHost;
import com.microsoft.tfs.core.clients.build.flags.BuildServiceHostUpdate;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildAgent;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildAgent2008;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildController;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildServiceHost2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildServiceHostUpdateOptions;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.ServiceHostStatus;
import com.microsoft.tfs.core.clients.build.soapextensions.AgentStatus;
import com.microsoft.tfs.core.clients.build.soapextensions.ControllerStatus;
import com.microsoft.tfs.core.exceptions.NotSupportedException;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.datetime.DotNETDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import ms.tfs.build.buildservice._04._BuildServiceHost;

public class BuildServiceHost
extends WebServiceObjectWrapper
implements IBuildServiceHost {
    private final IBuildServer buildServer;
    private IBuildController controller;
    private BuildServiceHostUpdateOptions lastSnapshot;
    private final List<IBuildAgent> agents = new ArrayList<IBuildAgent>();

    private BuildServiceHost(IBuildServer buildServer) {
        super(new _BuildServiceHost());
        Check.notNull(buildServer, "buildServer");
        this.buildServer = buildServer;
        this.getWebServiceObject().setStatus(ServiceHostStatus.OFFLINE.getWebServiceObject());
        this.getWebServiceObject().setStatusChangedOn(DotNETDate.MIN_CALENDAR);
    }

    public BuildServiceHost(IBuildServer buildServer, _BuildServiceHost webServiceObject) {
        super(webServiceObject);
        Check.notNull(buildServer, "buildServer");
        this.buildServer = buildServer;
        this.lastSnapshot = this.getSnapshot();
    }

    public BuildServiceHost(IBuildServer buildServer, BuildAgent2008 agent2008) {
        this(buildServer);
        this.setName(agent2008.getMachineName());
        this.setRequireClientCertificates(false);
        this.setURI(agent2008.getURI());
        this.lastSnapshot = this.getSnapshot();
    }

    public BuildServiceHost(IBuildServer buildServer, String uri, IBuildController controller, String name) {
        this(buildServer, new _BuildServiceHost());
        this.setURI(uri);
        this.setName(name);
        this.controller = controller;
    }

    public BuildServiceHost(IBuildServer buildServer, String name, String baseUrl) {
        this(buildServer);
        this.setBaseURL(baseUrl);
        this.setName(name);
        this.lastSnapshot = this.getSnapshot();
    }

    public BuildServiceHost(IBuildServer buildServer, BuildServiceHost2010 serviceHost2010) {
        this(buildServer);
        this.setBaseURL(serviceHost2010.getBaseURL());
        this.setName(serviceHost2010.getName());
        this.setRequireClientCertificates(serviceHost2010.isRequireClientCertificates());
        this.setURI(serviceHost2010.getURI());
        this.lastSnapshot = this.getSnapshot();
    }

    public _BuildServiceHost getWebServiceObject() {
        return (_BuildServiceHost)this.webServiceObject;
    }

    @Override
    public String getBaseURL() {
        return this.getWebServiceObject().getBaseUrl();
    }

    @Override
    public void setBaseURL(String value) {
        this.getWebServiceObject().setBaseUrl(value);
    }

    @Override
    public boolean isVirtual() {
        return this.getWebServiceObject().isIsVirtual();
    }

    @Override
    public String getMessageQueueURL() {
        return this.getWebServiceObject().getMessageQueueUrl();
    }

    @Override
    public String getName() {
        return this.getWebServiceObject().getName();
    }

    @Override
    public void setName(String value) {
        this.getWebServiceObject().setName(value);
    }

    @Override
    public boolean isRequireClientCertificates() {
        return this.getWebServiceObject().isRequireClientCertificates();
    }

    @Override
    public void setRequireClientCertificates(boolean value) {
        this.getWebServiceObject().setRequireClientCertificates(value);
    }

    public ServiceHostStatus getStatus() {
        return ServiceHostStatus.fromWebServiceObject(this.getWebServiceObject().getStatus());
    }

    public Calendar getStatusChangedOn() {
        return this.getWebServiceObject().getStatusChangedOn();
    }

    @Override
    public String getURI() {
        return this.getWebServiceObject().getUri();
    }

    public void setURI(String value) {
        this.getWebServiceObject().setUri(value);
    }

    @Override
    public IBuildServer getBuildServer() {
        return this.buildServer;
    }

    @Override
    public IBuildController getController() {
        return this.controller;
    }

    @Override
    public IBuildAgent[] getAgents() {
        return this.agents.toArray(new IBuildAgent[this.agents.size()]);
    }

    @Override
    public IBuildController createBuildController(String name) {
        BuildController controller = new BuildController(this.buildServer, this, name);
        controller.setStatus(ControllerStatus.OFFLINE);
        controller.setEnabled(true);
        controller.setMaxConcurrentBuilds(0);
        this.controller = controller;
        return controller;
    }

    @Override
    public void setBuildAgentStatus(IBuildAgent agent, AgentStatus status, String message) {
        agent.setStatus(status);
        agent.setStatusMessage(message);
        agent.save();
    }

    @Override
    public void setBuildControllerStatus(ControllerStatus status, String message) {
        if (this.controller != null) {
            this.controller.setStatus(status);
            this.controller.setStatusMessage(message);
            this.controller.save();
        }
    }

    @Override
    public void takeOwnership() {
        throw new NotSupportedException();
    }

    @Override
    public void releaseOwnership() {
        throw new NotSupportedException();
    }

    @Override
    public IBuildAgent createBuildAgent(String name, String buildDirectory) {
        return this.createBuildAgent(name, buildDirectory, this.controller);
    }

    @Override
    public IBuildAgent createBuildAgent(String name, String buildDirectory, IBuildController buildController) {
        BuildAgent buildAgent = new BuildAgent(this, name, buildDirectory);
        buildAgent.setController(buildController);
        buildAgent.setStatus(AgentStatus.OFFLINE);
        buildAgent.setEnabled(true);
        this.agents.add(buildAgent);
        return buildAgent;
    }

    @Override
    public void addBuildAgent(IBuildAgent agent) {
        ((BuildAgent)agent).setServiceHost(this);
        this.agents.add(agent);
    }

    public BuildServiceHostUpdateOptions getSnapshot() {
        BuildServiceHostUpdateOptions options = new BuildServiceHostUpdateOptions();
        options.setURI(this.getURI());
        options.setBaseURL(this.getBaseURL());
        options.setName(this.getName());
        options.setRequireClientCertificates(this.isRequireClientCertificates());
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildServiceHostUpdateOptions getUpdateOptions() {
        BuildServiceHostUpdateOptions currentSnapshot;
        BuildServiceHostUpdateOptions buildServiceHostUpdateOptions = this.lastSnapshot;
        synchronized (buildServiceHostUpdateOptions) {
            currentSnapshot = this.getSnapshot();
            currentSnapshot.setFields(this.compareSnapshots(this.lastSnapshot, currentSnapshot));
        }
        return currentSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpdateOptions(BuildServiceHostUpdateOptions options) {
        BuildServiceHostUpdateOptions buildServiceHostUpdateOptions = this.lastSnapshot;
        synchronized (buildServiceHostUpdateOptions) {
            this.lastSnapshot = options;
        }
    }

    private BuildServiceHostUpdate compareSnapshots(BuildServiceHostUpdateOptions originalValues, BuildServiceHostUpdateOptions modifiedValues) {
        BuildServiceHostUpdate result = BuildServiceHostUpdate.NONE;
        if (!originalValues.getBaseURL().equals(modifiedValues.getBaseURL())) {
            result = result.combine(BuildServiceHostUpdate.BASE_URI);
        }
        if (!originalValues.getName().equalsIgnoreCase(modifiedValues.getName())) {
            result = result.combine(BuildServiceHostUpdate.NAME);
        }
        if (originalValues.isRequireClientCertificates() != modifiedValues.isRequireClientCertificates()) {
            result = result.combine(BuildServiceHostUpdate.REQUIRE_CLIENT_CERTIFICATE);
        }
        return result;
    }

    @Override
    public void setBuildController(IBuildController controller) {
        if (controller != null) {
            ((BuildController)controller).setServiceHost(this);
        }
        this.controller = controller;
    }

    @Override
    public void delete() {
        if (this.getURI() != null) {
            this.buildServer.deleteBuildServiceHost(this.getURI());
        }
    }

    @Override
    public void save() {
        this.buildServer.saveBuildServiceHost(this);
    }

    @Override
    public void deleteBuildController() {
        this.controller.delete();
        this.controller = null;
    }

    @Override
    public IBuildAgent findBuildAgent(String controller, String name) {
        for (IBuildAgent a : this.agents) {
            if (!a.getName().equals(name) || !a.getController().getName().equals(controller)) continue;
            return a;
        }
        return null;
    }

    @Override
    public boolean deleteBuildAgent(IBuildAgent agent) {
        for (IBuildAgent a : this.agents) {
            if (!a.getName().equals(agent.getName()) || !a.getController().getName().equals(agent.getController().getName())) continue;
            a.delete();
            this.agents.remove(agent);
            return true;
        }
        return false;
    }
}

