/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.soapextensions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.build.IBuildDefinition;
import com.microsoft.tfs.core.clients.build.ISchedule;
import com.microsoft.tfs.core.clients.build.flags.ScheduleDays;
import com.microsoft.tfs.core.clients.build.flags.ScheduleType;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDefinition;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.Schedule2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.TFS2010Helper;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.util.datetime.CalendarUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import ms.tfs.build.buildservice._04._Schedule;

public class Schedule
extends WebServiceObjectWrapper
implements ISchedule {
    private IBuildDefinition buildDefinition;
    private final String TIMEZONE_UTC_DOTNET_ID = "UTC";
    private final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");
    private final TimeZone TIMEZONE_DEFAULT = TimeZone.getDefault();
    private final Locale LOCALE_DEFAULT = Locale.getDefault();

    public Schedule(_Schedule schedule) {
        super(schedule);
    }

    public Schedule() {
        this(new _Schedule());
        this.getWebServiceObject().setTimeZoneId("UTC");
    }

    public Schedule(IBuildDefinition buildDefinition) {
        this();
        this.buildDefinition = buildDefinition;
    }

    public Schedule(BuildDefinition buildDefinition, Schedule2010 schedule2010) {
        this(buildDefinition);
        _Schedule _o = this.getWebServiceObject();
        _o.setTimeZoneId(schedule2010.getWebServiceObject().getTimeZoneId());
        _o.setUtcDaysToBuild(TFS2010Helper.convert(schedule2010.getUtcDaysToBuild()).getWebServiceObject());
        _o.setUtcStartTime(schedule2010.getUtcStartTime());
    }

    public _Schedule getWebServiceObject() {
        return (_Schedule)this.webServiceObject;
    }

    @Override
    public IBuildDefinition getBuildDefinition() {
        return this.buildDefinition;
    }

    public void setBuildDefinition(IBuildDefinition buildDefinition) {
        this.buildDefinition = buildDefinition;
    }

    @Override
    public ScheduleDays getDaysToBuild() {
        return this.getLocalDaysToBuildFromSchedule();
    }

    @Override
    public ScheduleType getType() {
        return ScheduleType.WEEKLY;
    }

    @Override
    public int getStartTime() {
        return this.getLocalTimeFromSchedule();
    }

    @Override
    public void setDaysToBuild(ScheduleDays days) {
        this.setScheduleFromLocationTime(this.getStartTime(), days);
    }

    @Override
    public void setStartTime(int secondsPastMidnight) {
        this.setScheduleFromLocationTime(secondsPastMidnight, this.getDaysToBuild());
    }

    protected int getLocalTimeFromSchedule() {
        GregorianCalendar startTime = new GregorianCalendar(this.TIMEZONE_UTC, this.LOCALE_DEFAULT);
        Schedule.removeTime(startTime);
        ((Calendar)startTime).add(13, this.getWebServiceObject().getUtcStartTime());
        ((Calendar)startTime).setTimeZone(this.TIMEZONE_DEFAULT);
        return Schedule.getSecondsSinceMidnight(startTime);
    }

    protected ScheduleDays getLocalDaysToBuildFromSchedule() {
        Calendar firstDayOfWeek = this.getFirstDayOfWeek(new GregorianCalendar(this.TIMEZONE_UTC, this.LOCALE_DEFAULT));
        ArrayList<Calendar> daysMatched = new ArrayList<Calendar>();
        int utcSecondsSinceMidnight = this.getWebServiceObject().getUtcStartTime();
        ScheduleDays utcDays = new ScheduleDays(this.getWebServiceObject().getUtcDaysToBuild());
        if (utcDays.contains(ScheduleDays.SUNDAY)) {
            daysMatched.add(this.getLocalDate(firstDayOfWeek, 0, utcSecondsSinceMidnight));
        }
        if (utcDays.contains(ScheduleDays.MONDAY)) {
            daysMatched.add(this.getLocalDate(firstDayOfWeek, 1, utcSecondsSinceMidnight));
        }
        if (utcDays.contains(ScheduleDays.TUESDAY)) {
            daysMatched.add(this.getLocalDate(firstDayOfWeek, 2, utcSecondsSinceMidnight));
        }
        if (utcDays.contains(ScheduleDays.WEDNESDAY)) {
            daysMatched.add(this.getLocalDate(firstDayOfWeek, 3, utcSecondsSinceMidnight));
        }
        if (utcDays.contains(ScheduleDays.THURSDAY)) {
            daysMatched.add(this.getLocalDate(firstDayOfWeek, 4, utcSecondsSinceMidnight));
        }
        if (utcDays.contains(ScheduleDays.FRIDAY)) {
            daysMatched.add(this.getLocalDate(firstDayOfWeek, 5, utcSecondsSinceMidnight));
        }
        if (utcDays.contains(ScheduleDays.SATURDAY)) {
            daysMatched.add(this.getLocalDate(firstDayOfWeek, 6, utcSecondsSinceMidnight));
        }
        ScheduleDays days = new ScheduleDays();
        for (Calendar day : daysMatched) {
            ScheduleDays.Day other = Schedule.convert(day.get(7));
            days.add(other);
        }
        return days;
    }

    protected void setScheduleFromLocationTime(int secondsSinceMidnight, ScheduleDays daysToBuild) {
        Calendar firstDayOfWeek = this.getFirstDayOfWeek(Calendar.getInstance());
        ArrayList<Calendar> daysMatched = new ArrayList<Calendar>();
        if (daysToBuild.contains(ScheduleDays.SUNDAY)) {
            daysMatched.add(this.getUTCDate(firstDayOfWeek, 0, secondsSinceMidnight));
        }
        if (daysToBuild.contains(ScheduleDays.MONDAY)) {
            daysMatched.add(this.getUTCDate(firstDayOfWeek, 1, secondsSinceMidnight));
        }
        if (daysToBuild.contains(ScheduleDays.TUESDAY)) {
            daysMatched.add(this.getUTCDate(firstDayOfWeek, 2, secondsSinceMidnight));
        }
        if (daysToBuild.contains(ScheduleDays.WEDNESDAY)) {
            daysMatched.add(this.getUTCDate(firstDayOfWeek, 3, secondsSinceMidnight));
        }
        if (daysToBuild.contains(ScheduleDays.THURSDAY)) {
            daysMatched.add(this.getUTCDate(firstDayOfWeek, 4, secondsSinceMidnight));
        }
        if (daysToBuild.contains(ScheduleDays.FRIDAY)) {
            daysMatched.add(this.getUTCDate(firstDayOfWeek, 5, secondsSinceMidnight));
        }
        if (daysToBuild.contains(ScheduleDays.SATURDAY)) {
            daysMatched.add(this.getUTCDate(firstDayOfWeek, 6, secondsSinceMidnight));
        }
        ScheduleDays days = new ScheduleDays();
        for (Calendar day : daysMatched) {
            ScheduleDays.Day other = Schedule.convert(day.get(7));
            days.add(other);
        }
        this.getWebServiceObject().setUtcDaysToBuild(days.getWebServiceObject());
        this.getWebServiceObject().setUtcStartTime(Schedule.getSecondsSinceMidnight(this.getUTCDate(Schedule.removeTime(new GregorianCalendar()), 0, secondsSinceMidnight)));
    }

    protected Calendar getLocalDate(Calendar firstDayOfWeek, int daysToAdd, int secondsToAdd) {
        Calendar day = (Calendar)firstDayOfWeek.clone();
        day.add(6, daysToAdd);
        day.add(13, secondsToAdd);
        day.setTimeZone(this.TIMEZONE_DEFAULT);
        return day;
    }

    protected Calendar getUTCDate(Calendar firstDayOfWeek, int daysToAdd, int secondsToAdd) {
        Calendar day = (Calendar)firstDayOfWeek.clone();
        day.add(6, daysToAdd);
        day.add(13, secondsToAdd);
        day.setTimeZone(this.TIMEZONE_UTC);
        return day;
    }

    protected Calendar getFirstDayOfWeek(Calendar referenceDate) {
        Calendar cal = (Calendar)referenceDate.clone();
        Schedule.removeTime(cal);
        while (cal.get(7) != 1) {
            cal.add(6, -1);
        }
        return cal;
    }

    protected static Calendar removeTime(Calendar date) {
        return CalendarUtils.removeTime(date);
    }

    protected static int getSecondsSinceMidnight(Calendar time) {
        return CalendarUtils.getSecondsSinceMidnight(time);
    }

    protected static ScheduleDays.Day convert(int dayOfWeek) {
        switch (dayOfWeek) {
            case 1: {
                return ScheduleDays.SUNDAY;
            }
            case 2: {
                return ScheduleDays.MONDAY;
            }
            case 3: {
                return ScheduleDays.TUESDAY;
            }
            case 4: {
                return ScheduleDays.WEDNESDAY;
            }
            case 5: {
                return ScheduleDays.THURSDAY;
            }
            case 6: {
                return ScheduleDays.FRIDAY;
            }
            case 7: {
                return ScheduleDays.SATURDAY;
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.getString("Schedule.DayOfWeekInvalidFormat"), dayOfWeek));
    }
}

