/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.utils;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;

public class BuildPath {
    public static final String PATH_SEPERATOR = "\\";
    public static final char PATH_SEPERATOR_CHAR = '\\';
    public static final String RECURSION_OPERATOR = "*";
    public static final String SLASH_RECURSION_OPERATOR = "\\*";
    public static final String ROOT_FOLDER = "\\";

    public static String getItemName(String buildPath) {
        Check.notNullOrEmpty(buildPath, "buildPath");
        int itemPos = buildPath.lastIndexOf("\\");
        if (itemPos <= 0) {
            return "";
        }
        return buildPath.substring(itemPos + 1);
    }

    public static String getTeamProject(String buildPath) {
        Check.notNullOrEmpty(buildPath, "buildPath");
        if (buildPath.charAt(0) != '\\') {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("BuildPath.PathMustBeginWithBackslashFormat"), buildPath));
        }
        int seperatorPos = buildPath.indexOf("\\", 1);
        if (seperatorPos < 0) {
            if (buildPath.length() <= 1) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("BuildPath.PathMustSpecifyATeamProjectFormat"), buildPath));
            }
            return buildPath.substring(1);
        }
        return buildPath.substring(1, seperatorPos);
    }

    public static String combine(String teamProject, String itemName) {
        StringBuffer path = new StringBuffer("\\");
        path.append(teamProject).append('\\');
        if (itemName != null) {
            path.append(itemName);
        }
        return path.toString();
    }

    public static String root(String rootPath, String relativePath) {
        if (relativePath != null && relativePath.length() > 0) {
            int i;
            for (i = 0; i < relativePath.length() && relativePath.charAt(i) == '\\'; ++i) {
            }
            String relativePart = i == 0 ? relativePath : relativePath.substring(i);
            return BuildPath.combine(rootPath, relativePart);
        }
        return BuildPath.combine(rootPath, relativePath);
    }
}

