/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.framework.catalog;

import com.microsoft.tfs.core.clients.framework.catalog.CatalogNode;
import java.util.ArrayList;
import java.util.HashMap;

public class CatalogDependencyGroup {
    private final HashMap<String, CatalogNode> singletons;
    private final HashMap<String, ArrayList<CatalogNode>> sets;

    public CatalogDependencyGroup() {
        this.singletons = new HashMap();
        this.sets = new HashMap();
    }

    public CatalogDependencyGroup(CatalogDependencyGroup dependencies) {
        this.singletons = new HashMap<String, CatalogNode>(dependencies.singletons);
        this.sets = new HashMap<String, ArrayList<CatalogNode>>(dependencies.sets);
    }

    public CatalogNode[] getAllDependencies() {
        ArrayList<CatalogNode> allDependencies = new ArrayList<CatalogNode>();
        allDependencies.addAll(this.singletons.values());
        for (ArrayList<CatalogNode> list : this.sets.values()) {
            allDependencies.addAll(list);
        }
        return allDependencies.toArray(new CatalogNode[allDependencies.size()]);
    }

    public void setSingletonDependency(String key, CatalogNode node) {
        this.singletons.put(key, node);
    }

    public void removeSingletonDependency(String key) {
        this.singletons.remove(key);
    }

    public CatalogNode getSingletonDependency(String key) {
        if (this.singletons.containsKey(key)) {
            return this.singletons.get(key);
        }
        return null;
    }

    public HashMap<String, CatalogNode> getSingletons() {
        return this.singletons;
    }

    public void addSetDependency(String key, CatalogNode node) {
        ArrayList<Object> dependencySet;
        if (!this.sets.containsKey(key)) {
            dependencySet = new ArrayList();
            this.sets.put(key, dependencySet);
        } else {
            dependencySet = this.sets.get(key);
        }
        dependencySet.add(node);
    }

    public void removeSetDependency(String key) {
        this.sets.remove(key);
    }

    public void removeSetDependency(String key, CatalogNode node) {
        if (this.sets.containsKey(key)) {
            ArrayList<CatalogNode> dependencySet = this.sets.get(key);
            for (int i = dependencySet.size() - 1; i >= 0; --i) {
                CatalogNode dependency = dependencySet.get(i);
                if (!node.getChildItem().equals(dependency.getChildItem())) continue;
                dependencySet.remove(i);
            }
            if (dependencySet.size() == 0) {
                this.sets.remove(key);
            }
        }
    }

    public CatalogNode[] getDependencySet(String key) {
        if (this.sets.containsKey(key)) {
            ArrayList<CatalogNode> dependencySet = this.sets.get(key);
            return dependencySet.toArray(new CatalogNode[dependencySet.size()]);
        }
        return new CatalogNode[0];
    }

    public HashMap<String, ArrayList<CatalogNode>> getSets() {
        return this.sets;
    }

    public void clearSingletonDependencies() {
        this.singletons.clear();
    }

    public void clearDependencySets() {
        this.sets.clear();
    }
}

