/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.framework.configuration.catalog;

import com.microsoft.tfs.core.clients.framework.catalog.CatalogNode;
import com.microsoft.tfs.core.clients.framework.configuration.catalog.TFSCatalogEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ProcessGuidanceEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ProjectPortalEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ReportingFolderEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.TeamProjectEntity;
import com.microsoft.tfs.core.clients.framework.configuration.internal.TFSCatalogEntitySession;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.StringUtil;

public class TeamProjectCatalogEntity
extends TFSCatalogEntity
implements TeamProjectEntity {
    private final String SOURCE_CONTROL_CAPABILITY_FLAGS = "SourceControlCapabilityFlags";
    private final String SOURCE_CONTROL_GIT_ENABLED = "SourceControlGitEnabled";
    private final String SOURCE_CONTROL_TFVC_ENABLED = "SourceControlTfvcEnabled";
    private final String SOURCE_CONTROL_CAPABILITY_FLAG_TFVC_VALUE = "1";
    private final String SOURCE_CONTROL_CAPABILITY_FLAG_GIT_VALUE = "2";

    public TeamProjectCatalogEntity(TFSCatalogEntitySession session, CatalogNode catalogNode) {
        super(session, catalogNode);
    }

    @Override
    public GUID getProjectID() {
        String projectId = this.getProperty("ProjectId");
        if (projectId == null) {
            return null;
        }
        return new GUID(projectId);
    }

    @Override
    public String getProjectName() {
        return this.getProperty("ProjectName");
    }

    @Override
    public String getProjectURI() {
        return this.getProperty("ProjectUri");
    }

    public boolean isGitSupported() {
        String gitEnabledProperty = this.getProperty("SourceControlGitEnabled");
        String capabilityFlagsProperty = this.getProperty("SourceControlCapabilityFlags");
        if (!StringUtil.isNullOrEmpty(gitEnabledProperty)) {
            return gitEnabledProperty.equalsIgnoreCase("true");
        }
        if (!StringUtil.isNullOrEmpty(capabilityFlagsProperty)) {
            return capabilityFlagsProperty.equals("2");
        }
        return false;
    }

    public boolean isTfvcSupported() {
        String tfvcEnabledProperty = this.getProperty("SourceControlTfvcEnabled");
        String capabilityFlagsProperty = this.getProperty("SourceControlCapabilityFlags");
        if (!StringUtil.isNullOrEmpty(tfvcEnabledProperty)) {
            return tfvcEnabledProperty.equalsIgnoreCase("true");
        }
        if (!StringUtil.isNullOrEmpty(capabilityFlagsProperty)) {
            return capabilityFlagsProperty.equals("1");
        }
        return true;
    }

    @Deprecated
    public String getSourceControlCapabilityFlags() {
        return this.getProperty("SourceControlCapabilityFlags");
    }

    @Override
    public ProcessGuidanceEntity getProcessGuidance() {
        return this.getChildOfType(ProcessGuidanceEntity.class);
    }

    @Override
    public ProjectPortalEntity getProjectPortal() {
        return this.getChildOfType(ProjectPortalEntity.class);
    }

    @Override
    public ReportingFolderEntity getReportingFolder() {
        return this.getChildOfType(ReportingFolderEntity.class);
    }
}

