/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.framework.configuration.internal;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.base64.Base64;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Base64GUIDParser {
    private static final Log log = LogFactory.getLog(Base64GUIDParser.class);
    private static final int BASE64_GUID_LENGTH = 24;

    public static GUID[] getGUIDPathFromBase64(String input) {
        Check.notNull(input, "input");
        ArrayList<GUID> guidList = new ArrayList<GUID>();
        int inputLen = input.length();
        if (inputLen % 24 != 0) {
            throw new IllegalArgumentException("The given string is not composed of base64 guid paths");
        }
        for (int i = 0; i < inputLen; i += 24) {
            guidList.add(Base64GUIDParser.getGUIDFromBase64(input, i));
        }
        return guidList.toArray(new GUID[guidList.size()]);
    }

    public static GUID getGUIDFromBase64(String base64) {
        Check.notNull(base64, "base64");
        return Base64GUIDParser.getGUIDFromBase64(base64, 0);
    }

    private static GUID getGUIDFromBase64(String input, int offset) {
        byte[] base64Bytes;
        Check.notNull(input, "input");
        if (input.length() < offset + 24) {
            throw new IllegalArgumentException("The given string is not a base64 guid value");
        }
        String guidPart = input.substring(offset, offset + 24);
        try {
            base64Bytes = guidPart.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            log.warn((Object)MessageFormat.format("Could not decode guid in encoding US-ASCII, falling back to {0}", Charset.defaultCharset().name()), (Throwable)e);
            base64Bytes = guidPart.getBytes();
        }
        if (!Base64.isArrayByteBase64(base64Bytes, false)) {
            throw new IllegalArgumentException("The given string is not a base64 guid value");
        }
        byte[] decodedBytes = Base64.decodeBase64(base64Bytes);
        return new GUID(decodedBytes);
    }

    private Base64GUIDParser() {
    }
}

