/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.framework.configuration.internal;

import com.microsoft.tfs.core.clients.framework.configuration.TFSEntity;
import com.microsoft.tfs.core.clients.framework.configuration.TFSWebSiteEntity;
import com.microsoft.tfs.core.util.URIUtils;
import com.microsoft.tfs.util.Check;
import java.util.Stack;

public class TFSWebSiteEntityUtils {
    public static String getFullItemPath(TFSWebSiteEntity entity) {
        Stack<String> pathStack = new Stack<String>();
        String url = null;
        TFSWebSiteEntity facet = entity;
        while (facet != null) {
            if (facet instanceof TFSWebSiteEntity.TFSRelativeWebSiteEntity) {
                TFSEntity parent;
                TFSWebSiteEntity.TFSRelativeWebSiteEntity relative = (TFSWebSiteEntity.TFSRelativeWebSiteEntity)facet;
                if (relative.getRelativePath() != null && relative.getRelativePath().length() > 0) {
                    pathStack.push(relative.getRelativePath());
                }
                if ((parent = relative.getReferencedResource()) == null) {
                    facet = null;
                    continue;
                }
                Check.isTrue(parent instanceof TFSWebSiteEntity, "parent instanceof TFSWebSiteEntity");
                facet = (TFSWebSiteEntity)((Object)parent);
                continue;
            }
            if (facet instanceof TFSWebSiteEntity.TFSAbsoluteWebSiteEntity) {
                TFSWebSiteEntity.TFSAbsoluteWebSiteEntity absolute = (TFSWebSiteEntity.TFSAbsoluteWebSiteEntity)facet;
                url = absolute.getBaseURL();
                Check.notNull(url, "url");
                break;
            }
            throw new RuntimeException("Invalid type along site path dependency chain");
        }
        while (pathStack.size() > 0) {
            url = URIUtils.combinePartiallyEncodedPaths(url, (String)pathStack.pop());
        }
        return url;
    }
}

