/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.registration.internal;

import com.microsoft.tfs.core.clients.registration.RegistrationData;
import com.microsoft.tfs.core.clients.registration.RegistrationEntry;
import com.microsoft.tfs.core.internal.persistence.StaxSerializer;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import ms.tfs.services.registration._03._FrameworkRegistrationEntry;

public class RegistrationDataSerializer
extends StaxSerializer {
    private static final int SCHEMA_VERSION = 1;
    private static final String REGISTRATION_ELEMENT_NAME = "registration";
    private static final String VERSION_ATTRIBUTE_NAME = "version";
    private static final String LAST_REFRESH_TIME_ELMENT_NAME = "last-refresh-time";
    private static final String SERVER_URI_ELEMENT_NAME = "server-uri";
    private static final String REGISTRATION_ENTRIES_ELEMENT_NAME = "RegistrationEntries";
    private static final String REGISTRATION_ENTRY_ELEMENT_NAME = "RegistrationEntry";

    @Override
    protected void serialize(Object component, XMLStreamWriter writer) throws XMLStreamException, IOException, InterruptedException {
        RegistrationData registrationData = (RegistrationData)component;
        writer.writeStartElement(REGISTRATION_ELEMENT_NAME);
        writer.writeAttribute(VERSION_ATTRIBUTE_NAME, String.valueOf(1));
        this.createChildTextElement(writer, LAST_REFRESH_TIME_ELMENT_NAME, String.valueOf(registrationData.getLastRefreshTimeMillis()));
        this.createChildTextElement(writer, SERVER_URI_ELEMENT_NAME, registrationData.getServerURI());
        RegistrationEntry[] entries = registrationData.getRegistrationEntries(false);
        if (entries.length > 0) {
            writer.writeStartElement(REGISTRATION_ENTRIES_ELEMENT_NAME);
            for (int i = 0; i < entries.length; ++i) {
                entries[i].getWebServiceObject().writeAsElement(writer, REGISTRATION_ENTRY_ELEMENT_NAME);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    @Override
    protected Object deserialize(XMLStreamReader reader) throws XMLStreamException, IOException, InterruptedException {
        int event;
        ArrayList<_FrameworkRegistrationEntry> registrationEntries = new ArrayList<_FrameworkRegistrationEntry>();
        String tfsUri = null;
        long lastRefreshTimeMillis = -1L;
        if (reader.nextTag() != 1) {
            throw new IllegalStateException();
        }
        if (!REGISTRATION_ELEMENT_NAME.equals(reader.getLocalName())) {
            throw new RuntimeException(MessageFormat.format("unexpected root element: [{0}]", reader.getLocalName()));
        }
        while ((event = reader.next()) != 2) {
            if (event != 1) continue;
            String localName = reader.getLocalName();
            if (LAST_REFRESH_TIME_ELMENT_NAME.equals(localName)) {
                String s = this.readTextToElementEnd(reader);
                try {
                    lastRefreshTimeMillis = Long.parseLong(s);
                    continue;
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
            if (SERVER_URI_ELEMENT_NAME.equals(localName)) {
                tfsUri = this.readTextToElementEnd(reader);
                if (tfsUri.trim().length() != 0) continue;
                tfsUri = null;
                continue;
            }
            if (!REGISTRATION_ENTRIES_ELEMENT_NAME.equals(localName)) continue;
            while (reader.next() != 2) {
                if (event != 1) continue;
                if (REGISTRATION_ENTRY_ELEMENT_NAME.equals(reader.getLocalName())) {
                    _FrameworkRegistrationEntry entry = new _FrameworkRegistrationEntry();
                    entry.readFromElement(reader);
                    registrationEntries.add(entry);
                    continue;
                }
                this.readToElementEnd(reader);
            }
        }
        Object[] registrationEntryArray = registrationEntries.toArray(new _FrameworkRegistrationEntry[registrationEntries.size()]);
        if (registrationEntryArray.length == 0) {
            return null;
        }
        return new RegistrationData((RegistrationEntry[])WrapperUtils.wrap(RegistrationEntry.class, registrationEntryArray), lastRefreshTimeMillis, tfsUri);
    }
}

