/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.teamstore;

import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.commonstructure.ProjectInfo;
import com.microsoft.tfs.core.clients.framework.internal.ServiceInterfaceIdentifiers;
import com.microsoft.tfs.core.clients.teamsettings.TeamConfiguration;
import com.microsoft.tfs.core.clients.teamsettings.TeamSettingsConfigurationService;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class TeamProjectCollectionTeamStore {
    private final Object lock = new Object();
    private final TFSTeamProjectCollection teamProjectCollection;
    private final Set<String> projectUris = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private boolean knowSupportsTeam;
    private boolean supportsTeam;
    private List<TeamConfiguration> cache;

    public TeamProjectCollectionTeamStore(TFSTeamProjectCollection teamProjectCollection) {
        Check.notNull(teamProjectCollection, "teamProjectCollection");
        this.teamProjectCollection = teamProjectCollection;
    }

    public boolean supportsTeam() {
        if (!this.knowSupportsTeam) {
            this.supportsTeam = null != this.teamProjectCollection.getServerDataProvider().locationForCurrentConnection("TeamConfigurationService", ServiceInterfaceIdentifiers.TEAM_CONFIGURATION);
            this.knowSupportsTeam = true;
        }
        return this.supportsTeam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeTeamCache(ProjectInfo[] infos) {
        Check.isTrue(this.supportsTeam(), "Teams are not supported for this server, ensure SupportsTeam is true before using this method");
        Object object = this.lock;
        synchronized (object) {
            this.projectUris.clear();
            for (ProjectInfo info : infos) {
                this.projectUris.add(info.getURI());
            }
            this.updateCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeTeamCache(String[] projectUris) {
        Check.isTrue(this.supportsTeam(), "Teams are not supported for this server, ensure SupportsTeam is true before using this method");
        Object object = this.lock;
        synchronized (object) {
            this.projectUris.clear();
            for (String projectUri : projectUris) {
                this.projectUris.add(projectUri);
            }
            this.updateCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TeamConfiguration[] getTeamsForCurrentUser() {
        TeamConfiguration[] teams;
        Check.isTrue(this.supportsTeam(), "Teams are not supported for this server, ensure SupportsTeam is true before using this method");
        Object object = this.lock;
        synchronized (object) {
            if (this.cache == null) {
                this.updateCache();
            }
            teams = this.cache.toArray(new TeamConfiguration[this.cache.size()]);
        }
        return teams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TeamConfiguration getTeam(String projectUri, String teamName) {
        Check.isTrue(this.supportsTeam(), "Teams are not supported for this server, ensure SupportsTeam is true before using this method");
        Object object = this.lock;
        synchronized (object) {
            this.ensureCacheContainsProjectTeams(projectUri);
            for (TeamConfiguration conf : this.cache) {
                if (!conf.getProjectURI().equalsIgnoreCase(projectUri) || !conf.getTeamName().equalsIgnoreCase(teamName)) continue;
                return conf;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TeamConfiguration getTeam(String projectUri, GUID id) {
        Check.isTrue(this.supportsTeam(), "Teams are not supported for this server, ensure SupportsTeam is true before using this method");
        Object object = this.lock;
        synchronized (object) {
            this.ensureCacheContainsProjectTeams(projectUri);
            for (TeamConfiguration conf : this.cache) {
                if (!conf.getProjectURI().equalsIgnoreCase(projectUri) || !conf.getTeamID().equals(id)) continue;
                return conf;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TeamConfiguration[] getTeams(String projectUri) {
        Check.isTrue(this.supportsTeam(), "Teams are not supported for this server, ensure SupportsTeam is true before using this method");
        ArrayList<TeamConfiguration> teams = new ArrayList<TeamConfiguration>();
        Object object = this.lock;
        synchronized (object) {
            this.ensureCacheContainsProjectTeams(projectUri);
            for (TeamConfiguration conf : this.cache) {
                if (!conf.getProjectURI().equalsIgnoreCase(projectUri)) continue;
                teams.add(conf);
            }
        }
        return teams.toArray(new TeamConfiguration[teams.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCacheContainsProjectTeams(String projectUri) {
        Object object = this.lock;
        synchronized (object) {
            if (this.cache == null || !this.projectUris.contains(projectUri)) {
                this.projectUris.add(projectUri);
                this.updateCache();
            }
        }
    }

    private void updateCache() {
        if (this.cache == null) {
            this.cache = new ArrayList<TeamConfiguration>();
        }
        if (this.projectUris.size() == 0) {
            this.cache.clear();
            return;
        }
        TeamSettingsConfigurationService teamService = (TeamSettingsConfigurationService)this.teamProjectCollection.getClient(TeamSettingsConfigurationService.class);
        TeamConfiguration[] teams = teamService.getTeamConfigurationsForUser(this.projectUris.toArray(new String[this.projectUris.size()]));
        this.cache.clear();
        for (TeamConfiguration team : teams) {
            this.cache.add(team);
        }
    }
}

