/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol;

import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.core.util.FileEncoding;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.TypesafeEnum;

public final class ResolutionOptions {
    private EncodingStrategy encodingStrategy = EncodingStrategy.DEFAULT;
    private FileEncoding explicitEncoding = FileEncoding.AUTOMATICALLY_DETECT;
    private boolean useInternalEngine = true;
    private FileEncoding acceptMergeEncoding = null;
    private String newPath = null;
    private boolean acceptMergeWithConflicts = false;
    private PropertyValue[] acceptMergeProperties;

    public void setEncodingStrategy(EncodingStrategy strategy, FileEncoding explicitEncoding) {
        Check.isTrue(strategy == EncodingStrategy.DEFAULT && explicitEncoding == null || explicitEncoding != null, "explicitEncoding must be null if strategy is EncodingStrategy.DEFAULT");
        this.encodingStrategy = strategy;
        this.explicitEncoding = explicitEncoding;
    }

    public EncodingStrategy getEncodingStrategy() {
        return this.encodingStrategy;
    }

    public FileEncoding getExplicitEncoding() {
        return this.explicitEncoding;
    }

    public void setUseInternalEngine(boolean useInternalEngine) {
        this.useInternalEngine = useInternalEngine;
    }

    public boolean useInternalEngine() {
        return this.useInternalEngine;
    }

    public void setAcceptMergeEncoding(FileEncoding encoding) {
        this.acceptMergeEncoding = encoding;
    }

    public FileEncoding getAcceptMergeEncoding() {
        return this.acceptMergeEncoding;
    }

    public PropertyValue[] getAcceptMergeProperties() {
        return this.acceptMergeProperties;
    }

    public void setAcceptMergeProperties(PropertyValue[] acceptMergeProperties) {
        this.acceptMergeProperties = acceptMergeProperties;
    }

    public void setNewPath(String newPath) {
        this.newPath = newPath;
    }

    public String getNewPath() {
        return this.newPath;
    }

    public boolean isAcceptMergeWithConflicts() {
        return this.acceptMergeWithConflicts;
    }

    public void setAcceptMergeWithConflicts(boolean mergeWithConflicts) {
        this.acceptMergeWithConflicts = mergeWithConflicts;
    }

    public static class EncodingStrategy
    extends TypesafeEnum {
        public static final EncodingStrategy DEFAULT = new EncodingStrategy(0);
        public static final EncodingStrategy OVERRIDE_EXPLICIT = new EncodingStrategy(1);
        public static final EncodingStrategy CONVERT_EXPLICIT = new EncodingStrategy(2);

        private EncodingStrategy(int value) {
            super(value);
        }
    }
}

