/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.TFProxyServerSettings;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.checkinpolicies.PolicyAnnotation;
import com.microsoft.tfs.core.checkinpolicies.PolicyDefinition;
import com.microsoft.tfs.core.checkinpolicies.PolicySerializationException;
import com.microsoft.tfs.core.clients.framework.internal.ServiceInterfaceIdentifiers;
import com.microsoft.tfs.core.clients.security.AccessControlEntry;
import com.microsoft.tfs.core.clients.security.AccessControlEntryDetails;
import com.microsoft.tfs.core.clients.security.AccessControlListDetails;
import com.microsoft.tfs.core.clients.security.SecurityNamespace;
import com.microsoft.tfs.core.clients.security.SecurityService;
import com.microsoft.tfs.core.clients.versioncontrol.AutoResolveOptions;
import com.microsoft.tfs.core.clients.versioncontrol.ChangePendedFlags;
import com.microsoft.tfs.core.clients.versioncontrol.DestroyFlags;
import com.microsoft.tfs.core.clients.versioncontrol.GetItemsOptions;
import com.microsoft.tfs.core.clients.versioncontrol.GetOptions;
import com.microsoft.tfs.core.clients.versioncontrol.MergeFlags;
import com.microsoft.tfs.core.clients.versioncontrol.OperationStatus;
import com.microsoft.tfs.core.clients.versioncontrol.ProcessType;
import com.microsoft.tfs.core.clients.versioncontrol.PropertyUtils;
import com.microsoft.tfs.core.clients.versioncontrol.QueryMergesExtendedOptions;
import com.microsoft.tfs.core.clients.versioncontrol.ResolveConflictHandler;
import com.microsoft.tfs.core.clients.versioncontrol.ResolveErrorOptions;
import com.microsoft.tfs.core.clients.versioncontrol.ResolveLocalConflictHandler;
import com.microsoft.tfs.core.clients.versioncontrol.SupportedFeatures;
import com.microsoft.tfs.core.clients.versioncontrol.UpdateLocalVersionQueue;
import com.microsoft.tfs.core.clients.versioncontrol.WebServiceLevel;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceLocation;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceOptions;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspacePermissionProfile;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspacePermissions;
import com.microsoft.tfs.core.clients.versioncontrol.Workstation;
import com.microsoft.tfs.core.clients.versioncontrol.engines.MergeEngine;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.GetEngine;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.OutputStreamDownloadOutput;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers.TempDownloadWorker;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers.WorkerStatus;
import com.microsoft.tfs.core.clients.versioncontrol.events.BranchCommittedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.BranchObjectUpdatedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.DestroyEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.EventSource;
import com.microsoft.tfs.core.clients.versioncontrol.events.NonFatalErrorEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.VersionControlEventEngine;
import com.microsoft.tfs.core.clients.versioncontrol.events.WorkspaceEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.WorkspaceUpdatedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.DownloadProxyException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.FeatureNotSupportedException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ItemNotMappedException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.OnlyOneWorkspaceException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ServerPathFormatException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.WorkspaceNotFoundException;
import com.microsoft.tfs.core.clients.versioncontrol.internal.HistoryIterator;
import com.microsoft.tfs.core.clients.versioncontrol.internal.WebServiceLayer;
import com.microsoft.tfs.core.clients.versioncontrol.internal.WebServiceLayerLocalWorkspaces;
import com.microsoft.tfs.core.clients.versioncontrol.internal.concurrent.AccountingCompletionService;
import com.microsoft.tfs.core.clients.versioncontrol.internal.concurrent.BoundedExecutor;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BaselineRequest;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalDataAccessLayer;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalPendingChangesTable;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalVersionPendingChangesTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalWorkspaceProperties;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalWorkspaceTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.NullPathWatcherFactory;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.PendingChangesTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLock;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspacePropertiesTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceVersionTable;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.PathWatcherFactory;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.Wildcard;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Annotation;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.BranchObject;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.BranchProperties;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Change;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Changeset;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangesetMerge;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangesetMergeDetails;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.CheckinNote;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.CheckinNoteFieldDefinition;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.CheckinResult;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Conflict;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ConflictType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.DeletedState;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ExtendedItem;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ExtendedMerge;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Failure;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.FileType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetRequest;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Item;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemIdentifier;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemSet;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LabelChildOption;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LabelResult;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Mapping;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.MergeCandidate;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingSet;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PolicyOverrideInfo;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Resolution;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.SecurityChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ServerSettings;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Shelveset;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.VersionControlLabel;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkingFolder;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkspaceItemSet;
import com.microsoft.tfs.core.clients.versioncontrol.specs.DownloadOutput;
import com.microsoft.tfs.core.clients.versioncontrol.specs.DownloadSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.LabelItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.ChangesetVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.LatestVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.WorkspaceInfo;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.internal.InternalServerInfo;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.internal.RuntimeWorkspaceCache;
import com.microsoft.tfs.core.clients.webservices.IdentityDescriptor;
import com.microsoft.tfs.core.clients.webservices.IdentityHelper;
import com.microsoft.tfs.core.exceptions.internal.CoreCancelException;
import com.microsoft.tfs.core.httpclient.Header;
import com.microsoft.tfs.core.httpclient.HttpClient;
import com.microsoft.tfs.core.httpclient.HttpMethodBase;
import com.microsoft.tfs.core.httpclient.methods.GetMethod;
import com.microsoft.tfs.core.httpclient.methods.PostMethod;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.util.URIUtils;
import com.microsoft.tfs.core.util.notifications.Notification;
import com.microsoft.tfs.jni.FileSystemUtils;
import com.microsoft.tfs.jni.helpers.LocalHost;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.Closable;
import com.microsoft.tfs.util.FileHelpers;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.IOUtils;
import com.microsoft.tfs.util.Platform;
import com.microsoft.tfs.util.TappedInputStream;
import com.microsoft.tfs.util.tasks.CanceledException;
import com.microsoft.tfs.util.tasks.TaskMonitor;
import com.microsoft.tfs.util.tasks.TaskMonitorService;
import com.microsoft.tfs.util.temp.TempStorageService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPInputStream;
import ms.tfs.versioncontrol.clientservices._03._Repository4Soap;
import ms.tfs.versioncontrol.clientservices._03._Repository5Soap;
import ms.tfs.versioncontrol.clientservices._03._RepositoryExtensionsSoap;
import ms.tfs.versioncontrol.clientservices._03._RepositorySoap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class VersionControlClient
implements Closable {
    private static final Log log = LogFactory.getLog(VersionControlClient.class);
    private static final String MAX_REQUEST_RETRY_PROPERTY = "com.microsoft.tfs.core.maxRequestRetry";
    private static final int MAX_REQUEST_RETRY_DEFAULT = 3;
    private static final int DOWNLOAD_BUFFER_SIZE = 32768;
    public static final GUID WORKSPACE_SECURITY_NAMESPACE_ID = new GUID("93BAFC04-9075-403a-9367-B7164EAC6B5C");
    private static final int HISTORY_ITEMS_CHUNK_SIZE = 256;
    private static final int DEFAULT_GET_ENGINE_WORKER_LIMIT = 8;
    private static final int DEFAULT_GET_ENGINE_WORKER_TIMEOUT_SECONDS = 20;
    private final _RepositorySoap _webService;
    private final _RepositoryExtensionsSoap _webServiceExtensions;
    private final _Repository4Soap _repository4;
    private final _Repository5Soap _repository5;
    private final ThreadPoolExecutor threadPoolExecutor;
    private final BoundedExecutor uploadDownloadWorkerExecutor;
    private final VersionControlEventEngine eventEngine = new VersionControlEventEngine();
    private final TFSTeamProjectCollection connection;
    private PathWatcherFactory pathWatcherFactory = new NullPathWatcherFactory();
    private final Object pathWatcherFactoryLock = new Object();
    private GUID serverGUID;
    private final Object serverGUIDLock = new Object();
    private WebServiceLayer webServiceLayer;
    private final Object webServiceLayerLock = new Object();
    private SupportedFeatures serverSupportedFeatures;
    private final Object serverSupportedFeaturesLock = new Object();
    private RuntimeWorkspaceCache runtimeWorkspaceCache;
    private final Object runtimeWorkspaceCacheLock = new Object();
    private URI downloadFileURI;
    private final Object downloadFileURILock = new Object();
    private URI uploadFileURI;
    private final Object uploadFileURILock = new Object();
    private Map<String, FileType> cachedFileTypes;
    private final Object cachedFileTypesLock = new Object();
    private String[] defaultItemPropertyFilters;
    private final Object defaultItemPropertyFiltersLock = new Object();
    private SecurityNamespace workspaceSecurity;
    private final Object workspaceSecurityLock = new Object();
    private ServerSettings serverSettings;
    private final Object serverSettingsLock = new Object();

    protected VersionControlClient(TFSTeamProjectCollection connection, _RepositorySoap webService, _RepositoryExtensionsSoap webServiceExtensions, _Repository4Soap repository4, _Repository5Soap repository5, int maximumGetEngineWorkerThreads, int getEngineWorkerThreadIdleTimeoutSeconds) {
        Check.notNull(connection, "connection");
        Check.isTrue(maximumGetEngineWorkerThreads > 0, "GetEngine worker threads must be > 0");
        Check.isTrue(getEngineWorkerThreadIdleTimeoutSeconds >= 0, "GetEngine worker timeout must be >= 0");
        Check.notNull(webService, "webService");
        this.connection = connection;
        this._webService = webService;
        this._webServiceExtensions = webServiceExtensions;
        this._repository4 = repository4;
        this._repository5 = repository5;
        InternalServerInfo serverInfo = Workstation.getCurrent(this.getConnection().getPersistenceStoreProvider()).getCache().getServerInfoByURI(connection.getBaseURI());
        this.serverGUID = null == serverInfo ? connection.getInstanceID() : serverInfo.getServerGUID();
        this.threadPoolExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, getEngineWorkerThreadIdleTimeoutSeconds, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        this.uploadDownloadWorkerExecutor = new BoundedExecutor(this.threadPoolExecutor, maximumGetEngineWorkerThreads);
        if (Platform.isCurrentPlatform(Platform.GENERIC_UNIX) && this.getWebServiceLayer().getServiceLevel().getValue() >= WebServiceLevel.TFS_2012.getValue()) {
            this.setDefaultItemPropertyFilters(new String[]{"Microsoft.TeamFoundation.VersionControl.Executable", "Microsoft.TeamFoundation.VersionControl.SymbolicLink"});
        }
        Workstation.getCurrent(this.getConnection().getPersistenceStoreProvider()).addWorkstationEventListener(this);
    }

    public VersionControlClient(TFSTeamProjectCollection connection, _RepositorySoap repository, _RepositoryExtensionsSoap repositoryExtensions, _Repository4Soap repository4, _Repository5Soap repository5) {
        this(connection, repository, repositoryExtensions, repository4, repository5, 8, 20);
    }

    @Override
    public void close() {
        Workstation.getCurrent(this.getConnection().getPersistenceStoreProvider()).removeWorkstationEventListener(this);
        this.threadPoolExecutor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebServiceLayer getWebServiceLayer() {
        Object object = this.webServiceLayerLock;
        synchronized (object) {
            if (this.webServiceLayer == null) {
                this.webServiceLayer = new WebServiceLayerLocalWorkspaces(this, this._webService, this._webServiceExtensions, this._repository4, this._repository5);
            }
            return this.webServiceLayer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuntimeWorkspaceCache getRuntimeWorkspaceCache() {
        Object object = this.runtimeWorkspaceCacheLock;
        synchronized (object) {
            if (this.runtimeWorkspaceCache == null) {
                this.runtimeWorkspaceCache = new RuntimeWorkspaceCache(this);
            }
            return this.runtimeWorkspaceCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PathWatcherFactory getPathWatcherFactory() {
        Object object = this.pathWatcherFactoryLock;
        synchronized (object) {
            return this.pathWatcherFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPathWatcherFactory(PathWatcherFactory pathWatcherFactory) {
        Object object = this.pathWatcherFactoryLock;
        synchronized (object) {
            this.pathWatcherFactory = pathWatcherFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDefaultItemPropertyFilters() {
        Object object = this.defaultItemPropertyFiltersLock;
        synchronized (object) {
            return this.defaultItemPropertyFilters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultItemPropertyFilters(String[] filters) {
        Object object = this.defaultItemPropertyFiltersLock;
        synchronized (object) {
            this.defaultItemPropertyFilters = filters;
        }
    }

    public WebServiceLevel getServiceLevel() {
        return this.getWebServiceLayer().getServiceLevel();
    }

    private HttpClient getHTTPClient() {
        return this.connection.getHTTPClient();
    }

    public VersionControlEventEngine getEventEngine() {
        return this.eventEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GUID getServerGUID() {
        Object object = this.serverGUIDLock;
        synchronized (object) {
            return this.serverGUID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshServerGUID() {
        Object object = this.serverGUIDLock;
        synchronized (object) {
            this.serverGUID = this.connection.getInstanceID();
        }
    }

    public BoundedExecutor getUploadDownloadWorkerExecutor() {
        return this.uploadDownloadWorkerExecutor;
    }

    public Workspace getLocalWorkspace(String localPath, boolean throwIfNotFound) throws ItemNotMappedException {
        Check.notNullOrEmpty(localPath, "localPath");
        localPath = LocalPath.canonicalize(localPath);
        WorkspaceInfo info = Workstation.getCurrent(this.getConnection().getPersistenceStoreProvider()).getLocalWorkspaceInfo(localPath);
        if (info == null || !info.getServerGUID().equals(this.getServerGUID())) {
            if (throwIfNotFound) {
                throw new ItemNotMappedException(MessageFormat.format(Messages.getString("VersionControlClient.NoWorkingFolderForFormat"), localPath));
            }
            return null;
        }
        return this.getRuntimeWorkspaceCache().getWorkspace(info);
    }

    public Workspace getLocalWorkspace(String workspaceName, String workspaceOwner) {
        Check.notNullOrEmpty(workspaceName, "workspaceName");
        Check.notNullOrEmpty(workspaceOwner, "workspaceOwner");
        WorkspaceInfo info = Workstation.getCurrent(this.getConnection().getPersistenceStoreProvider()).getLocalWorkspaceInfo(this.getServerGUID(), workspaceName, this.resolveUserUniqueName(workspaceOwner));
        if (info != null) {
            return this.getRuntimeWorkspaceCache().getWorkspace(info);
        }
        return null;
    }

    public Workspace getRepositoryWorkspace(String workspaceName, String workspaceOwner) throws WorkspaceNotFoundException {
        Workspace workspace;
        Check.notNullOrEmpty(workspaceName, "workspaceName");
        Check.notNullOrEmpty(workspaceOwner, "workspaceOwner");
        try {
            workspace = this.getRuntimeWorkspaceCache().cacheWorkspace(this.queryWorkspace(workspaceName, workspaceOwner));
        }
        catch (WorkspaceNotFoundException e) {
            this.removeCachedWorkspace(workspaceName, workspaceOwner);
            throw e;
        }
        finally {
            Workstation.getCurrent(this.getConnection().getPersistenceStoreProvider()).saveConfigIfDirty();
        }
        return workspace;
    }

    public Workspace[] getRepositoryWorkspaces(String workspaceName, String workspaceOwner, String computer) {
        return this.getRepositoryWorkspaces(workspaceName, workspaceOwner, computer, WorkspacePermissions.NONE_OR_NOT_SUPPORTED);
    }

    public Workspace[] getRepositoryWorkspaces(String workspaceName, String workspaceOwner, String computer, WorkspacePermissions permissionsFilter) {
        Workspace[] workspaces = this.getWebServiceLayer().queryWorkspaces(workspaceOwner, computer, permissionsFilter);
        ArrayList<Workspace> matches = new ArrayList<Workspace>(workspaces.length);
        for (Workspace workspace : workspaces) {
            if (workspaceName != null && !Workspace.matchName(workspace.getName(), workspaceName)) continue;
            matches.add(workspace);
        }
        Workspace[] results = this.getRuntimeWorkspaceCache().cacheWorkspaces(matches.toArray(new Workspace[matches.size()]));
        try {
            Workstation.getCurrent(this.getConnection().getPersistenceStoreProvider()).checkForLocalItemExclusionUpdates(this, false);
        }
        catch (Exception ex) {
            log.error((Object)"Failed to check for local item exclusion updates in VersionControlClient.getRepositoryWorkspaces()", (Throwable)ex);
        }
        return results;
    }

    public Workspace createWorkspace(WorkingFolder[] workingFolders, String workspaceName, String comment, WorkspaceLocation location, WorkspaceOptions options) {
        return this.createWorkspace(workingFolders, workspaceName, comment, location, options, WorkspacePermissionProfile.getPrivateProfile());
    }

    public Workspace createWorkspace(WorkingFolder[] workingFolders, String workspaceName, String comment, WorkspaceLocation location, WorkspaceOptions options, WorkspacePermissionProfile permissionProfile) {
        return this.createWorkspace(workingFolders, workspaceName, ".", ".", comment, location, options, permissionProfile);
    }

    public Workspace createWorkspace(WorkingFolder[] workingFolders, String workspaceName, String owner, String ownerDisplayName, String comment, WorkspaceLocation location, WorkspaceOptions options) {
        return this.createWorkspace(workingFolders, workspaceName, owner, ownerDisplayName, comment, location, options, WorkspacePermissionProfile.getPrivateProfile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Workspace createWorkspace(WorkingFolder[] workingFolders, String workspaceName, String owner, String ownerDisplayName, String comment, WorkspaceLocation location, WorkspaceOptions options, WorkspacePermissionProfile permissionProfile) {
        Check.notNullOrEmpty(workspaceName, "workspaceName");
        if (owner == null || owner.length() == 0) {
            owner = ".";
        }
        if (ownerDisplayName == null || ownerDisplayName.length() == 0) {
            ownerDisplayName = ".";
        }
        if (location == null) {
            location = this.getServerSettingsWithFallback(new AtomicBoolean()).getDefaultWorkspaceLocation();
        }
        if (options == null) {
            options = WorkspaceOptions.NONE;
        }
        if (permissionProfile == null) {
            permissionProfile = WorkspacePermissionProfile.getPrivateProfile();
        }
        workingFolders = Workspace.checkForInternalMappingConflicts(workspaceName, workingFolders, false);
        Workspace workspace = new Workspace(this, workspaceName, this.resolveUserUniqueName(owner), this.resolveUserDisplayName(ownerDisplayName), null, comment, null, workingFolders, LocalHost.getShortName(), location, WorkspacePermissions.NONE_OR_NOT_SUPPORTED, permissionProfile, options);
        if (workspace.isLocal()) {
            Workstation.getCurrent(this.getConnection().getPersistenceStoreProvider()).getCache().checkForMappingConflicts(workspace, null);
        }
        workspace = this.getWebServiceLayer().createWorkspace(workspace);
        if (permissionProfile.getAccessControlEntries().length > 0) {
            this.setPermissionProfile(workspace, permissionProfile);
            workspace = this.queryWorkspace(workspace.getName(), workspace.getOwnerName());
        }
        if ((workspace = this.getRuntimeWorkspaceCache().cacheWorkspace(workspace)).isLocal()) {
            if (WorkspaceLocation.LOCAL == workspace.getLocation()) {
                FileHelpers.deleteDirectory(workspace.getLocalMetadataDirectory());
                final WorkingFolder[] folders = workspace.getFolders();
                final WorkspacePermissionProfile finalPermissionProfile = permissionProfile;
                LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(workspace);
                try {
                    transaction.execute(new WorkspacePropertiesTransaction(){

                        @Override
                        public void invoke(LocalWorkspaceProperties wp) {
                            wp.setWorkingFolders(folders);
                            wp.doBaselineFolderMaintenance();
                            wp.applyPermissionsProfileToBaselineFolders(finalPermissionProfile);
                            wp.applyPermissionsProfileToWorkingFolders(finalPermissionProfile);
                        }
                    });
                }
                finally {
                    try {
                        transaction.close();
                    }
                    catch (IOException e) {
                        throw new VersionControlException(e);
                    }
                }
                transaction = new LocalWorkspaceTransaction(workspace);
                try {
                    transaction.execute(new PendingChangesTransaction(){

                        @Override
                        public void invoke(LocalPendingChangesTable pc) {
                            pc.setClientSignature(WebServiceLayerLocalWorkspaces.INITIAL_PENDING_CHANGES_SIGNATURE);
                        }
                    });
                }
                finally {
                    try {
                        transaction.close();
                    }
                    catch (IOException e) {
                        throw new VersionControlException(e);
                    }
                }
            }
            this.removeCachedWorkspace(workspace.getName(), workspace.getOwnerName());
            Workstation.getCurrent(this.getConnection().getPersistenceStoreProvider()).insertWorkspaceIntoCache(workspace);
            Workstation.getCurrent(this.getConnection().getPersistenceStoreProvider()).saveConfigIfDirty();
            Workstation.getCurrent(this.getConnection().getPersistenceStoreProvider()).notifyForWorkspace(workspace, Notification.VERSION_CONTROL_WORKSPACE_CREATED);
            try {
                Workstation.getCurrent(this.getConnection().getPersistenceStoreProvider()).checkForLocalItemExclusionUpdates(this, false);
            }
            catch (Exception ex) {
                log.error((Object)"Failed to check for local item exclusion updates in VersionControlClient.createWorkspace()", (Throwable)ex);
            }
        }
        this.eventEngine.fireWorkspaceCreated(new WorkspaceEvent(EventSource.newFromHere(), workspace, WorkspaceEvent.WorkspaceEventSource.INTERNAL));
        return workspace;
    }

    public void updateWorkspace(Workspace workspace, String newName, String newOwner, String newComment, WorkingFolder[] newMappings, String newComputer) {
        this.updateWorkspace(workspace, newName, newOwner, newComment, newMappings, newComputer, null);
    }

    public void updateWorkspace(Workspace workspace, String newName, String newOwner, String newComment, WorkingFolder[] newMappings, String newComputer, WorkspacePermissionProfile newPermissionProfile) {
        this.updateWorkspace(workspace, newName, newOwner, newComment, newMappings, newComputer, newPermissionProfile, false, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWorkspace(Workspace workspace, String newName, String newOwner, String newComment, WorkingFolder[] newMappings, String newComputer, WorkspacePermissionProfile newPermissionProfile, boolean removeUnparentedCloaks, WorkspaceOptions newOptions, WorkspaceLocation newLocation) {
        Check.notNull(workspace, "workspace");
        workspace.refresh();
        if (!workspace.hasAdministerPermission()) {
            throw new VersionControlException(MessageFormat.format(Messages.getString("VersionControlClient.NoAdministerPermissionFormat"), workspace.getClient().getConnection().getAuthorizedIdentity().getDisplayName(), workspace.getName(), workspace.getOwnerDisplayName()));
        }
        if (newName == null) {
            newName = workspace.getName();
        }
        if (newOwner == null) {
            newOwner = workspace.getOwnerName();
        }
        if (newComment == null) {
            newComment = workspace.getComment();
        }
        if (newMappings == null) {
            newMappings = workspace.getFolders();
        }
        if (newComputer == null) {
            newComputer = workspace.getComputer();
        }
        if (newPermissionProfile == null) {
            newPermissionProfile = workspace.getPermissionsProfile();
        }
        if (newOptions == null) {
            newOptions = workspace.getOptions();
        }
        if (newLocation == null) {
            newLocation = workspace.getLocation();
        }
        Check.notNullOrEmpty(newName, "newName");
        Check.notNullOrEmpty(newOwner, "newOwner");
        Check.notNull(newMappings, "newMappings");
        Check.notNullOrEmpty(newComputer, "newComputer");
        Check.notNull(newOptions, "newOptions");
        WorkspaceLocation oldLocation = workspace.getLocation();
        if (newLocation != oldLocation) {
            try {
                this.setWorkspaceLocation(workspace, newLocation);
            }
            catch (CoreCancelException e) {
                throw new CanceledException();
            }
        }
        String oldLocalMetadataDirectory = WorkspaceLocation.LOCAL == workspace.getLocation() ? workspace.getLocalMetadataDirectory() : null;
        newMappings = Workspace.checkForInternalMappingConflicts(newName, newMappings, removeUnparentedCloaks);
        if (!workspace.ownerNameMatches(newOwner) && newPermissionProfile != null && workspace.getPermissionsProfile() != null && newPermissionProfile != workspace.getPermissionsProfile()) {
            throw new VersionControlException(Messages.getString("VersionControlClient.CannotChangeWorkspaceOwnerAndPermissionsSimultaneously"));
        }
        String newOwnerUnique = newOwner;
        if (workspace.ownerNameMatches(newOwner)) {
            newOwnerUnique = workspace.getOwnerName();
        }
        String oldName = null;
        if (!workspace.matchName(newName)) {
            oldName = workspace.getName();
        }
        Workspace workspaceToSend = new Workspace(this, newName, newOwner, newOwnerUnique, null, newComment, null, newMappings, newComputer, workspace.getLocation(), WorkspacePermissions.NONE_OR_NOT_SUPPORTED, newPermissionProfile, newOptions);
        if (workspace.isLocal() || Workspace.matchComputer(newComputer, LocalHost.getShortName())) {
            Workstation.getCurrent(this.getConnection().getPersistenceStoreProvider()).getCache().checkForMappingConflicts(workspaceToSend, workspace);
        }
        Workspace newWorkspace = this.getWebServiceLayer().updateWorkspace(workspace.getName(), workspace.getOwnerName(), workspaceToSend, SupportedFeatures.ALL);
        Check.notNull(newWorkspace, "newWorkspace");
        if (oldLocalMetadataDirectory != null && WorkspaceLocation.LOCAL == workspace.getLocation() && !Workspace.matchSecurityToken(workspace.getSecurityToken(), newWorkspace.getSecurityToken())) {
            String newLocalMetadataDirectory = newWorkspace.getLocalMetadataDirectory();
            try {
                FileHelpers.deleteDirectory(newLocalMetadataDirectory);
                FileHelpers.rename(oldLocalMetadataDirectory, newLocalMetadataDirectory);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (newPermissionProfile != null && newPermissionProfile != workspace.getPermissionsProfile()) {
            this.setPermissionProfile(newWorkspace, newPermissionProfile);
            newWorkspace = this.queryWorkspace(newWorkspace.getName(), newWorkspace.getOwnerName());
            Check.notNull(newWorkspace, "newWorkspace");
        }
        final boolean hasNewOwner = !workspace.ownerNameMatches(newOwner);
        this.getRuntimeWorkspaceCache().updateWorkspace(workspace, newWorkspace);
        final WorkspacePermissionProfile finalNewPermissionProfile = newPermissionProfile;
        if (WorkspaceLocation.LOCAL == workspace.getLocation()) {
            LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(workspace);
            try {
                final IdentityDescriptor ownerIdentity = newWorkspace.getOwnerDescriptor();
                transaction.execute(new WorkspacePropertiesTransaction(){

                    @Override
                    public void invoke(LocalWorkspaceProperties wp) {
                        wp.doBaselineFolderMaintenance();
                        if (finalNewPermissionProfile != null) {
                            wp.applyPermissionsProfileToBaselineFolders(finalNewPermissionProfile);
                            wp.applyPermissionsProfileToWorkingFolders(finalNewPermissionProfile);
                        }
                        if (hasNewOwner && "System.Security.Principal.WindowsIdentity".equals(ownerIdentity.getIdentityType())) {
                            wp.applyAceToBaselineFolders(ownerIdentity.getIdentifier(), true);
                            wp.applyAceToWorkingFolders(ownerIdentity.getIdentifier(), true);
                        }
                    }
                });
            }
            finally {
                try {
                    transaction.close();
                }
                catch (IOException e) {
                    throw new VersionControlException(e);
                }
            }
        }
        try {
            Workstation.getCurrent(this.getConnection().getPersistenceStoreProvider()).checkForLocalItemExclusionUpdates(this, true);
        }
        catch (Exception ex) {
            log.error((Object)"Failed to check for local item exclusion updates in VersionControlClient.updateWorkspace()", (Throwable)ex);
        }
        this.getEventEngine().fireWorkspaceUpdated(new WorkspaceUpdatedEvent(EventSource.newFromHere(), workspace, oldName, oldLocation, WorkspaceEvent.WorkspaceEventSource.INTERNAL));
        Workstation.getCurrent(this.getConnection().getPersistenceStoreProvider()).notifyForWorkspace(workspace, Notification.VERSION_CONTROL_WORKSPACE_CHANGED);
    }

    private void setPermissionProfile(Workspace workspace, WorkspacePermissionProfile permissionProfile) {
        Check.notNull(permissionProfile, "permissionProfile");
        if (permissionProfile != null && this.getWorkspaceSecurity() != null && workspace.getSecurityToken() != null) {
            ArrayList<AccessControlEntryDetails> aceDetalsList = new ArrayList<AccessControlEntryDetails>();
            for (AccessControlEntry ace : permissionProfile.getAccessControlEntries()) {
                aceDetalsList.add((AccessControlEntryDetails)ace);
            }
            AccessControlListDetails acl = new AccessControlListDetails(false, workspace.getSecurityToken(), true, aceDetalsList.toArray(new AccessControlEntryDetails[0]));
            if (workspace.getOwnerDescriptor() != null) {
                int allWorkspacePermissions = WorkspacePermissions.combine(new WorkspacePermissions[]{WorkspacePermissions.READ, WorkspacePermissions.USE, WorkspacePermissions.CHECK_IN, WorkspacePermissions.ADMINISTER}).toIntFlags();
                acl.setPermissions(workspace.getOwnerDescriptor(), allWorkspacePermissions, 0, false);
            }
            this.getWorkspaceSecurity().setAccessControlList(acl);
            workspace.setPermissionsProfile(permissionProfile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWorkspaceLocation(final Workspace workspace, WorkspaceLocation newLocation) throws CoreCancelException {
        block46: {
            Check.notNull(workspace, "workspace");
            Check.notNull(newLocation, "newLocation");
            if (newLocation == workspace.getLocation()) {
                return;
            }
            if (this.getWebServiceLayer().getServiceLevel().getValue() < WebServiceLevel.TFS_2012_2.getValue()) {
                throw new FeatureNotSupportedException(Messages.getString("Workspace.LocalWorkspacesNotSupported"));
            }
            TaskMonitor taskMonitor = TaskMonitorService.getTaskMonitor();
            try {
                taskMonitor.begin(Messages.getString("VersionControlClient.ChangingWorkspaceLocation"), 100);
                if (WorkspaceLocation.SERVER == newLocation) {
                    WorkspaceLock wLock = workspace.lock();
                    try {
                        if (taskMonitor.isCanceled()) {
                            throw new CoreCancelException();
                        }
                        taskMonitor.setCurrentWorkDescription(Messages.getString("VersionControlClient.ReconcilingLocalWorkspaceToServer"));
                        AtomicBoolean pendingChangesUpdatedByServer = new AtomicBoolean();
                        workspace.reconcile(false, pendingChangesUpdatedByServer);
                        taskMonitor.worked(20);
                        if (taskMonitor.isCanceled()) {
                            throw new CoreCancelException();
                        }
                        taskMonitor.setCurrentWorkDescription(Messages.getString("VersionControlClient.MarkingUneditedReadOnly"));
                        LocalDataAccessLayer.markReadOnlyBit(workspace, true, taskMonitor.newSubTaskMonitor(30));
                        taskMonitor.setCurrentWorkDescription(Messages.getString("VersionControlClient.ChangingWorkspaceLocationOnServer"));
                        String localMetadataDirectory = workspace.getLocalMetadataDirectory();
                        String[] baselineFolders = LocalDataAccessLayer.getBaselineFolders(workspace);
                        this.getWebServiceLayer().updateWorkspace(workspace.getName(), workspace.getOwnerName(), new Workspace(this, workspace.getName(), workspace.getOwnerName(), workspace.getOwnerDisplayName(), workspace.getOwnerAliases(), workspace.getComment(), workspace.getSecurityToken(), workspace.getFolders(), workspace.getComputer(), WorkspaceLocation.SERVER, workspace.getPermissions(), null, workspace.getOptions()), SupportedFeatures.ALL);
                        taskMonitor.worked(10);
                        taskMonitor.setCurrentWorkDescription(Messages.getString("VersionControlClient.RefreshingWorkspace"));
                        workspace.refresh();
                        taskMonitor.worked(10);
                        taskMonitor.setCurrentWorkDescription(MessageFormat.format(Messages.getString("VersionControlClient.DeletingUnusedBaselineFormat"), localMetadataDirectory));
                        FileHelpers.deleteDirectory(localMetadataDirectory);
                        taskMonitor.worked(10);
                        TaskMonitor deleteBaselineMonitor = taskMonitor.newSubTaskMonitor(20);
                        deleteBaselineMonitor.begin("", baselineFolders.length);
                        for (String baselineFolder : baselineFolders) {
                            taskMonitor.setCurrentWorkDescription(MessageFormat.format(Messages.getString("VersionControlClient.DeletingUnusedBaselineFormat"), baselineFolder));
                            FileHelpers.deleteDirectory(baselineFolder);
                            deleteBaselineMonitor.worked(1);
                        }
                        deleteBaselineMonitor.done();
                    }
                    finally {
                        if (wLock != null) {
                            wLock.close();
                        }
                    }
                    Workstation.getCurrent(this.getConnection().getPersistenceStoreProvider()).notifyForWorkspace(workspace, Notification.VERSION_CONTROL_WORKSPACE_CHANGED);
                    break block46;
                }
                if (WorkspaceLocation.LOCAL != newLocation) break block46;
                Workspace localWorkspace = new Workspace(this, workspace.getName(), workspace.getOwnerName(), workspace.getOwnerDisplayName(), workspace.getOwnerAliases(), workspace.getComment(), workspace.getSecurityToken(), workspace.getFolders(), workspace.getComputer(), WorkspaceLocation.LOCAL, workspace.getPermissions(), null, workspace.getOptions());
                WorkspaceLock wLock = workspace.lock();
                try {
                    boolean workspacePropertiesCreated = false;
                    try {
                        if (taskMonitor.isCanceled()) {
                            throw new CoreCancelException();
                        }
                        taskMonitor.setCurrentWorkDescription(Messages.getString("VersionControlClient.RemovingMetadataForLocalWorkspace"));
                        FileHelpers.deleteDirectory(localWorkspace.getLocalMetadataDirectory());
                        taskMonitor.worked(10);
                        if (taskMonitor.isCanceled()) {
                            throw new CoreCancelException();
                        }
                        taskMonitor.setCurrentWorkDescription(Messages.getString("VersionControlClient.CreatingPropertiesTable"));
                        LocalWorkspaceTransaction propsTransaction = new LocalWorkspaceTransaction(localWorkspace);
                        propsTransaction.setAutoRecover(false);
                        try {
                            propsTransaction.execute(new WorkspacePropertiesTransaction(){

                                @Override
                                public void invoke(LocalWorkspaceProperties wp) {
                                    wp.setWorkingFolders(workspace.getFolders());
                                    wp.doBaselineFolderMaintenance();
                                }
                            });
                        }
                        finally {
                            try {
                                propsTransaction.close();
                            }
                            catch (IOException e) {
                                throw new VersionControlException(e);
                            }
                        }
                        workspacePropertiesCreated = true;
                        taskMonitor.worked(10);
                        if (taskMonitor.isCanceled()) {
                            throw new CoreCancelException();
                        }
                        taskMonitor.setCurrentWorkDescription(Messages.getString("VersionControlClient.CreatingPendingChangesTable"));
                        LocalWorkspaceTransaction pcTransaction = new LocalWorkspaceTransaction(localWorkspace);
                        try {
                            pcTransaction.execute(new LocalVersionPendingChangesTransaction(){

                                @Override
                                public void invoke(WorkspaceVersionTable lv, LocalPendingChangesTable pc) {
                                    PendingSet set = workspace.getPendingChanges();
                                    if (set != null && set.getPendingChanges() != null) {
                                        pc.replacePendingChanges(set.getPendingChanges());
                                    }
                                }
                            });
                        }
                        finally {
                            try {
                                pcTransaction.close();
                            }
                            catch (IOException e) {
                                throw new VersionControlException(e);
                            }
                        }
                        taskMonitor.worked(10);
                        if (taskMonitor.isCanceled()) {
                            throw new CoreCancelException();
                        }
                        taskMonitor.setCurrentWorkDescription(Messages.getString("VersionControlClient.CreatingLocalVersionTable"));
                        WorkspaceItemSet[] workspaceItemSets = workspace.getItems(new ItemSpec[]{new ItemSpec("$/", RecursionType.FULL)}, DeletedState.ANY, ItemType.ANY, true, GetItemsOptions.INCLUDE_RECURSIVE_DELETES);
                        if (null != workspaceItemSets && 1 == workspaceItemSets.length) {
                            if (taskMonitor.isCanceled()) {
                                throw new CoreCancelException();
                            }
                            BaselineRequest[] baselineRequests = LocalDataAccessLayer.populateLocalVersionTable(localWorkspace, workspaceItemSets[0].getItems(), taskMonitor.newSubTaskMonitor(10));
                            if (null != baselineRequests) {
                                if (taskMonitor.isCanceled()) {
                                    throw new CoreCancelException();
                                }
                                taskMonitor.setCurrentWorkDescription(Messages.getString("VersionControlClient.CompressingAndDownloadingBaselines"));
                                LocalDataAccessLayer.processConversionBaselineRequests(localWorkspace, Arrays.asList(baselineRequests));
                            }
                            taskMonitor.worked(20);
                        } else {
                            taskMonitor.worked(30);
                        }
                        if (taskMonitor.isCanceled()) {
                            throw new CoreCancelException();
                        }
                    }
                    catch (CoreCancelException e) {
                        if (workspacePropertiesCreated) {
                            String[] baselineFolders;
                            for (String baselineFolder : baselineFolders = LocalDataAccessLayer.getBaselineFolders(localWorkspace)) {
                                FileHelpers.deleteDirectory(baselineFolder);
                            }
                        }
                        throw e;
                    }
                    taskMonitor.setCurrentWorkDescription(Messages.getString("VersionControlClient.RemovingReadOnlyFromUneditedItems"));
                    LocalDataAccessLayer.markReadOnlyBit(localWorkspace, false, taskMonitor.newSubTaskMonitor(20));
                    taskMonitor.setCurrentWorkDescription(Messages.getString("VersionControlClient.ChangingWorkspaceLocationOnServer"));
                    this.getWebServiceLayer().updateWorkspace(workspace.getName(), workspace.getOwnerName(), localWorkspace, SupportedFeatures.ALL);
                    taskMonitor.worked(10);
                }
                finally {
                    if (wLock != null) {
                        wLock.close();
                    }
                }
                taskMonitor.setCurrentWorkDescription(Messages.getString("VersionControlClient.RefreshingWorkspace"));
                workspace.refresh();
                workspace.getWorkspaceWatcher().workingFoldersChanged(workspace.getFolders());
                taskMonitor.worked(10);
                Workstation.getCurrent(this.getConnection().getPersistenceStoreProvider()).notifyForWorkspace(workspace, Notification.VERSION_CONTROL_WORKSPACE_CHANGED);
            }
            finally {
                taskMonitor.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteWorkspace(Workspace workspace) {
        Check.notNull(workspace, "workspace");
        boolean isLocal = workspace.isLocal();
        String localMetadataRoot = WorkspaceLocation.LOCAL == workspace.getLocation() ? workspace.getLocalMetadataDirectory() : null;
        boolean isInCache = isLocal && Workstation.getCurrent(this.getConnection().getPersistenceStoreProvider()).getLocalWorkspaceInfo(this.getServerGUID(), workspace.getName(), workspace.getOwnerName()) != null;
        try {
            this.getWebServiceLayer().deleteWorkspace(workspace.getName(), workspace.getOwnerName());
            if (isInCache) {
                this.removeCachedWorkspace(workspace.getName(), workspace.getOwnerName());
            }
        }
        catch (VersionControlException exception) {
            if (!(exception instanceof WorkspaceNotFoundException) || !isInCache) {
                throw exception;
            }
            this.removeCachedWorkspace(workspace.getName(), workspace.getOwnerName());
        }
        finally {
            Workstation.getCurrent(this.getConnection().getPersistenceStoreProvider()).saveConfigIfDirty();
        }
        workspace.setDeleted(true);
        this.eventEngine.fireWorkspaceDeleted(new WorkspaceEvent(EventSource.newFromHere(), workspace, WorkspaceEvent.WorkspaceEventSource.INTERNAL));
        if (isLocal) {
            if (null != localMetadataRoot) {
                try {
                    FileHelpers.deleteDirectory(localMetadataRoot);
                }
                catch (Exception e) {
                    log.warn((Object)MessageFormat.format("Ignoring exception deleting local metadata directory {0}", localMetadataRoot), (Throwable)e);
                }
            }
            Workstation.getCurrent(this.getConnection().getPersistenceStoreProvider()).notifyForWorkspace(workspace, Notification.VERSION_CONTROL_WORKSPACE_DELETED);
        }
    }

    public Workspace getWorkspace(String localPath) throws ItemNotMappedException {
        return this.getLocalWorkspace(localPath, true);
    }

    public Workspace tryGetWorkspace(String localPath) {
        return this.getLocalWorkspace(localPath, false);
    }

    public Workspace getWorkspace(WorkspaceInfo workspaceInfo) throws WorkspaceNotFoundException {
        Check.notNull(workspaceInfo, "workspaceInfo");
        return this.getWorkspace(workspaceInfo.getName(), workspaceInfo.getOwnerName());
    }

    public Workspace getWorkspace(String workspaceName, String workspaceOwner) throws WorkspaceNotFoundException {
        Check.notNull(workspaceName, "workspaceName");
        Check.notNull(workspaceOwner, "workspaceOwner");
        Workspace workspace = this.getLocalWorkspace(workspaceName, workspaceOwner);
        if (workspace == null) {
            return this.getRepositoryWorkspace(workspaceName, workspaceOwner);
        }
        return workspace;
    }

    public Workspace queryWorkspace(String name, String owner) {
        return this.getWebServiceLayer().queryWorkspace(name, owner);
    }

    public Workspace[] queryWorkspaces(String name, String owner, String computer) {
        return this.getRepositoryWorkspaces(name, owner, computer, WorkspacePermissions.NONE_OR_NOT_SUPPORTED);
    }

    public Workspace[] queryWorkspaces(String workspaceName, String workspaceOwner, String computer, WorkspacePermissions permissionsFilter) {
        return this.getRepositoryWorkspaces(workspaceName, workspaceOwner, computer, permissionsFilter);
    }

    public Shelveset[] queryShelvesets(String shelvesetName, String shelvesetOwner, String[] itemPropertyFilters) {
        itemPropertyFilters = this.mergeWithDefaultItemPropertyFilters(itemPropertyFilters);
        return this.getWebServiceLayer().queryShelvesets(shelvesetName, shelvesetOwner, itemPropertyFilters);
    }

    public void deleteShelveset(String name, String owner) {
        Check.notNullOrEmpty(name, "name");
        Check.notNullOrEmpty(owner, "owner");
        this.getWebServiceLayer().deleteShelveset(name, owner);
    }

    public void reportFailures(Workspace workspace, Failure[] failures) {
        Check.notNull(workspace, "workspace");
        if (failures != null) {
            for (int i = 0; i < failures.length; ++i) {
                this.eventEngine.fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), workspace, failures[i]));
            }
        }
    }

    private void reportFailures(Failure[] failures) {
        if (failures != null) {
            for (int i = 0; i < failures.length; ++i) {
                this.eventEngine.fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, failures[i]));
            }
        }
    }

    public void recordDownloadProxyFailure() {
        this.connection.getTFProxyServerSettings().recordFailure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URI getDownloadURI() {
        Object object = this.downloadFileURILock;
        synchronized (object) {
            if (this.downloadFileURI == null) {
                this.downloadFileURI = URI.create(this.connection.getServerDataProvider().locationForCurrentConnection("Download", ServiceInterfaceIdentifiers.VERSION_CONTROL_DOWNLOAD));
                if (this.downloadFileURI.getHost() == null) {
                    this.downloadFileURI = this.getConnection().getBaseURI().resolve(this.downloadFileURI);
                }
            }
            return this.downloadFileURI;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URI getUploadURI() {
        Object object = this.uploadFileURILock;
        synchronized (object) {
            if (this.uploadFileURI == null) {
                this.uploadFileURI = URI.create(this.connection.getServerDataProvider().locationForCurrentConnection("Upload", ServiceInterfaceIdentifiers.VERSION_CONTROL_UPLOAD));
                if (this.uploadFileURI.getHost() == null) {
                    this.uploadFileURI = this.getConnection().getBaseURI().resolve(this.uploadFileURI);
                }
            }
            return this.uploadFileURI;
        }
    }

    public void downloadFile(DownloadSpec spec, File destinationFile, boolean autoGunzip) throws CanceledException {
        this.downloadFile(spec, destinationFile, autoGunzip, null, null);
    }

    /*
     * Loose catch block
     */
    public void downloadFile(DownloadSpec spec, File destinationFile, boolean autoGunzip, EventSource eventSource, TaskMonitor taskMonitor) throws CanceledException {
        boolean wasCanceled;
        block11: {
            Check.notNull(spec, "spec");
            Check.notNull(destinationFile, "destinationFile");
            if (!(destinationFile.getParentFile().exists() || destinationFile.getParentFile().mkdirs() || destinationFile.getParentFile().isDirectory())) {
                throw new VersionControlException(MessageFormat.format(Messages.getString("VersionControlClient.ErrorCreatingDirectoryBeforeDownloadFormat"), destinationFile.getParentFile(), destinationFile));
            }
            FileOutputStream outputStream = null;
            wasCanceled = false;
            try {
                outputStream = new FileOutputStream(destinationFile);
                this.downloadFileToStream(spec, outputStream, autoGunzip, eventSource, taskMonitor);
                IOUtils.closeSafely(outputStream);
                if (outputStream == null) break block11;
            }
            catch (CanceledException e) {
                block12: {
                    wasCanceled = true;
                    if (outputStream == null) break block12;
                    IOUtils.closeSafely(outputStream);
                    outputStream = null;
                }
                if (wasCanceled && !destinationFile.delete()) {
                    log.warn((Object)MessageFormat.format("Error deleting file {0} after cancelation", destinationFile));
                }
                return;
            }
            catch (IOException e2) {
                throw new VersionControlException(e2);
                {
                    catch (Throwable throwable) {
                        if (outputStream != null) {
                            IOUtils.closeSafely(outputStream);
                            outputStream = null;
                        }
                        if (wasCanceled && !destinationFile.delete()) {
                            log.warn((Object)MessageFormat.format("Error deleting file {0} after cancelation", destinationFile));
                        }
                        throw throwable;
                    }
                }
            }
            IOUtils.closeSafely(outputStream);
            outputStream = null;
        }
        if (wasCanceled && !destinationFile.delete()) {
            log.warn((Object)MessageFormat.format("Error deleting file {0} after cancelation", destinationFile));
        }
    }

    public File downloadFileToTempLocation(DownloadSpec spec, String fileName) throws CanceledException {
        File tempDir;
        Check.notNull(spec, "spec");
        Check.notNullOrEmpty(fileName, "fileName");
        try {
            tempDir = TempStorageService.getInstance().createTempDirectory();
        }
        catch (IOException ex) {
            throw new VersionControlException(ex);
        }
        File tempFile = new File(tempDir, fileName);
        this.downloadFile(spec, tempFile, true);
        return tempFile;
    }

    public void downloadFileToStream(DownloadSpec spec, OutputStream outputStream, boolean autoGunzip) throws CanceledException {
        this.downloadFileToStream(spec, outputStream, autoGunzip, null, null);
    }

    public void downloadFileToStream(DownloadSpec spec, OutputStream outputStream, boolean autoGunzip, EventSource eventSource, TaskMonitor taskMonitor) throws CanceledException {
        Check.notNull(outputStream, "outputStream");
        this.downloadFileToStreams(spec, new DownloadOutput[]{new OutputStreamDownloadOutput(outputStream, autoGunzip)}, eventSource, taskMonitor);
    }

    public void downloadFileToStreams(DownloadSpec spec, DownloadOutput[] outputs, EventSource eventSource, TaskMonitor taskMonitor) throws CanceledException {
        Check.notNull(spec, "spec");
        Check.notNullOrEmpty(outputs, "outputs");
        int maxRetry = Integer.getInteger(MAX_REQUEST_RETRY_PROPERTY, 3);
        if (eventSource == null) {
            eventSource = EventSource.newFromHere();
        }
        boolean hadDownloadProxyException = false;
        boolean hadSocketException = false;
        for (int retryCount = 1; retryCount <= maxRetry; ++retryCount) {
            log.info((Object)("File download attempt " + retryCount));
            try {
                if (hadSocketException) {
                    this.resetOutputs(outputs);
                }
                this.downloadFileToStreamsInternal(spec, outputs, taskMonitor);
                return;
            }
            catch (SocketException e) {
                log.warn((Object)("SocketException for " + spec.getQueryString()), (Throwable)e);
                if (!e.getMessage().startsWith("Connection reset")) {
                    throw new VersionControlException(e);
                }
                if (retryCount == maxRetry) {
                    log.warn((Object)MessageFormat.format("Max retry reached {0}, not trying any longer", spec.getQueryString()));
                    throw new VersionControlException(e);
                }
                hadSocketException = true;
                log.warn((Object)MessageFormat.format("Retrying download after a connection reset for {0}", spec.getQueryString()), (Throwable)e);
            }
            catch (SocketTimeoutException e) {
                log.warn((Object)("SocketTimeoutException for " + spec.getQueryString()), (Throwable)e);
                if (retryCount == maxRetry) {
                    log.warn((Object)MessageFormat.format("Max retry reached {0}, not trying any longer", spec.getQueryString()));
                    throw new VersionControlException(e);
                }
                hadSocketException = true;
                log.warn((Object)MessageFormat.format("Retrying download after a socket timeout for {0}", spec.getQueryString()), (Throwable)e);
            }
            catch (DownloadProxyException e) {
                if (hadDownloadProxyException) {
                    log.warn((Object)MessageFormat.format("Second download proxy error for {0}, which should never happen because we disabled the download proxy, rethrowing", spec.getQueryString()));
                    throw new VersionControlException(e);
                }
                hadDownloadProxyException = true;
                log.warn((Object)MessageFormat.format("Download proxy error for {0}, disabling for this session", spec.getQueryString()));
                this.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(eventSource, this, (Throwable)e));
                this.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(eventSource, this, (Throwable)new DownloadProxyException(Messages.getString("VersionControlClient.DisablingDownloadProxyForThisSessionAndRetrying"))));
                this.recordDownloadProxyFailure();
            }
            catch (IOException e) {
                log.warn((Object)"Fatal IOException stops download retries", (Throwable)e);
                throw new VersionControlException(e);
            }
            long delayTime = 10000L * (long)Math.pow(2.0, retryCount - 1);
            log.info((Object)("Retrying request in " + delayTime + " ms"));
            try {
                Thread.sleep(delayTime);
                continue;
            }
            catch (InterruptedException e) {
                log.debug((Object)"Sleeping thred has been interrupted", (Throwable)e);
                throw new VersionControlException(e);
            }
        }
    }

    private void resetOutputs(DownloadOutput[] outputs) throws IOException {
        IOException firstResetException = null;
        for (DownloadOutput output : outputs) {
            try {
                output.resetOutputStream();
            }
            catch (IOException e) {
                log.warn((Object)MessageFormat.format("Could not reset stream on download output {1}", output), (Throwable)e);
                if (firstResetException != null) continue;
                firstResetException = e;
            }
        }
        if (firstResetException != null) {
            throw firstResetException;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void downloadFileToStreamsInternal(DownloadSpec spec, DownloadOutput[] outputs, TaskMonitor taskMonitor) throws CanceledException, DownloadProxyException, SocketException {
        boolean needGZIPInputStream;
        ArrayList<DownloadOutput> normalOutputs;
        ArrayList<DownloadOutput> wireOutputs;
        InputStream responseStream;
        GetMethod method;
        block22: {
            int len$;
            DownloadOutput[] arr$;
            block23: {
                method = null;
                if (taskMonitor == null) {
                    taskMonitor = TaskMonitorService.getTaskMonitor();
                }
                responseStream = null;
                try {
                    method = this.beginDownloadRequest(spec);
                    Header contentLength = method.getResponseHeader("Content-Length");
                    Header contentType = method.getResponseHeader("Content-Type");
                    responseStream = method.getResponseBodyAsStream();
                    wireOutputs = new ArrayList<DownloadOutput>();
                    normalOutputs = new ArrayList<DownloadOutput>();
                    needGZIPInputStream = false;
                    if (contentLength == null || contentLength.getValue().equals("0") || contentType != null && contentType.getValue().equalsIgnoreCase("application/octet-stream")) {
                        for (DownloadOutput output : outputs) {
                            output.setActualContentType("application/octet-stream");
                            normalOutputs.add(output);
                        }
                        break block22;
                    }
                    if (contentType != null && contentType.getValue().equalsIgnoreCase("application/gzip")) {
                        arr$ = outputs;
                        len$ = arr$.length;
                        break block23;
                    }
                    throw new VersionControlException(MessageFormat.format(Messages.getString("VersionControlClient.UnsupportedContentTypeFormat"), contentType != null ? contentType.getValue() : "<not set>"));
                }
                catch (SocketException e) {
                    try {
                        throw e;
                        catch (IOException e2) {
                            throw new VersionControlException(e2);
                        }
                    }
                    catch (Throwable throwable) {
                        if (responseStream != null) {
                            IOUtils.closeSafely(responseStream);
                        }
                        if (method == null) throw throwable;
                        this.abortDownloadRequest(method);
                        throw throwable;
                    }
                }
            }
            for (int i$ = 0; i$ < len$; ++i$) {
                DownloadOutput output;
                output = arr$[i$];
                if (output.isAutoGunzip()) {
                    needGZIPInputStream = true;
                    normalOutputs.add(output);
                    output.setActualContentType("application/octet-stream");
                    continue;
                }
                wireOutputs.add(output);
                output.setActualContentType("application/gzip");
            }
            if (!needGZIPInputStream) {
                normalOutputs.addAll(wireOutputs);
                wireOutputs.clear();
            }
        }
        if (needGZIPInputStream) {
            if (wireOutputs.size() > 0) {
                responseStream = new TappedInputStream(responseStream, new TappedInputStream.ReadHandler(){

                    @Override
                    public void handleRead(byte[] b, int off, int len, int readCount) throws IOException {
                        for (DownloadOutput output : wireOutputs) {
                            output.getOutputStream().write(b, off, readCount);
                        }
                    }

                    @Override
                    public void handleRead(byte[] b, int readCount) throws IOException {
                        for (DownloadOutput output : wireOutputs) {
                            output.getOutputStream().write(b, 0, readCount);
                        }
                    }

                    @Override
                    public void handleRead(byte b) throws IOException {
                        for (DownloadOutput output : wireOutputs) {
                            output.getOutputStream().write(b);
                        }
                    }
                });
            }
            responseStream = new GZIPInputStream(responseStream);
        }
        byte[] buffer = new byte[32768];
        if (method.getResponseContentLength() <= 0L) {
            for (DownloadOutput output : normalOutputs) {
                output.getOutputStream();
            }
        } else {
            int read;
            while ((read = responseStream.read(buffer, 0, buffer.length)) > 0) {
                if (taskMonitor.isCanceled()) {
                    this.abortDownloadRequest(method);
                    throw new CanceledException();
                }
                for (DownloadOutput output : normalOutputs) {
                    output.getOutputStream().write(buffer, 0, read);
                }
            }
        }
        IOUtils.closeSafely(responseStream);
        responseStream = null;
        this.finishDownloadRequest(method);
        method = null;
        if (responseStream != null) {
            IOUtils.closeSafely(responseStream);
        }
        if (method == null) return;
        this.abortDownloadRequest(method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String downloadItems(Item[] items, String serverRoot, String localRoot) throws CanceledException {
        Check.notNull(items, "items");
        Check.notNull(serverRoot, "serverRoot");
        TaskMonitor taskMonitor = TaskMonitorService.getTaskMonitor();
        taskMonitor.begin(Messages.getString("VersionControlClient.DownloadingItems"), items.length + 2);
        try {
            if (localRoot == null) {
                try {
                    localRoot = TempStorageService.getInstance().createTempDirectory().getAbsolutePath();
                }
                catch (IOException ex) {
                    throw new VersionControlException(ex);
                }
                TempStorageService.getInstance().forgetItem(new File(localRoot));
            }
            taskMonitor.worked(1);
            Arrays.sort(items, new Comparator<Item>(){

                @Override
                public int compare(Item item1, Item item2) {
                    return ServerPath.compareTopDown(item1.getServerItem(), item2.getServerItem());
                }
            });
            taskMonitor.worked(1);
            EventSource eventSource = EventSource.newFromHere();
            AccountingCompletionService<WorkerStatus> completionService = new AccountingCompletionService<WorkerStatus>(this.getUploadDownloadWorkerExecutor());
            try {
                for (int i = 0; i < items.length; ++i) {
                    if (taskMonitor.isCanceled()) {
                        throw new CanceledException();
                    }
                    Item item = items[i];
                    if (item.getItemType() == ItemType.FILE) {
                        Check.notNull(item.getDownloadURL(), "item.getDownloadUrl()");
                    }
                    if (!ServerPath.isChild(serverRoot, item.getServerItem())) {
                        throw new IllegalArgumentException(MessageFormat.format("Item''s server path {0} must start with server root {1}", item.getServerItem(), serverRoot));
                    }
                    String localPath = ServerPath.makeLocal(item.getServerItem(), serverRoot, localRoot);
                    taskMonitor.setCurrentWorkDescription(localPath);
                    completionService.submit(new TempDownloadWorker(eventSource, taskMonitor, this, item.getDownloadURL(), new File(localPath), item.getItemType()));
                    taskMonitor.worked(1);
                }
            }
            finally {
                GetEngine.waitForCompletions(completionService);
            }
            if (taskMonitor.isCanceled()) {
                throw new CanceledException();
            }
            String string = localRoot;
            return string;
        }
        finally {
            taskMonitor.done();
        }
    }

    private GetMethod beginDownloadRequest(DownloadSpec spec) throws MalformedURLException, DownloadProxyException, SocketException {
        Check.notNull(spec, "spec");
        TFProxyServerSettings tfProxyServerSettings = this.connection.getTFProxyServerSettings();
        String tfsProxyURL = null;
        if (tfProxyServerSettings.isAvailable()) {
            tfsProxyURL = tfProxyServerSettings.getURL();
        }
        String downloadURIString = null;
        String downloadHost = null;
        String reEncodedDownloadSpec = URIUtils.encodeQueryIgnoringPercentCharacters(spec.getQueryString());
        if (tfsProxyURL == null) {
            URI uri = this.getDownloadURI();
            downloadURIString = uri.toString() + "?" + reEncodedDownloadSpec;
            downloadHost = uri.getHost();
        } else {
            String proxyDownloadFile = this.getServerSupportedFeatures().contains(SupportedFeatures.CREATE_BRANCH) ? "/VersionControlProxy/V1.0/item.asmx" : "/VersionControlProxy/item.asmx";
            URI uri = URIUtils.newURI(tfsProxyURL).resolve(proxyDownloadFile);
            downloadURIString = uri.toString() + "?" + reEncodedDownloadSpec + "&" + "rid" + "=" + this.getServerGUID();
            downloadHost = uri.getHost();
        }
        GetMethod getMethod = new GetMethod(downloadURIString);
        getMethod.setDoAuthentication(true);
        HttpClient client = this.getHTTPClient();
        int status = -1;
        try {
            status = client.executeMethod(getMethod);
        }
        catch (ConnectException e) {
            this.finishDownloadRequest(getMethod);
            if (tfsProxyURL != null) {
                throw new DownloadProxyException(MessageFormat.format(Messages.getString("VersionControlClient.CouldNotConnectToDownloadProxyServerFormat"), downloadHost, e.getMessage()));
            }
            throw new VersionControlException(MessageFormat.format(Messages.getString("VersionControlClient.CouldNotConnecttoTFSFormat"), downloadHost, e.getLocalizedMessage()));
        }
        catch (UnknownHostException e) {
            this.finishDownloadRequest(getMethod);
            if (tfsProxyURL != null) {
                throw new DownloadProxyException(MessageFormat.format(Messages.getString("VersionControlClient.CouldNotResolveDownloadProxyServertoNetworkAddressFormat"), downloadHost));
            }
            throw new VersionControlException(MessageFormat.format(Messages.getString("VersionControlClient.CouldNotResolveTFSToNetworkAddressFormat"), downloadHost));
        }
        catch (SocketException e) {
            this.finishDownloadRequest(getMethod);
            throw e;
        }
        catch (SocketTimeoutException e) {
            this.finishDownloadRequest(getMethod);
            if (tfsProxyURL != null) {
                throw new DownloadProxyException(MessageFormat.format(Messages.getString("VersionControlClient.ErrorConnectingToDownloadProxyServerFormat"), downloadHost, e.getMessage()));
            }
            throw new VersionControlException(MessageFormat.format(Messages.getString("VersionControlClient.ErrorConnectingToTFSFormat"), downloadHost, e.getLocalizedMessage()));
        }
        catch (IOException e) {
            this.finishDownloadRequest(getMethod);
            if (tfsProxyURL != null) {
                throw new DownloadProxyException(MessageFormat.format(Messages.getString("VersionControlClient.ErrorConnectingToDownloadProxyServerFormat"), downloadHost, e.getMessage()));
            }
            throw new VersionControlException(MessageFormat.format(Messages.getString("VersionControlClient.ErrorConnectingToTFSFormat"), downloadHost, e.getLocalizedMessage()));
        }
        if (status != 200) {
            this.finishDownloadRequest(getMethod);
            if (tfsProxyURL != null) {
                throw new DownloadProxyException(MessageFormat.format(Messages.getString("VersionControlClient.DownloadProxyAtURLReturnedHTTPStatusForGETFormat"), tfsProxyURL.toString(), status));
            }
            this.handleStatus(getMethod);
        }
        return getMethod;
    }

    private void abortDownloadRequest(GetMethod method) {
        Check.notNull(method, "method");
        method.abort();
        this.finishDownloadRequest(method);
    }

    private void finishDownloadRequest(GetMethod method) {
        Check.notNull(method, "method");
        method.releaseConnection();
    }

    public PostMethod beginUploadRequest() {
        String uploadPage = this.getUploadURI().toString();
        PostMethod post = new PostMethod(uploadPage);
        post.setDoAuthentication(true);
        return post;
    }

    public void executeUploadRequest(PostMethod method) throws IOException {
        Check.notNull(method, "method");
        HttpClient client = this.getHTTPClient();
        Check.notNull(client, "client");
        int status = client.executeMethod(method);
        if (status != 200) {
            this.handleStatus(method);
        }
    }

    private void handleStatus(HttpMethodBase method) {
        Check.notNull(method, "method");
        String request = "request";
        try {
            request = method.getName() + " " + method.getURI();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (method.getStatusCode() == 500 && method.getResponseHeader("X-VersionControl-Exception") != null) {
            String responseString;
            String exceptionName = method.getResponseHeader("X-VersionControl-Exception").getValue();
            try {
                responseString = method.getResponseBodyAsString(2048);
            }
            catch (IOException e) {
                throw new VersionControlException(Messages.getString("VersionControlClient.CouldNotParseErrorMessageFromServer"), e);
            }
            if (responseString.length() > 0) {
                throw new VersionControlException(responseString);
            }
            if (exceptionName != null) {
                throw new VersionControlException(MessageFormat.format(Messages.getString("VersionControlClient.ServerThrewExceptionForRequestFormat"), exceptionName, request));
            }
        }
        throw new VersionControlException(MessageFormat.format(Messages.getString("VersionControlClient.ServerReturnedHTTPStatusForRequestFormat"), Integer.toString(method.getStatusCode()), request));
    }

    public void finishUploadRequest(PostMethod method) {
        Check.notNull(method, "method");
        method.releaseConnection();
    }

    public Changeset getChangeset(int changesetID) {
        return this.getChangeset(changesetID, true, false, null, null);
    }

    public Changeset getChangeset(int changesetID, boolean includeChanges, boolean includeDownloadInfo, String[] changesetPropertyFilters, String[] itemPropertyFilters) {
        Changeset changeset;
        if (this.getWebServiceLayer().getServiceLevel().getValue() >= WebServiceLevel.TFS_2010.getValue()) {
            itemPropertyFilters = this.mergeWithDefaultItemPropertyFilters(itemPropertyFilters);
            changeset = this.getWebServiceLayer().queryChangesetExtended(changesetID, includeChanges, includeDownloadInfo, changesetPropertyFilters, null, itemPropertyFilters);
        } else {
            changeset = this.getWebServiceLayer().queryChangeset(changesetID, includeChanges, includeDownloadInfo, true);
        }
        if (includeChanges) {
            changeset.sortChanges();
        }
        return changeset;
    }

    public Change[] getChangesForChangeset(int changesetID, boolean includeDownloadInfo, int pageSize, ItemSpec lastItem, String[] itemPropertyFilters, boolean includeMergeSourceInfo) {
        itemPropertyFilters = this.mergeWithDefaultItemPropertyFilters(itemPropertyFilters);
        return this.webServiceLayer.queryChangesForChangeset(changesetID, includeDownloadInfo, pageSize, lastItem, null, itemPropertyFilters, includeMergeSourceInfo);
    }

    public Item getItem(int itemID, int changesetNumber) {
        return this.getItem(itemID, changesetNumber, false);
    }

    public Item getItem(int itemID, int changesetNumber, GetItemsOptions options) {
        return this.getItems(new int[]{itemID}, changesetNumber, options)[0];
    }

    public Item getItem(int itemID, int changesetNumber, boolean includeDownloadInfo) {
        return this.getItems(new int[]{itemID}, changesetNumber, includeDownloadInfo)[0];
    }

    public Item[] getItems(int[] itemIDs, int changesetNumber) {
        return this.getItems(itemIDs, changesetNumber, GetItemsOptions.NONE);
    }

    public Item[] getItems(int[] itemIDs, int changesetNumber, boolean includeDownloadInfo) {
        return this.getItems(itemIDs, changesetNumber, includeDownloadInfo ? GetItemsOptions.DOWNLOAD : GetItemsOptions.NONE);
    }

    public Item[] getItems(int[] itemIDs, int changesetNumber, GetItemsOptions options) {
        Check.notNull(itemIDs, "itemIDs");
        for (int i = 0; i < itemIDs.length; ++i) {
            if (changesetNumber == -1) {
                throw new VersionControlException(MessageFormat.format(Messages.getString("VersionControlClient.ItemWithIDCannotBeUsedWithChangesetNumberFormat"), Integer.toString(itemIDs[i]), Integer.toString(changesetNumber)));
            }
            if (itemIDs[i] >= 1) continue;
            throw new VersionControlException(MessageFormat.format(Messages.getString("VersionControlClient.ItemIDIsInvalidFormat"), Integer.toString(itemIDs[i])));
        }
        if (changesetNumber <= 0) {
            throw new VersionControlException(MessageFormat.format(Messages.getString("VersionControlClient.NotValidChangesetNumberPleaseSpecifyBetween1AndMaxFormat"), Integer.toString(changesetNumber), Integer.toString(Integer.MAX_VALUE)));
        }
        return this.getWebServiceLayer().queryItemsByID(itemIDs, changesetNumber, options.contains(GetItemsOptions.DOWNLOAD), options);
    }

    public Item getItem(String path) {
        return this.getItem(path, LatestVersionSpec.INSTANCE);
    }

    public Item getItem(String path, VersionSpec version) {
        return this.getItem(path, version, 0);
    }

    public Item getItem(String path, VersionSpec version, DeletedState deletedState) {
        return this.getItem(path, version, deletedState, false);
    }

    public Item getItem(String path, VersionSpec version, int deletionID) {
        return this.getItem(path, version, deletionID, false);
    }

    public Item getItem(String path, VersionSpec version, DeletedState deletedState, boolean includeDownloadInfo) {
        return this.getItem(path, version, deletedState, includeDownloadInfo ? GetItemsOptions.DOWNLOAD : GetItemsOptions.NONE);
    }

    public Item getItem(String path, VersionSpec version, int deletionID, GetItemsOptions options) {
        return this.getItem(path, version, deletionID > 0 ? DeletedState.DELETED : DeletedState.NON_DELETED, options);
    }

    public Item getItem(String path, VersionSpec version, int deletionID, boolean includeDownloadInfo) {
        return this.getItem(path, version, deletionID, includeDownloadInfo ? GetItemsOptions.DOWNLOAD : GetItemsOptions.NONE);
    }

    public Item getItem(String path, VersionSpec version, DeletedState deletedState, GetItemsOptions options) {
        Item ret = this.getItemInternal(path, version, deletedState, options);
        if (ret == null) {
            if (version == null || version.equals(LatestVersionSpec.INSTANCE)) {
                throw new VersionControlException(MessageFormat.format(Messages.getString("VersionControlClient.ItemWasNotFoundInRepositoryFormat"), path));
            }
            throw new VersionControlException(MessageFormat.format(Messages.getString("VersionControlClient.ItemWasNotFoundInRepositoryAtSpecifiedVersionFormat"), path, version.toString()));
        }
        return ret;
    }

    public boolean testItemExists(String path) {
        return this.testItemExists(path, LatestVersionSpec.INSTANCE, DeletedState.NON_DELETED);
    }

    public boolean testItemExists(String path, VersionSpec version) {
        return this.testItemExists(path, version, DeletedState.NON_DELETED);
    }

    public boolean testItemExists(String path, VersionSpec version, DeletedState deletedState) {
        return this.getItemInternal(path, version, deletedState, GetItemsOptions.NONE) != null;
    }

    private Item getItemInternal(String path, VersionSpec version, DeletedState deletedState, GetItemsOptions options) {
        Check.notNullOrEmpty(path, "path");
        if (Wildcard.isWildcard(path)) {
            throw new VersionControlException(Messages.getString("VersionControlClient.WildcardsAreNotAllowedInPath"));
        }
        ItemSet set = this.getItems(new ItemSpec(path, RecursionType.NONE), version, deletedState, ItemType.ANY, options);
        Item[] items = set.getItems();
        if (items.length > 0) {
            return items[0];
        }
        return null;
    }

    public ItemSet getItems(String path) {
        return this.getItems(path, LatestVersionSpec.INSTANCE, RecursionType.NONE);
    }

    public ItemSet getItems(String path, RecursionType recursion) {
        return this.getItems(path, LatestVersionSpec.INSTANCE, recursion);
    }

    public ItemSet getItems(String path, VersionSpec version, RecursionType recursion) {
        return this.getItems(path, version, recursion, DeletedState.NON_DELETED, ItemType.ANY, false);
    }

    public ItemSet[] getItems(ItemSpec[] itemSpecs, VersionSpec version, DeletedState deletedState, ItemType itemType) {
        return this.getItems(itemSpecs, version, deletedState, itemType, false);
    }

    public ItemSet getItems(ItemSpec itemSpec, VersionSpec version, DeletedState deletedState, ItemType itemType, GetItemsOptions options) {
        return this.getItems(new ItemSpec[]{itemSpec}, version, deletedState, itemType, options)[0];
    }

    public ItemSet getItems(ItemSpec itemSpec, VersionSpec version, DeletedState deletedState, ItemType itemType, boolean includeDownloadInfo) {
        return this.getItems(new ItemSpec[]{itemSpec}, version, deletedState, itemType, includeDownloadInfo)[0];
    }

    public ItemSet[] getItems(ItemSpec[] itemSpecs, VersionSpec version, DeletedState deletedState, ItemType itemType, boolean includeDownloadInfo) {
        return this.getItems(itemSpecs, version, deletedState, itemType, includeDownloadInfo ? GetItemsOptions.DOWNLOAD : GetItemsOptions.NONE);
    }

    public ItemSet getItems(String path, VersionSpec version, RecursionType recursion, DeletedState deletedState, ItemType itemType) {
        return this.getItems(path, version, recursion, deletedState, itemType, false);
    }

    public ItemSet getItems(String path, VersionSpec version, RecursionType recursion, DeletedState deletedState, ItemType itemType, boolean includeDownloadInfo) {
        return this.getItems(new ItemSpec(path, recursion), version, deletedState, itemType, includeDownloadInfo);
    }

    public ItemSet[] getItems(ItemSpec[] itemSpecs, VersionSpec version, DeletedState deletedState, ItemType itemType, GetItemsOptions options) {
        return this.getItems(itemSpecs, version, deletedState, itemType, options, null);
    }

    public ItemSet[] getItems(ItemSpec[] itemSpecs, VersionSpec version, DeletedState deletedState, ItemType itemType, GetItemsOptions options, String[] itemPropertyFilters) {
        Check.notNullOrEmpty(itemSpecs, "itemSpecs");
        itemPropertyFilters = this.mergeWithDefaultItemPropertyFilters(itemPropertyFilters);
        AtomicReference<String> workspaceName = new AtomicReference<String>();
        AtomicReference<String> workspaceOwner = new AtomicReference<String>();
        this.determineWorkspaceNameAndOwner(itemSpecs, workspaceName, workspaceOwner);
        ItemSet[] sets = this.getWebServiceLayer().queryItems(workspaceName.get(), workspaceOwner.get(), itemSpecs, version, deletedState, itemType, options.contains(GetItemsOptions.DOWNLOAD), options, itemPropertyFilters, null);
        if (!options.contains(GetItemsOptions.UNSORTED)) {
            for (int i = 0; i < sets.length; ++i) {
                Object[] items = sets[i].getItems();
                Arrays.sort(items);
                sets[i].setItems((Item[])items);
            }
        }
        return sets;
    }

    public ExtendedItem[][] getExtendedItems(ItemSpec[] itemSpecs, DeletedState deletedState, ItemType itemType) {
        return this.getExtendedItems(itemSpecs, deletedState, itemType, GetItemsOptions.NONE);
    }

    public ExtendedItem[][] getExtendedItems(ItemSpec[] itemSpecs, DeletedState deletedState, ItemType itemType, GetItemsOptions options) {
        return this.getExtendedItems(null, null, itemSpecs, deletedState, itemType, options);
    }

    public ExtendedItem[] getExtendedItems(String itemPath, DeletedState deletedState, ItemType itemType) {
        return this.getExtendedItems(new ItemSpec[]{new ItemSpec(itemPath, RecursionType.NONE)}, deletedState, itemType, GetItemsOptions.NONE)[0];
    }

    public ExtendedItem[][] getExtendedItems(String workspaceName, String workspaceOwner, ItemSpec[] itemSpecs, DeletedState deletedState, ItemType itemType, GetItemsOptions options) {
        return this.getExtendedItems(workspaceName, workspaceOwner, itemSpecs, deletedState, itemType, options, null);
    }

    public ExtendedItem[][] getExtendedItems(String workspaceName, String workspaceOwner, ItemSpec[] itemSpecs, DeletedState deletedState, ItemType itemType, GetItemsOptions options, String[] itemPropertyFilters) {
        Check.notNullOrEmpty(itemSpecs, "itemSpecs");
        Check.notNull(deletedState, "deletedState");
        Check.notNull(itemType, "itemType");
        Check.notNull(options, "options");
        itemPropertyFilters = this.mergeWithDefaultItemPropertyFilters(itemPropertyFilters);
        if (options.contains(GetItemsOptions.UNSORTED) || options.contains(GetItemsOptions.DOWNLOAD)) {
            throw new VersionControlException(MessageFormat.format(Messages.getString("VersionControlClient.TheUnsortedAndDownloadOptionsAreNotAllowedFormat"), GetItemsOptions.UNSORTED.toString(), GetItemsOptions.DOWNLOAD.toString()));
        }
        if (workspaceName == null && workspaceOwner == null) {
            AtomicReference<String> workspaceNameHolder = new AtomicReference<String>();
            AtomicReference<String> workspaceOwnerHolder = new AtomicReference<String>();
            this.determineWorkspaceNameAndOwner(itemSpecs, workspaceNameHolder, workspaceOwnerHolder);
            workspaceName = workspaceNameHolder.get();
            workspaceOwner = workspaceOwnerHolder.get();
        }
        return this.getWebServiceLayer().queryItemsExtended(workspaceName, workspaceOwner, itemSpecs, deletedState, itemType, options, itemPropertyFilters);
    }

    public final SortedSet<CheckinNoteFieldDefinition> queryCheckinNoteFieldDefinitionsForServerPaths(String[] serverPaths) {
        Check.notNullOrEmpty(serverPaths, "serverPaths");
        String[] projects = ServerPath.getTeamProjects(serverPaths);
        CheckinNoteFieldDefinition[] definitions = this.getWebServiceLayer().queryCheckinNoteDefinition(projects);
        TreeSet<CheckinNoteFieldDefinition> unique = new TreeSet<CheckinNoteFieldDefinition>();
        if (definitions != null) {
            for (CheckinNoteFieldDefinition definition : definitions) {
                unique.add(definition);
            }
        }
        return unique;
    }

    public final void setExclusiveCheckout(String serverPath, boolean exclusiveCheckout) {
        Check.notNullOrEmpty(serverPath, "serverPath");
        String project = ServerPath.getTeamProject(serverPath);
        this.getWebServiceLayer().createAnnotation("ExclusiveCheckout", project, 0, Boolean.toString(exclusiveCheckout), null, true);
    }

    public Annotation[] queryAnnotation(String annotationName, String annotatedServerItem, int version) {
        Check.isTrue(annotationName != null || annotatedServerItem != null, "one of annotationName or annotatedServerItem must not be null");
        return this.getWebServiceLayer().queryAnnotation(annotationName, annotatedServerItem, version);
    }

    public void createAnnotation(String annotationName, String annotatedServerItem, int version, String annotationValue, String comment, boolean overwrite) {
        Check.notNull(annotatedServerItem, "annotatedServerItem");
        Check.notNull(annotationValue, "annotationValue");
        this.getWebServiceLayer().createAnnotation(annotationName, annotatedServerItem, version, annotationValue, comment, overwrite);
    }

    public void deleteAnnotation(String annotationName, String annotatedServerItem, int version, String annotationValue) {
        Check.isTrue(annotationName != null || annotatedServerItem != null, "one of annotationName or annotatedServerItem must not be null");
        this.getWebServiceLayer().deleteAnnotation(annotationName, annotatedServerItem, version, annotationValue);
    }

    public TFSTeamProjectCollection getConnection() {
        return this.connection;
    }

    public Changeset[] queryHistory(String serverOrLocalPath, VersionSpec version, int deletionID, RecursionType recursion, String user, VersionSpec versionFrom, VersionSpec versionTo, int maxCount, boolean includeFileDetails, boolean slotMode, boolean includeDownloadInfo, boolean sortAscending) throws ServerPathFormatException {
        Check.notNullOrEmpty(serverOrLocalPath, "serverOrLocalPath");
        Check.notNull(version, "version");
        Check.notNull(recursion, "recursion");
        Check.isTrue(maxCount > 0, "maxCount must be greater than 0");
        AtomicReference<String> workspaceName = new AtomicReference<String>();
        AtomicReference<String> workspaceOwner = new AtomicReference<String>();
        this.determineWorkspaceNameAndOwner(serverOrLocalPath, workspaceName, workspaceOwner);
        if (!(workspaceName.get() != null && workspaceOwner.get() != null || ServerPath.isServerPath(serverOrLocalPath))) {
            Check.isTrue(false, MessageFormat.format("Could not determine the workspace for local path {0}", serverOrLocalPath));
        }
        ItemSpec spec = new ItemSpec(serverOrLocalPath, recursion, deletionID);
        VersionSpec fromSpec = versionFrom != null ? versionFrom : new ChangesetVersionSpec(1);
        VersionSpec endVersion = versionTo;
        ArrayList<Changeset> foundChangeSets = new ArrayList<Changeset>();
        int chunk = 1;
        while (maxCount > 0) {
            Changeset[] sets;
            if (log.isDebugEnabled()) {
                log.debug((Object)MessageFormat.format("chunk {0}, maxCount {1}", Integer.toString(chunk++), Integer.toString(maxCount)));
            }
            int requestedCount = Math.min(maxCount, 256);
            if (log.isDebugEnabled()) {
                log.debug((Object)MessageFormat.format("requestedCount {0}", Integer.toString(requestedCount)));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)MessageFormat.format("requesting from {0} to {1}", fromSpec != null ? fromSpec.toString() : "null", endVersion != null ? endVersion.toString() : "null"));
            }
            if ((sets = this.getWebServiceLayer().queryHistory(workspaceName.get(), workspaceOwner.get(), spec, version, user, fromSpec, endVersion, requestedCount, includeFileDetails, includeDownloadInfo, slotMode, sortAscending)) == null) {
                log.debug((Object)"got null history sets");
                return null;
            }
            if (sets.length == 0) {
                log.debug((Object)"got empty history sets");
                break;
            }
            if (includeFileDetails) {
                for (Changeset set : sets) {
                    set.sortChanges();
                }
            }
            foundChangeSets.addAll(Arrays.asList(sets));
            if (log.isDebugEnabled()) {
                log.debug((Object)MessageFormat.format("got {0} history sets", sets.length));
            }
            if (sets.length < requestedCount) {
                log.debug((Object)"got less than a full chunk so exiting");
                break;
            }
            int lastChangesetID = sets[sets.length - 1].getChangesetID();
            if (lastChangesetID == 1) break;
            maxCount -= sets.length;
            endVersion = new ChangesetVersionSpec(lastChangesetID - 1);
        }
        return foundChangeSets.toArray(new Changeset[foundChangeSets.size()]);
    }

    public Iterator<Changeset> queryHistoryIterator(String serverOrLocalPath, VersionSpec version, int deletionID, RecursionType recursion, String user, VersionSpec versionFrom, VersionSpec versionTo, int maxCount, boolean includeFileDetails, boolean slotMode, boolean includeDownloadInfo, boolean sortAscending) throws ServerPathFormatException {
        Check.notNullOrEmpty(serverOrLocalPath, "serverOrLocalPath");
        Check.notNull(version, "version");
        Check.notNull(recursion, "recursion");
        Check.isTrue(maxCount > 0, "maxCount must be greater than 0");
        AtomicReference<String> workspaceName = new AtomicReference<String>();
        AtomicReference<String> workspaceOwner = new AtomicReference<String>();
        this.determineWorkspaceNameAndOwner(serverOrLocalPath, workspaceName, workspaceOwner);
        if (!(workspaceName.get() != null && workspaceOwner.get() != null || ServerPath.isServerPath(serverOrLocalPath))) {
            Check.isTrue(false, MessageFormat.format("Could not determine the workspace for local path {0}", serverOrLocalPath));
        }
        ItemSpec itemSpec = new ItemSpec(serverOrLocalPath, recursion, deletionID);
        HistoryIterator iterator = new HistoryIterator(this.getWebServiceLayer(), workspaceName.get(), workspaceOwner.get(), itemSpec, version, user, versionFrom, versionTo, maxCount, includeFileDetails, includeDownloadInfo, slotMode, sortAscending);
        iterator.prime();
        return iterator;
    }

    public int createBranch(String sourceServerPath, String targetServerPath, VersionSpec version) {
        return this.createBranch(sourceServerPath, targetServerPath, version, null, null, null, null, null);
    }

    public int createBranch(String sourceServerPath, String targetServerPath, VersionSpec version, String owner, String comment, CheckinNote checkinNote, PolicyOverrideInfo policyOverride, Mapping[] mappings) {
        Check.notNull(sourceServerPath, "sourcePath");
        Check.notNull(targetServerPath, "targetPath");
        Check.notNull(version, "version");
        Check.isTrue(ServerPath.isServerPath(sourceServerPath), "source path must be a server path");
        Check.isTrue(ServerPath.isServerPath(targetServerPath), "target path must be a server path");
        Changeset changeset = new Changeset(owner, comment, checkinNote, policyOverride);
        AtomicReference<Failure[]> failures = new AtomicReference<Failure[]>();
        CheckinResult result = this.getWebServiceLayer().createBranch(sourceServerPath, targetServerPath, version, changeset, null, mappings, failures);
        if (result.getChangeset() > 0) {
            this.eventEngine.fireBranchCommitted(new BranchCommittedEvent(EventSource.newFromHere(), sourceServerPath, targetServerPath, version, owner, comment, checkinNote, policyOverride, mappings, result.getChangeset()));
            Workstation.getCurrent(this.getConnection().getPersistenceStoreProvider()).notifyForFolderContentChanged(this, result.getChangeset());
        }
        return result.getChangeset();
    }

    public void updateChangeset(Changeset changeset) {
        Check.notNull(changeset, "changeset");
        this.getWebServiceLayer().updateChangeset(changeset.getChangesetID(), changeset.getComment(), changeset.getCheckinNote());
    }

    public LabelResult[] createLabel(VersionControlLabel label, LabelItemSpec[] items, LabelChildOption options) {
        Check.notNull(label, "label");
        Check.notNull(items, "items");
        Check.notNull(options, "options");
        AtomicReference<String> workspaceName = new AtomicReference<String>();
        AtomicReference<String> workspaceOwner = new AtomicReference<String>();
        this.determineWorkspaceNameAndOwner(items, workspaceName, workspaceOwner);
        label.setOwner(IdentityHelper.getUniqueNameIfCurrentUser(this.getConnection().getAuthorizedIdentity(), label.getOwner()));
        AtomicReference<Failure[]> failuresHolder = new AtomicReference<Failure[]>();
        LabelResult[] ret = this.getWebServiceLayer().labelItem(workspaceName.get(), workspaceOwner.get(), label, items, options, failuresHolder);
        this.reportFailures(failuresHolder.get());
        return ret;
    }

    public LabelResult[] deleteLabel(String label, String scope) {
        Check.notNull(label, "label");
        Check.notNull(scope, "scope");
        return this.getWebServiceLayer().deleteLabel(label, scope);
    }

    public LabelResult[] unlabelItem(String label, String scope, ItemSpec[] items, VersionSpec version) {
        Check.notNull(label, "label");
        Check.notNullOrEmpty(items, "items");
        Check.notNull(version, "version");
        AtomicReference<String> workspaceName = new AtomicReference<String>();
        AtomicReference<String> workspaceOwner = new AtomicReference<String>();
        this.determineWorkspaceNameAndOwner(items, workspaceName, workspaceOwner);
        AtomicReference<Failure[]> failuresHolder = new AtomicReference<Failure[]>();
        LabelResult[] results = this.getWebServiceLayer().unlabelItem(workspaceName.get(), workspaceOwner.get(), label, scope, items, version, failuresHolder);
        this.reportFailures(failuresHolder.get());
        return results;
    }

    public VersionControlLabel[] queryLabels(String label, String scope, String owner, boolean includeItemDetails, String filterItem, VersionSpec filterItemVersion) {
        AtomicReference<String> workspaceName = new AtomicReference<String>();
        AtomicReference<String> workspaceOwner = new AtomicReference<String>();
        this.determineWorkspaceNameAndOwner(filterItem, workspaceName, workspaceOwner);
        if (!(filterItem == null || workspaceName.get() != null && workspaceOwner.get() != null || ServerPath.isServerPath(filterItem))) {
            Check.isTrue(false, MessageFormat.format("Could not determine the workspace for local path {0}", filterItem));
        }
        return this.getWebServiceLayer().queryLabels(workspaceName.get(), workspaceOwner.get(), label, scope, owner, filterItem, filterItemVersion, includeItemDetails, true);
    }

    public PendingSet[] queryPendingSets(String[] serverOrLocalPaths, RecursionType recursionType, boolean includeDownloadInfo, String queryWorkspaceName, String queryWorkspaceOwner) {
        return this.queryPendingSets(serverOrLocalPaths, recursionType, includeDownloadInfo, queryWorkspaceName, queryWorkspaceOwner, null);
    }

    public PendingSet[] queryPendingSets(String[] serverOrLocalPaths, RecursionType recursionType, boolean includeDownloadInfo, String queryWorkspaceName, String queryWorkspaceOwner, String[] itemPropertyFilters) {
        Check.notNullOrEmpty(serverOrLocalPaths, "serverOrLocalPaths");
        Check.notNull(recursionType, "recursionType");
        itemPropertyFilters = this.mergeWithDefaultItemPropertyFilters(itemPropertyFilters);
        ItemSpec[] specs = new ItemSpec[serverOrLocalPaths.length];
        for (int i = 0; i < serverOrLocalPaths.length; ++i) {
            specs[i] = new ItemSpec(serverOrLocalPaths[i], recursionType, 0);
        }
        return this.queryPendingSets(specs, includeDownloadInfo, queryWorkspaceName, queryWorkspaceOwner, false, itemPropertyFilters);
    }

    public PendingSet[] queryPendingSets(ItemSpec[] itemSpecs, boolean includeDownloadInfo, String queryWorkspaceName, String queryWorkspaceOwner) {
        return this.queryPendingSets(itemSpecs, includeDownloadInfo, queryWorkspaceName, queryWorkspaceOwner, false);
    }

    public PendingSet[] queryPendingSets(ItemSpec[] itemSpecs, boolean includeDownloadInfo, String queryWorkspaceName, String queryWorkspaceOwner, boolean includeCandidates) {
        return this.queryPendingSets(itemSpecs, includeDownloadInfo, queryWorkspaceName, queryWorkspaceOwner, includeCandidates, null);
    }

    public PendingSet[] queryPendingSets(ItemSpec[] itemSpecs, boolean includeDownloadInfo, String queryWorkspaceName, String queryWorkspaceOwner, boolean includeCandidates, String[] itemPropertyFilters) {
        Check.notNullOrEmpty(itemSpecs, "itemSpecs");
        itemPropertyFilters = this.mergeWithDefaultItemPropertyFilters(itemPropertyFilters);
        AtomicReference<String> workspaceName = new AtomicReference<String>();
        AtomicReference<String> workspaceOwner = new AtomicReference<String>();
        this.determineWorkspaceNameAndOwner(itemSpecs, workspaceName, workspaceOwner);
        AtomicReference<Failure[]> failures = new AtomicReference<Failure[]>();
        PendingSet[] ret = this.getWebServiceLayer().queryPendingSets(workspaceName.get(), workspaceOwner.get(), queryWorkspaceName, queryWorkspaceOwner, itemSpecs, includeDownloadInfo, failures, includeCandidates, itemPropertyFilters);
        this.reportFailures(failures.get());
        return ret;
    }

    public PendingSet[] queryShelvedChanges(String shelvesetName, String shelvesetOwner, ItemSpec[] itemSpecs, boolean includeDownloadInfo) {
        return this.queryShelvedChanges(shelvesetName, shelvesetOwner, itemSpecs, includeDownloadInfo, null);
    }

    public PendingSet[] queryShelvedChanges(String shelvesetName, String shelvesetOwner, ItemSpec[] itemSpecs, boolean includeDownloadInfo, String[] itemPropertyFilters) {
        AtomicReference<String> workspaceName = new AtomicReference<String>();
        AtomicReference<String> workspaceOwner = new AtomicReference<String>();
        this.determineWorkspaceNameAndOwner(itemSpecs, workspaceName, workspaceOwner);
        itemPropertyFilters = this.mergeWithDefaultItemPropertyFilters(itemPropertyFilters);
        return this.queryShelvedChanges(workspaceName.get(), workspaceOwner.get(), shelvesetName, shelvesetOwner, itemSpecs, includeDownloadInfo, itemPropertyFilters);
    }

    public PendingSet[] queryShelvedChanges(String workspaceName, String workspaceOwner, String shelvesetName, String shelvesetOwner, ItemSpec[] itemSpecs, boolean includeDownloadInfo, String[] itemPropertyFilters) {
        AtomicReference<Failure[]> failures = new AtomicReference<Failure[]>();
        itemPropertyFilters = this.mergeWithDefaultItemPropertyFilters(itemPropertyFilters);
        PendingSet[] ret = this.getWebServiceLayer().queryShelvedChanges(workspaceName, workspaceOwner, shelvesetName, shelvesetOwner, itemSpecs, includeDownloadInfo, failures, itemPropertyFilters);
        this.reportFailures(failures.get());
        return ret;
    }

    public PolicyDefinition[] getCheckinPoliciesForServerPaths(String[] serverPaths) throws PolicySerializationException {
        if (serverPaths == null || serverPaths.length == 0) {
            return new PolicyDefinition[0];
        }
        for (int i = 0; i < serverPaths.length; ++i) {
            serverPaths[i] = ServerPath.canonicalize(serverPaths[i]);
            int depth = ServerPath.getFolderDepth(serverPaths[i]);
            if (depth == 0) {
                throw new VersionControlException(Messages.getString("VersionControlClient.CheckinPoliciesMayOnlyBeAssociatedWithTeamProjects"));
            }
            if (depth <= 1) continue;
            serverPaths[i] = ServerPath.getTeamProject(serverPaths[i]);
        }
        Annotation[] annotations = serverPaths.length == 1 ? this.queryAnnotation("TeampriseCheckinPolicies", serverPaths[0], 0) : this.queryAnnotation("TeampriseCheckinPolicies", null, 0);
        ArrayList<PolicyDefinition> definitions = new ArrayList<PolicyDefinition>();
        for (int i = 0; i < annotations.length; ++i) {
            for (int j = 0; j < serverPaths.length; ++j) {
                String thisServerPath = serverPaths[j];
                Annotation thisAnnotation = annotations[i];
                if (!ServerPath.equals(thisServerPath, thisAnnotation.getItem())) continue;
                PolicyAnnotation a = PolicyAnnotation.fromAnnotation(thisAnnotation.getValue());
                definitions.addAll(Arrays.asList(a.getDefinitions()));
            }
        }
        return definitions.toArray(new PolicyDefinition[definitions.size()]);
    }

    public MergeCandidate[] getMergeCandidates(String sourcePath, String targetPath, RecursionType recursion, MergeFlags mergeFlags) {
        Check.notNullOrEmpty(sourcePath, "sourcePath");
        Check.notNullOrEmpty(targetPath, "targetPath");
        Check.notNull(mergeFlags, "mergeFlags");
        AtomicReference<String> workspaceName = new AtomicReference<String>();
        AtomicReference<String> workspaceOwner = new AtomicReference<String>();
        this.determineWorkspaceNameAndOwner(new String[]{sourcePath, targetPath}, workspaceName, workspaceOwner);
        return this.getWebServiceLayer().queryMergeCandidates(workspaceName.get(), workspaceOwner.get(), new ItemSpec(sourcePath, recursion), new ItemSpec(targetPath, recursion), mergeFlags);
    }

    public BranchObject[] queryBranchObjects(ItemIdentifier rootItem, RecursionType recursion) {
        Check.notNull(rootItem, "rootItem");
        Check.notNull(recursion, "recursion");
        return this.getWebServiceLayer().queryBranchObjects(rootItem, recursion);
    }

    public void updateBranchObject(BranchProperties branchProperties, boolean updateExisting) {
        Check.notNull(branchProperties, "branchProperties");
        this.getWebServiceLayer().updateBranchObject(branchProperties, updateExisting);
        this.eventEngine.fireBranchObjectUpdated(new BranchObjectUpdatedEvent(EventSource.newFromHere(), branchProperties));
    }

    public void deleteBranchObject(ItemIdentifier branch) {
        Check.notNull(branch, "branch");
        this.getWebServiceLayer().deleteBranchObject(branch);
    }

    public ChangesetMerge[] queryMerges(String sourceItem, VersionSpec sourceVersion, String targetItem, VersionSpec targetVersion, VersionSpec versionFrom, VersionSpec versionTo, RecursionType recursion) {
        Check.notNull(targetItem, "targetItem");
        Check.notNull(targetVersion, "targetVersion");
        Check.notNull(recursion, "recursion");
        ArrayList<String> allPaths = new ArrayList<String>(2);
        ItemSpec sourceItemSpec = null;
        if (sourceItem != null) {
            sourceItemSpec = new ItemSpec(sourceItem, recursion);
            allPaths.add(sourceItem);
        }
        ItemSpec targetItemSpec = new ItemSpec(targetItem, recursion);
        allPaths.add(targetItem);
        AtomicReference<String> workspaceName = new AtomicReference<String>();
        AtomicReference<String> workspaceOwner = new AtomicReference<String>();
        this.determineWorkspaceNameAndOwner(allPaths.toArray(new String[allPaths.size()]), workspaceName, workspaceOwner);
        AtomicReference<Changeset[]> changesetsHolder = new AtomicReference<Changeset[]>();
        ChangesetMerge[] merges = this.getWebServiceLayer().queryMerges(workspaceName.get(), workspaceOwner.get(), sourceItemSpec, sourceVersion, targetItemSpec, targetVersion, versionFrom, versionTo, Integer.MAX_VALUE, true, changesetsHolder);
        if (merges != null) {
            int i;
            HashMap<Integer, Changeset> changesetIDToChangesetMap = new HashMap<Integer, Changeset>();
            Changeset[] changesets = changesetsHolder.get();
            if (changesets != null && changesets.length > 0) {
                for (i = 0; i < changesets.length; ++i) {
                    changesetIDToChangesetMap.put(new Integer(changesets[i].getChangesetID()), changesets[i]);
                }
            }
            for (i = 0; i < merges.length; ++i) {
                merges[i].setTargetChangeset((Changeset)changesetIDToChangesetMap.get(new Integer(merges[i].getTargetVersion())));
            }
        }
        return merges;
    }

    public ChangesetMergeDetails queryMergesWithDetails(String sourceItem, VersionSpec sourceVersion, int sourceDeletionID, String targetItem, VersionSpec targetVersion, int targetDeletionID, VersionSpec versionFrom, VersionSpec versionTo, RecursionType recursion) {
        Check.notNull(targetItem, "targetItem");
        Check.notNull(targetVersion, "targetVersion");
        Check.notNull(recursion, "recursion");
        ArrayList<String> allPaths = new ArrayList<String>(2);
        ItemSpec sourceItemSpec = null;
        if (sourceItem != null) {
            sourceItemSpec = new ItemSpec(sourceItem, recursion, sourceDeletionID);
            allPaths.add(sourceItem);
        }
        ItemSpec targetItemSpec = new ItemSpec(targetItem, recursion, targetDeletionID);
        allPaths.add(targetItem);
        AtomicReference<String> workspaceName = new AtomicReference<String>();
        AtomicReference<String> workspaceOwner = new AtomicReference<String>();
        this.determineWorkspaceNameAndOwner(allPaths.toArray(new String[allPaths.size()]), workspaceName, workspaceOwner);
        return this.getWebServiceLayer().queryMergesWithDetails(workspaceName.get(), workspaceOwner.get(), sourceItemSpec, sourceVersion, targetItemSpec, targetVersion, versionFrom, versionTo, Integer.MAX_VALUE, true);
    }

    public ExtendedMerge[] queryMergesExtended(ItemSpec targetItemSpec, VersionSpec targetVersionSpec, VersionSpec versionFrom, VersionSpec versionTo, QueryMergesExtendedOptions options) {
        Check.notNull(targetItemSpec, "targetItemSpec");
        Check.notNull(targetVersionSpec, "targetVersionSpec");
        Check.notNull(options, "options");
        AtomicReference<String> workspaceName = new AtomicReference<String>();
        AtomicReference<String> workspaceOwner = new AtomicReference<String>();
        this.determineWorkspaceNameAndOwner(targetItemSpec, workspaceName, workspaceOwner);
        return this.getWebServiceLayer().queryMergesExtended(workspaceName.get(), workspaceOwner.get(), targetItemSpec, targetVersionSpec, versionFrom, versionTo, options);
    }

    public ItemIdentifier[] queryMergeRelationships(String serverItem) {
        Check.notNullOrEmpty(serverItem, "serverItem");
        return this.getWebServiceLayer().queryMergeRelationships(serverItem);
    }

    public void setCheckinPolicies(String teamProjectPath, PolicyDefinition[] definitions) {
        Check.notNull(teamProjectPath, "teamProjectPath");
        if (definitions == null || definitions.length == 0) {
            log.info((Object)MessageFormat.format("Got null or empty definitions, so deleting all policies for {0}", teamProjectPath));
            this.deleteAnnotation("TeampriseCheckinPolicies", teamProjectPath, 0, null);
        } else {
            log.info((Object)MessageFormat.format("Writing {0} policy definitions to annotation for {1}", definitions.length, teamProjectPath));
            PolicyAnnotation annotation = new PolicyAnnotation(definitions);
            String value = annotation.toAnnotationValue();
            this.createAnnotation("TeampriseCheckinPolicies", teamProjectPath, 0, value, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SupportedFeatures getServerSupportedFeatures() {
        Object object = this.serverSupportedFeaturesLock;
        synchronized (object) {
            if (this.serverSupportedFeatures != null) {
                return this.serverSupportedFeatures;
            }
            this.serverSupportedFeatures = this.getWebServiceLayer().getSupportedFeatures();
            return this.serverSupportedFeatures;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSettings getServerSettingsWithFallback(AtomicBoolean fallbackUsed) {
        if (this.serverSettings == null) {
            Object object = this.serverSettingsLock;
            synchronized (object) {
                if (this.serverSettings == null) {
                    fallbackUsed.set(false);
                    this.serverSettings = this.getWebServiceLayer().getServerSettings();
                    if (this.serverSettings == null) {
                        fallbackUsed.set(true);
                        this.serverSettings = new ServerSettings(WorkspaceLocation.SERVER);
                    }
                }
            }
        }
        return this.serverSettings;
    }

    public int getMaxServerPathLength() {
        return this.getServerSettingsWithFallback(new AtomicBoolean()).getMaxAllowedServerPathLength();
    }

    public int getLatestChangesetID() {
        return this.getWebServiceLayer().getRepositoryProperties().getLatestChangesetID();
    }

    public Item[] destroy(ItemSpec itemSpec, VersionSpec versionSpec, VersionSpec stopAt, DestroyFlags flags) {
        return this.destroy(itemSpec, versionSpec, stopAt, flags, null, null);
    }

    public Item[] destroy(ItemSpec itemSpec, VersionSpec versionSpec, VersionSpec stopAt, DestroyFlags flags, List<PendingSet> affectedPendingChanges, List<PendingSet> affectedShelvedChanges) {
        Check.notNull(itemSpec, "itemSpec");
        Check.notNull(versionSpec, "versionSpec");
        if (flags == null) {
            flags = DestroyFlags.NONE;
        }
        if (!ServerPath.isServerPath(itemSpec.getItem())) {
            throw new IllegalArgumentException(Messages.getString("VersionControlClient.DestroyOperationRequiresServerPath"));
        }
        AtomicReference<Failure[]> failuresHolder = new AtomicReference<Failure[]>();
        AtomicReference<PendingSet[]> pendingChangesHolder = new AtomicReference<PendingSet[]>();
        AtomicReference<PendingSet[]> shelvedChangesHolder = new AtomicReference<PendingSet[]>();
        Item[] resultItems = this.getWebServiceLayer().destroy(itemSpec, versionSpec, stopAt, flags, failuresHolder, pendingChangesHolder, shelvedChangesHolder);
        if (resultItems == null) {
            resultItems = new Item[]{};
        }
        if (affectedPendingChanges != null && pendingChangesHolder.get() != null) {
            for (WebServiceObjectWrapper webServiceObjectWrapper : pendingChangesHolder.get()) {
                affectedPendingChanges.add((PendingSet)webServiceObjectWrapper);
            }
        }
        if (affectedShelvedChanges != null && shelvedChangesHolder.get() != null) {
            for (WebServiceObjectWrapper webServiceObjectWrapper : shelvedChangesHolder.get()) {
                affectedShelvedChanges.add((PendingSet)webServiceObjectWrapper);
            }
        }
        for (WebServiceObjectWrapper webServiceObjectWrapper : resultItems) {
            DestroyEvent event = new DestroyEvent(EventSource.newFromHere(), (Item)webServiceObjectWrapper, stopAt, flags);
            this.eventEngine.fireDestroyEvent(event);
        }
        Workstation.getCurrent(this.getConnection().getPersistenceStoreProvider()).notifyForFolderContentChanged(this);
        this.reportFailures(failuresHolder.get());
        return resultItems;
    }

    public void resolveLocalConflicts(Workspace workspace, Conflict[] conflicts, ResolveErrorOptions errorOptions) {
        GetOptions getOptions = GetOptions.GET_ALL;
        ArrayList resolveGroups = new ArrayList();
        resolveGroups.add(new ArrayList());
        for (Conflict conflict : conflicts) {
            if (conflict.getReason() == OperationStatus.SOURCE_WRITABLE.getValue() || conflict.getReason() == OperationStatus.TARGET_WRITABLE.getValue()) {
                if (Resolution.OVERWRITE_LOCAL.equals(conflict.getResolution())) {
                    if (conflict.getReason() == OperationStatus.SOURCE_WRITABLE.getValue() && null != conflict.getSourceLocalItem()) {
                        new File(conflict.getSourceLocalItem()).delete();
                    } else if (conflict.getReason() == OperationStatus.TARGET_WRITABLE.getValue() && null != conflict.getTargetLocalItem()) {
                        new File(conflict.getTargetLocalItem()).delete();
                    }
                    getOptions = getOptions.combine(GetOptions.OVERWRITE);
                } else {
                    String writablePath = conflict.getTargetLocalItem();
                    if (conflict.getReason() == OperationStatus.SOURCE_WRITABLE.getValue()) {
                        writablePath = conflict.getSourceLocalItem();
                    }
                    if (writablePath != null && new File(writablePath).exists() && !FileSystemUtils.getInstance().getAttributes(writablePath).isReadOnly()) {
                        return;
                    }
                }
            }
            ArrayList<Conflict> conflictGroup = (ArrayList<Conflict>)resolveGroups.get(resolveGroups.size() - 1);
            if (resolveGroups.size() >= 200) {
                conflictGroup = new ArrayList<Conflict>();
                resolveGroups.add(conflictGroup);
            }
            conflictGroup.add(conflict);
        }
        for (List list : resolveGroups) {
            ResolveLocalConflictHandler handler = new ResolveLocalConflictHandler(this, workspace);
            try {
                this.webServiceLayer.removeLocalConflicts(workspace.getName(), workspace.getOwnerName(), list, errorOptions, handler, handler);
            }
            catch (Exception e) {
                throw new VersionControlException(e);
            }
            if (handler.getGetRequests().size() <= 0) continue;
            workspace.get(handler.getGetRequests().toArray(new GetRequest[handler.getGetRequests().size()]), getOptions);
        }
    }

    public Conflict[] autoResolveValidConflicts(Workspace workspace, Conflict[] conflicts, AutoResolveOptions resolveOptions) {
        Check.notNull(workspace, "workspace");
        Check.notNull(conflicts, "conflicts");
        ArrayList<Conflict> unresolvedConflicts = new ArrayList<Conflict>();
        ArrayList<Conflict> conflictsToResolve = new ArrayList<Conflict>();
        for (Conflict conflict : conflicts) {
            try {
                if (conflict.isResolved()) continue;
                if (conflict.isBaseless()) {
                    unresolvedConflicts.add(conflict);
                    continue;
                }
                Resolution resolution = Resolution.NONE;
                if (resolveOptions.contains(AutoResolveOptions.REDUNDANT) && conflict.isRedundant(false, workspace)) {
                    resolution = Resolution.ACCEPT_THEIRS;
                } else {
                    if (!conflict.isValidForAutoMerge(workspace)) {
                        unresolvedConflicts.add(conflict);
                        continue;
                    }
                    resolution = Resolution.ACCEPT_MERGE;
                }
                if (Resolution.ACCEPT_MERGE.equals(resolution) && conflict.canMergeContent()) {
                    if (conflict.isBasicMergeAllowed(workspace) && !conflict.isEncodingMismatched()) {
                        conflict.resetChangeSummaryIfLocalFileModified();
                        if (conflict.getContentMergeSummary() == null || conflict.getMergedFileName() == null || conflict.getMergedFileName().length() == 0 || !new File(conflict.getMergedFileName()).exists()) {
                            MergeEngine mergeEngine = new MergeEngine(workspace, this);
                            mergeEngine.mergeContent(conflict, false, null, null, null);
                        }
                    }
                    if (conflict.getContentMergeSummary() == null || conflict.hasConflictingContentChange() || !conflict.isAutoMergeApplicable(resolveOptions)) {
                        unresolvedConflicts.add(conflict);
                        continue;
                    }
                }
                if (Resolution.ACCEPT_MERGE.equals(resolution) && conflict.isPropertyConflict()) {
                    conflict.mergeProperties(workspace);
                    if (conflict.hasConflictingPropertyChange()) {
                        unresolvedConflicts.add(conflict);
                        continue;
                    }
                    conflict.getResolutionOptions().setAcceptMergeProperties(conflict.getPropertiesMergeSummary().getMergedProperties());
                }
                if (conflict.isYourNameChanged() && conflict.isTheirNameChanged()) {
                    if (!conflict.isNameChangeIsRedundant()) {
                        unresolvedConflicts.add(conflict);
                        continue;
                    }
                    conflict.getResolutionOptions().setNewPath(conflict.getYourServerItem());
                }
                conflict.setResolution(resolution);
                conflict.setAutoResolved(true);
                conflictsToResolve.add(conflict);
            }
            catch (Exception e) {
                log.info((Object)"Caught exception while auto resolving conflicts", (Throwable)e);
                conflict.setResolution(Resolution.NONE);
                conflict.setAutoResolved(false);
                unresolvedConflicts.add(conflict);
            }
        }
        AtomicReference<Conflict[]> resolvedConflicts = new AtomicReference<Conflict[]>();
        ResolveErrorOptions errorOptions = resolveOptions.contains(AutoResolveOptions.SILENT) ? ResolveErrorOptions.NONE : ResolveErrorOptions.RAISE_WARNINGS_FOR_ERROR;
        workspace.resolveConflicts(conflictsToResolve.toArray(new Conflict[conflictsToResolve.size()]), null, errorOptions, resolvedConflicts);
        for (Conflict conflict : conflictsToResolve) {
            if (conflict.isResolved()) continue;
            conflict.setResolution(Resolution.NONE);
            conflict.setAutoResolved(false);
            unresolvedConflicts.add(conflict);
        }
        return unresolvedConflicts.toArray(new Conflict[unresolvedConflicts.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveConflicts(Workspace workspace, Conflict[] conflicts, String[] itemPropertyFilters, ResolveErrorOptions errorOptions, AtomicReference<Conflict[]> resolvedConflicts) {
        itemPropertyFilters = this.mergeWithDefaultItemPropertyFilters(itemPropertyFilters);
        resolvedConflicts.set(new Conflict[0]);
        ArrayList<Conflict> allResolvedConflicts = new ArrayList<Conflict>();
        ChangePendedFlags flags = ChangePendedFlags.UNKNOWN;
        ArrayList<Conflict> localConflicts = new ArrayList<Conflict>();
        ArrayList conflictResolveGroups = new ArrayList();
        conflictResolveGroups.add(new ArrayList());
        for (Conflict conflict : conflicts) {
            try {
                if (Resolution.NONE.equals(conflict.getResolution())) continue;
                if (ConflictType.LOCAL.equals(conflict.getType()) && !Resolution.DELETE_CONFLICT.equals(conflict.getResolution())) {
                    localConflicts.add(conflict);
                    continue;
                }
                ArrayList<Conflict> conflictGroup = (ArrayList<Conflict>)conflictResolveGroups.get(conflictResolveGroups.size() - 1);
                if (ItemType.FOLDER.equals(conflict.getYourItemType()) || ItemType.FOLDER.equals(conflict.getTheirItemType()) || ItemType.FOLDER.equals(conflict.getBaseItemType())) {
                    conflictGroup = new ArrayList<Conflict>();
                    conflictResolveGroups.add(conflictGroup);
                    conflictResolveGroups.add(new ArrayList());
                } else if (conflictGroup.size() >= 200) {
                    conflictGroup = new ArrayList();
                    conflictResolveGroups.add(conflictGroup);
                }
                conflictGroup.add(conflict);
            }
            catch (RuntimeException e) {
                if (ResolveErrorOptions.THROW_ON_ERROR.equals(errorOptions)) {
                    throw e;
                }
                if (!ResolveErrorOptions.RAISE_WARNINGS_FOR_ERROR.equals(errorOptions)) continue;
                this.eventEngine.fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this, (Throwable)e));
            }
        }
        if (localConflicts.size() != 0) {
            this.resolveLocalConflicts(workspace, localConflicts.toArray(new Conflict[localConflicts.size()]), errorOptions);
        }
        for (List list : conflictResolveGroups) {
            if (list.size() == 0) continue;
            WorkspaceLock lock = workspace.lock();
            try {
                HashMap<Integer, String> updatedSourceLocalItems = new HashMap<Integer, String>();
                for (Conflict conflict : list) {
                    String updatedSourceLocalItem = null;
                    if (Resolution.ACCEPT_MERGE.equals(conflict.getResolution()) && conflict.canMergeContent() && conflict.getMergedFileName() != null && conflict.getMergedFileName().length() > 0) {
                        if (conflict.getSourceLocalItem() != null) {
                            new File(conflict.getSourceLocalItem()).delete();
                            try {
                                FileHelpers.rename(conflict.getMergedFileName(), conflict.getSourceLocalItem());
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            updatedSourceLocalItem = conflict.getSourceLocalItem();
                        } else {
                            Check.isTrue(conflict.getMergedFileName().toLowerCase().contains("temp"), "conflict.getMergedFileName().toLowerCase().contains(\"temp\")");
                            updatedSourceLocalItem = conflict.getMergedFileName();
                        }
                    }
                    if (null == updatedSourceLocalItem) continue;
                    workspace.getWorkspaceWatcher().addSkippedItem(updatedSourceLocalItem);
                    updatedSourceLocalItems.put(conflict.getConflictID(), updatedSourceLocalItem);
                }
                ResolveConflictHandler handler = new ResolveConflictHandler(this, workspace, updatedSourceLocalItems);
                try {
                    this.webServiceLayer.resolve(workspace.getName(), workspace.getOwnerName(), conflicts, null, itemPropertyFilters, errorOptions, handler, handler);
                }
                catch (Exception e) {
                    for (Conflict conflict : conflicts) {
                        String updatedSourceLocalItem = (String)updatedSourceLocalItems.get(conflict.getConflictID());
                        if (updatedSourceLocalItem == null) continue;
                        workspace.getWorkspaceWatcher().removeSkippedItem(updatedSourceLocalItem);
                        conflict.setSourceLocalItem(updatedSourceLocalItem);
                    }
                    throw new VersionControlException(e);
                }
                UpdateLocalVersionQueue ulvq = new UpdateLocalVersionQueue(workspace);
                try {
                    for (ResolveConflictHandler.UpdateLocalVersionSpec ulvSpec : handler.getUpdateLocalVersionSpecs()) {
                        ulvq.queueUpdate(ulvSpec.getSourceServerItem(), ulvSpec.getItemID(), ulvSpec.getSourceLocalItem(), ulvSpec.getVersionServer(), ulvSpec.getProperyValues());
                    }
                }
                finally {
                    ulvq.close();
                }
                GetEngine getEngine = new GetEngine(this);
                for (ResolveConflictHandler.GetOperationGroup group : handler.getGetOpGroups()) {
                    getEngine.processGetOperations(workspace, ProcessType.UNDO, group.getUndoOps(), GetOptions.NONE, handler.getFlags());
                    getEngine.processGetOperations(workspace, ProcessType.GET, group.getGetOps(), GetOptions.NONE, handler.getFlags());
                }
                allResolvedConflicts.addAll(handler.getResolvedConflicts());
                flags = flags.combine(handler.getFlags());
            }
            finally {
                if (lock == null) continue;
                lock.close();
            }
        }
        resolvedConflicts.set(allResolvedConflicts.toArray(new Conflict[allResolvedConflicts.size()]));
        if (flags.contains(ChangePendedFlags.WORKING_FOLDER_MAPPINGS_UPDATED)) {
            workspace.invalidateMappings();
        }
    }

    public void updateUserName() {
        this.getWebServiceLayer().refreshIdentityDisplayName();
    }

    public void determineWorkspaceNameAndOwner(ItemSpec itemSpec, AtomicReference<String> workspaceName, AtomicReference<String> workspaceOwner) {
        if (itemSpec == null) {
            workspaceName.set(null);
            workspaceOwner.set(null);
        } else {
            this.determineWorkspaceNameAndOwner(new ItemSpec[]{itemSpec}, workspaceName, workspaceOwner);
        }
    }

    public void determineWorkspaceNameAndOwner(String path, AtomicReference<String> workspaceName, AtomicReference<String> workspaceOwner) {
        if (path == null || path.length() == 0) {
            workspaceName.set(null);
            workspaceOwner.set(null);
        } else {
            this.determineWorkspaceNameAndOwner(new ItemSpec(path, RecursionType.NONE), workspaceName, workspaceOwner);
        }
    }

    public void determineWorkspaceNameAndOwner(LabelItemSpec[] labelItemSpecs, AtomicReference<String> workspaceName, AtomicReference<String> workspaceOwner) {
        if (labelItemSpecs == null) {
            workspaceName.set(null);
            workspaceOwner.set(null);
        } else {
            ItemSpec[] itemSpecs = new ItemSpec[labelItemSpecs.length];
            for (int i = 0; i < itemSpecs.length; ++i) {
                itemSpecs[i] = labelItemSpecs[i].getItemSpec();
            }
            this.determineWorkspaceNameAndOwner(itemSpecs, workspaceName, workspaceOwner);
        }
    }

    public void determineWorkspaceNameAndOwner(SecurityChange[] securityChanges, AtomicReference<String> workspaceName, AtomicReference<String> workspaceOwner) {
        if (securityChanges == null) {
            workspaceName.set(null);
            workspaceOwner.set(null);
        } else {
            ItemSpec[] itemSpecs = new ItemSpec[securityChanges.length];
            for (int i = 0; i < itemSpecs.length; ++i) {
                itemSpecs[i] = new ItemSpec(securityChanges[i].getItem(), RecursionType.NONE);
            }
            this.determineWorkspaceNameAndOwner(itemSpecs, workspaceName, workspaceOwner);
        }
    }

    public void determineWorkspaceNameAndOwner(String[] paths, AtomicReference<String> workspaceName, AtomicReference<String> workspaceOwner) {
        if (paths == null) {
            workspaceName.set(null);
            workspaceOwner.set(null);
        } else {
            this.determineWorkspaceNameAndOwner(ItemSpec.fromStrings(paths, RecursionType.NONE), workspaceName, workspaceOwner);
        }
    }

    public void determineWorkspaceNameAndOwner(ItemSpec[] itemSpecs, AtomicReference<String> workspaceName, AtomicReference<String> workspaceOwner) {
        if (itemSpecs == null) {
            workspaceName.set(null);
            workspaceOwner.set(null);
        } else {
            Workspace workspace = null;
            for (int i = 0; i < itemSpecs.length; ++i) {
                ItemSpec spec = itemSpecs[i];
                if (ServerPath.isServerPath(spec.getItem())) continue;
                Workspace itemWorkspace = this.getWorkspace(spec.getItem());
                if (workspace == null) {
                    workspace = itemWorkspace;
                    continue;
                }
                if (workspace.equals(itemWorkspace)) continue;
                throw new OnlyOneWorkspaceException(itemWorkspace, spec.getItem());
            }
            if (workspace == null) {
                workspaceName.set(null);
                workspaceOwner.set(null);
            } else {
                workspaceName.set(workspace.getName());
                workspaceOwner.set(workspace.getOwnerName());
            }
        }
    }

    public String resolveUserUniqueName(String user) {
        if (".".equals(user)) {
            user = this.getConnection().getAuthorizedIdentity().getUniqueName();
        }
        return user;
    }

    public String resolveUserDisplayName(String user) {
        if (".".equals(user)) {
            user = this.getConnection().getAuthorizedIdentity().getDisplayName();
        }
        return user;
    }

    public boolean isAuthorizedUser(String name) {
        if (".".equals(name)) {
            return true;
        }
        return IdentityHelper.identityHasName(this.getConnection().getAuthorizedIdentity(), name);
    }

    public WorkspaceInfo removeCachedWorkspace(String workspaceName, String workspaceOwner) {
        workspaceOwner = this.resolveUserUniqueName(workspaceOwner);
        WorkspaceInfo workspaceInfo = Workstation.getCurrent(this.getConnection().getPersistenceStoreProvider()).getLocalWorkspaceInfo(this.getServerGUID(), workspaceName, workspaceOwner);
        if (workspaceInfo != null) {
            Workstation.getCurrent(this.getConnection().getPersistenceStoreProvider()).getCache().removeWorkspace(workspaceInfo);
        }
        return workspaceInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileType queryCachedFileType(String extension) {
        Object object = this.cachedFileTypesLock;
        synchronized (object) {
            if (this.cachedFileTypes == null) {
                FileType[] serverFileTypes;
                this.cachedFileTypes = new TreeMap<String, FileType>(String.CASE_INSENSITIVE_ORDER);
                for (FileType serverFileType : serverFileTypes = this.getFileTypes()) {
                    for (String fileTypeExtension : serverFileType.getExtensions()) {
                        this.cachedFileTypes.put(fileTypeExtension, serverFileType);
                    }
                }
            }
            return this.cachedFileTypes.get(extension);
        }
    }

    public FileType[] getFileTypes() {
        return this.webServiceLayer.queryFileTypes();
    }

    public String[] mergeWithDefaultItemPropertyFilters(String[] filters) {
        return PropertyUtils.mergePropertyFilters(this.getDefaultItemPropertyFilters(), filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityNamespace getWorkspaceSecurity() {
        if (this.workspaceSecurity == null) {
            Object object = this.workspaceSecurityLock;
            synchronized (object) {
                if (this.workspaceSecurity == null) {
                    try {
                        SecurityService securityService = new SecurityService(this.connection);
                        if (securityService != null) {
                            this.workspaceSecurity = securityService.getSecurityNamespace(WORKSPACE_SECURITY_NAMESPACE_ID);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return this.workspaceSecurity;
    }
}

