/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.conflicts;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ConflictCategory;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ConflictDescriptionPathType;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolution;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolutionOptions;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.contributors.ConflictResolutionContributor;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Conflict;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import java.util.ArrayList;
import java.util.Collection;

public abstract class ConflictDescription {
    private final Workspace workspace;
    private final Conflict conflict;
    private final ItemSpec[] conflictItemSpecs;

    protected ConflictDescription(Workspace workspace, Conflict conflict, ItemSpec[] conflictItemSpecs) {
        this.workspace = workspace;
        this.conflict = conflict;
        this.conflictItemSpecs = conflictItemSpecs;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public Conflict getConflict() {
        return this.conflict;
    }

    public ItemSpec[] getConflictItemSpecs() {
        return this.conflictItemSpecs;
    }

    public abstract ConflictCategory getConflictCategory();

    public String getLocalPath() {
        if (this.conflict.getTargetLocalItem() != null) {
            return this.conflict.getTargetLocalItem();
        }
        if (this.conflict.getSourceLocalItem() != null) {
            return this.conflict.getSourceLocalItem();
        }
        return null;
    }

    public String getLocalPath(ConflictDescriptionPathType pathType) {
        String[] pathOrder = ConflictDescriptionPathType.SOURCE == pathType ? new String[]{this.conflict.getSourceLocalItem(), this.conflict.getTargetLocalItem()} : new String[]{this.conflict.getTargetLocalItem(), this.conflict.getSourceLocalItem()};
        for (int i = 0; i < pathOrder.length; ++i) {
            if (pathOrder[i] == null) continue;
            return pathOrder[i];
        }
        return null;
    }

    public String getServerPath() {
        if (this.conflict.getYourServerItem() != null) {
            return this.conflict.getYourServerItem();
        }
        if (this.conflict.getBaseServerItem() != null) {
            return this.conflict.getBaseServerItem();
        }
        if (this.conflict.getTheirServerItem() != null) {
            return this.conflict.getTheirServerItem();
        }
        return null;
    }

    public String getLocalFileDescription() {
        return Messages.getString("ConflictDescription.LocalFileDescription");
    }

    public String getRemoteFileDescription() {
        return Messages.getString("ConflictDescription.ServerFileDescription");
    }

    public boolean isBaseless() {
        return this.conflict.isBaseless();
    }

    public abstract String getName();

    public abstract String getDescription();

    public boolean showChangeDescription() {
        return false;
    }

    public String getChangeDescription() {
        return Messages.getString("ConflictDescription.ChangeDescription");
    }

    public boolean analyzeConflict() {
        return false;
    }

    public boolean hasAnalyzed() {
        return false;
    }

    public void clearAnalysis() {
    }

    public abstract ConflictResolution[] getResolutions(ConflictResolutionContributor var1);

    public boolean isResolutionEnabled(ConflictResolution resolution) {
        return true;
    }

    protected final Collection<ConflictResolution> loadContributedResolutions(ConflictResolutionContributor resolutionContributor, ConflictResolutionOptions resolutionOptions) {
        Collection<ConflictResolution> contributions = resolutionContributor.getConflictResolutions(this, resolutionOptions);
        if (contributions != null) {
            return contributions;
        }
        return new ArrayList<ConflictResolution>();
    }
}

