/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ConflictDescription;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolutionOptions;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolutionStatus;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolutionStatusListener;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Conflict;
import com.microsoft.tfs.core.util.FileEncoding;
import com.microsoft.tfs.util.Check;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ConflictResolution {
    private static final Log log = LogFactory.getLog(ConflictResolution.class);
    private final ConflictDescription conflictDescription;
    private final String description;
    private final String helpText;
    private final ConflictResolutionOptions options;
    private ConflictResolutionStatus status = ConflictResolutionStatus.NOT_STARTED;
    private String errorMessage = null;
    private final Object errorMessageLock = new Object();
    private final List<ConflictResolutionStatusListener> listeners = new ArrayList<ConflictResolutionStatusListener>();
    public static final String DefaultErrorMessage = Messages.getString("ConflictResolution.ConflictingContentChanges");

    protected ConflictResolution(ConflictDescription conflictDescription, String description, String helpText, ConflictResolutionOptions options) {
        Check.notNull(conflictDescription, "conflictDescription");
        Check.notNull(description, "description");
        Check.notNull(options, "options");
        this.conflictDescription = conflictDescription;
        this.description = description;
        this.helpText = helpText;
        this.options = options;
    }

    public final ConflictResolutionStatus resolveConflict() {
        ConflictResolutionStatus workStatus;
        Check.notNull(this.conflictDescription.getConflict(), "conflictDescription.getConflict()");
        Check.notNull(this.conflictDescription.getWorkspace(), "conflictDescription.getWorkspace()");
        try {
            workStatus = this.work();
        }
        catch (Exception e) {
            log.warn((Object)"Could not resolve conflict", (Throwable)e);
            workStatus = ConflictResolutionStatus.FAILED;
            this.errorMessage = e.getMessage();
        }
        this.setStatus(workStatus);
        return workStatus;
    }

    protected abstract ConflictResolutionStatus work() throws Exception;

    public abstract ConflictResolution newForConflictDescription(ConflictDescription var1);

    public void cancel() {
    }

    protected final synchronized void setStatus(ConflictResolutionStatus status) {
        this.status = status;
        ArrayList<ConflictResolutionStatusListener> listeners = new ArrayList<ConflictResolutionStatusListener>(this.listeners);
        for (ConflictResolutionStatusListener listener : listeners) {
            listener.statusChanged(this, status);
        }
    }

    public Conflict[] getConflicts() {
        return null;
    }

    public ConflictDescription getConflictDescription() {
        return this.conflictDescription;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public boolean needsNewPath() {
        return this.options.contains(ConflictResolutionOptions.SELECT_NAME);
    }

    public abstract void setNewPath(String var1);

    public boolean needsEncodingSelection() {
        return this.options.contains(ConflictResolutionOptions.SELECT_ENCODING);
    }

    public abstract void setEncoding(FileEncoding var1);

    public final synchronized ConflictResolutionStatus getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setErrorMessage(String message) {
        Object object = this.errorMessageLock;
        synchronized (object) {
            this.errorMessage = message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getErrorMessage() {
        Object object = this.errorMessageLock;
        synchronized (object) {
            if (this.errorMessage == null) {
                return DefaultErrorMessage;
            }
            return this.errorMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusListener(ConflictResolutionStatusListener listener) {
        List<ConflictResolutionStatusListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatusListener(ConflictResolutionStatusListener listener) {
        List<ConflictResolutionStatusListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }
}

