/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.engines.internal;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.BaseDownloadOutput;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BaselineFolderCollection;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.BaselineFolder;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.IOUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BaselineFileDownloadOutput
extends BaseDownloadOutput {
    private static final Log log = LogFactory.getLog(BaselineFileDownloadOutput.class);
    private final File baselineFileNoSuffix;
    private FileOutputStream outputStream;
    private File outputStreamFile;
    private boolean tempFileCreatedInsteadOfBaseline;

    public BaselineFileDownloadOutput(File baselineFileNoSuffix, boolean autoGunzip) {
        super(autoGunzip);
        Check.notNull(baselineFileNoSuffix, "baselineFileNoSuffix");
        this.baselineFileNoSuffix = baselineFileNoSuffix;
    }

    @Override
    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            String contentType = this.getActualContentType();
            Check.notNull(contentType, "Cannot open output stream until actual content type is set");
            String path = this.baselineFileNoSuffix.getAbsolutePath();
            if (contentType.equals("application/gzip")) {
                path = path + BaselineFolder.getGzipExtension();
            } else if (contentType.equals("application/octet-stream")) {
                path = path + BaselineFolder.getRawExtension();
            } else {
                throw new VersionControlException(MessageFormat.format(Messages.getString("VersionControlClient.UnsupportedContentTypeFormat"), contentType));
            }
            AtomicBoolean tempCreated = new AtomicBoolean();
            AtomicReference<String> pathReference = new AtomicReference<String>(path);
            this.outputStream = BaselineFolderCollection.createFile(pathReference, true, null, tempCreated);
            path = pathReference.get();
            this.outputStreamFile = new File(path);
            this.tempFileCreatedInsteadOfBaseline = tempCreated.get();
        }
        return this.outputStream;
    }

    @Override
    public synchronized void resetOutputStream() throws IOException {
        File file = this.outputStreamFile;
        this.closeOutputStream();
        if (file != null && !file.delete()) {
            log.warn((Object)MessageFormat.format("Couldn''t delete baseline output file {0} during stream reset", this.outputStreamFile));
        }
    }

    @Override
    public void closeOutputStream() throws IOException {
        if (this.outputStream != null) {
            IOUtils.closeSafely(this.outputStream);
            this.outputStreamFile = null;
            this.outputStream = null;
            this.tempFileCreatedInsteadOfBaseline = false;
        }
    }

    public File getOutputStreamFile() {
        return this.outputStreamFile;
    }

    public synchronized boolean isTempFileCreatedInsteadOfBaseline() {
        return this.tempFileCreatedInsteadOfBaseline;
    }
}

