/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.events;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.CoreClientEvent;
import com.microsoft.tfs.core.clients.versioncontrol.OperationStatus;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.AsyncGetOperation;
import com.microsoft.tfs.core.clients.versioncontrol.events.EventSource;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetOperation;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicReference;

public class GetEvent
extends CoreClientEvent {
    private static final String GET_CONFLICT = Messages.getString("GetEvent.GetConflictFormat");
    private static final String GET_CONFLICT_MOVE = Messages.getString("GetEvent.GetConflictMoveFormat");
    private static final String GET_NAMESPACE_CONFLICT = Messages.getString("GetEvent.GetNamespaceConflictFormat");
    private static final String GET_NAMESPACE_CONFLICT_MOVE = Messages.getString("GetEvent.GetNamespaceConflictMoveFormat");
    private static final String GET_SOURCE_WRITABLE_NEW_TARGET = Messages.getString("GetEvent.GetSourceWritableNewTargetFormat");
    private static final String GET_WRITABLE = Messages.getString("GetEvent.GetWritableFormat");
    private static final String GET_LOCAL_PENDING_MOVE = Messages.getString("GetEvent.GetLocalPendingMoveFormat");
    private static final String GET_LOCAL_PENDING = Messages.getString("GetEvent.GetLocalPendingFormat");
    private static final String GET_GETTING_MOVE = Messages.getString("GetEvent.GetGettingMoveFormat");
    private static final String GET_GETTING = Messages.getString("GetEvent.GetGettingFormat");
    private static final String GET_REPLACING_MOVE = Messages.getString("GetEvent.GetReplacingMoveFormat");
    private static final String GET_REPLACING = Messages.getString("GetEvent.GetReplacingFormat");
    private static final String GET_DELETING = Messages.getString("GetEvent.GetDeletingFormat");
    private static final String CANT_DELETE_NON_EMPTY_DIR_PATH = Messages.getString("GetEvent.GetDeleteNonEmptyDirPathFormat");
    private static final String GET_TARGET_IS_DIR = Messages.getString("GetEvent.GetTargetIsDirFormat");
    private static final String GET_UNABLE_TO_REFRESH = Messages.getString("GetEvent.GetUnableToRefreshFormat");
    static final long serialVersionUID = 845047770683850528L;
    private final Workspace workspace;
    private final OperationStatus status;
    private final GetOperation action;
    private final String targetLocalItem;
    private final ChangeType targetPendingChangeType;
    private final PropertyValue[] targetPropertyValues;
    private final boolean diskUpdateAttempted;

    public GetEvent(EventSource source, AsyncGetOperation asyncOp, OperationStatus status, GetOperation action, String targetLocalItem, ChangeType targetChangeType, PropertyValue[] targetPropertyValues) {
        super(source);
        Check.notNull(asyncOp, "asyncOp");
        this.workspace = asyncOp.getWorkspace();
        this.status = status;
        this.action = action;
        this.targetLocalItem = targetLocalItem;
        this.targetPendingChangeType = targetChangeType;
        this.diskUpdateAttempted = !asyncOp.isPreview();
        this.targetPropertyValues = action.getPropertyValues();
    }

    public String getMessage(String targetName, AtomicReference<String> error) {
        String sourceName;
        GetOperation getOp = this.getOperation();
        String actionString = getOp.isDelete() ? Messages.getString("GetEvent.DeleteOperation") : Messages.getString("GetEvent.GetOperation");
        if (targetName == null) {
            targetName = this.getServerItem();
        }
        if ((sourceName = this.getSourceLocalItem()) == null) {
            sourceName = this.getServerItem();
        }
        error.set(null);
        String message = null;
        OperationStatus opStatus = this.getStatus();
        if (OperationStatus.CONFLICT == opStatus) {
            if (this.getTargetLocalItem() == null) {
                error.set(MessageFormat.format(Messages.getString("GetEvent.CannotDoOpDueToConflictFormat"), sourceName, actionString, this.getSourcePendingChangeTypeName()));
            } else if (!this.action.isNamespaceConflict()) {
                if (this.getSourceLocalItem() == null || LocalPath.equals(this.getSourceLocalItem(), this.getTargetLocalItem())) {
                    error.set(MessageFormat.format(GET_CONFLICT, targetName, actionString, this.getSourcePendingChangeTypeName()));
                } else {
                    error.set(MessageFormat.format(GET_CONFLICT_MOVE, targetName, actionString, this.getSourcePendingChangeTypeName(), sourceName));
                }
            } else if (this.getSourceLocalItem() == null) {
                error.set(MessageFormat.format(GET_NAMESPACE_CONFLICT, targetName, actionString, this.getSourcePendingChangeTypeName()));
            } else {
                error.set(MessageFormat.format(GET_NAMESPACE_CONFLICT_MOVE, targetName, actionString, this.getSourcePendingChangeTypeName(), sourceName));
            }
        } else if (OperationStatus.SOURCE_WRITABLE == opStatus) {
            if (this.isDelete() || this.getSourceLocalItem() == null || LocalPath.equals(this.getSourceLocalItem(), this.getTargetLocalItem())) {
                String path = targetName;
                if (this.isDelete()) {
                    path = sourceName;
                }
                error.set(MessageFormat.format(GET_WRITABLE, path, actionString));
            } else {
                error.set(MessageFormat.format(GET_SOURCE_WRITABLE_NEW_TARGET, targetName, actionString, sourceName));
            }
        } else if (OperationStatus.TARGET_LOCAL_PENDING == opStatus) {
            if (this.getSourceLocalItem() == null) {
                error.set(MessageFormat.format(GET_LOCAL_PENDING, targetName, actionString, this.getTargetPendingChangeTypeName()));
            } else {
                error.set(MessageFormat.format(GET_LOCAL_PENDING_MOVE, targetName, actionString, this.getTargetPendingChangeTypeName(), sourceName));
            }
        } else if (OperationStatus.TARGET_WRITABLE == opStatus) {
            error.set(MessageFormat.format(GET_WRITABLE, targetName, actionString));
        } else if (OperationStatus.GETTING == opStatus) {
            message = this.getSourceLocalItem() == null || LocalPath.equals(this.getSourceLocalItem(), this.getTargetLocalItem()) ? MessageFormat.format(GET_GETTING, targetName) : MessageFormat.format(GET_GETTING_MOVE, targetName, sourceName);
        } else if (OperationStatus.REPLACING == opStatus) {
            message = this.getSourceLocalItem() == null || LocalPath.equals(this.getSourceLocalItem(), this.getTargetLocalItem()) ? MessageFormat.format(GET_REPLACING, targetName) : MessageFormat.format(GET_REPLACING_MOVE, targetName, sourceName);
        } else if (OperationStatus.DELETING == opStatus) {
            message = MessageFormat.format(GET_DELETING, sourceName);
        } else if (OperationStatus.SOURCE_DIRECTORY_NOT_EMPTY == opStatus) {
            error.set(MessageFormat.format(CANT_DELETE_NON_EMPTY_DIR_PATH, sourceName));
        } else if (OperationStatus.TARGET_IS_DIRECTORY == opStatus) {
            error.set(MessageFormat.format(GET_TARGET_IS_DIR, targetName));
        } else if (OperationStatus.UNABLE_TO_REFRESH == opStatus) {
            error.set(MessageFormat.format(GET_UNABLE_TO_REFRESH, targetName));
        }
        return message;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public OperationStatus getStatus() {
        return this.status;
    }

    public boolean isLatest() {
        return this.action.isLatest();
    }

    public String getSourceLocalItem() {
        return this.action.getSourceLocalItem();
    }

    public String getTargetLocalItem() {
        return this.targetLocalItem;
    }

    public int getVersion() {
        return this.action.getVersionServer();
    }

    public int getDeletionID() {
        return this.action.getDeletionID();
    }

    public String getServerItem() {
        return this.action.getTargetServerItem();
    }

    public int getItemID() {
        return this.action.getItemID();
    }

    public ItemType getItemType() {
        return this.action.getItemType();
    }

    public boolean isDelete() {
        return this.action.isDelete();
    }

    public ChangeType getChangeType() {
        return this.action.getChangeType();
    }

    public boolean isDiskUpdateAttempted() {
        return this.diskUpdateAttempted;
    }

    public GetOperation getOperation() {
        return this.action;
    }

    public PropertyValue[] getTargetPropertyValues() {
        return this.targetPropertyValues;
    }

    private String getSourcePendingChangeTypeName() {
        if (!this.action.hasConflict()) {
            return this.action.getChangeType().toUIString(true, this.action.getPropertyValues());
        }
        return this.action.getConflictingChangeType().toUIString(true, this.action.getPropertyValues());
    }

    private String getTargetPendingChangeTypeName() {
        Check.isTrue(this.status == OperationStatus.TARGET_LOCAL_PENDING, "status == OperationStatus.TARGET_LOCAL_PENDING");
        if (this.targetPendingChangeType == null) {
            return ChangeType.NONE.toUIString(true, this.targetPropertyValues);
        }
        return this.targetPendingChangeType.toUIString(true, this.targetPropertyValues);
    }
}

