/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AccountingCompletionService<V>
extends ExecutorCompletionService<V> {
    private static final Log log = LogFactory.getLog(AccountingCompletionService.class);
    private long unwaitedSubmissions = 0L;
    private final Object unwaitedSubmissionsLock = new Object();

    public AccountingCompletionService(Executor executor, BlockingQueue<Future<V>> completionQueue) {
        super(executor, completionQueue);
    }

    public AccountingCompletionService(Executor executor) {
        super(executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<V> submit(Callable<V> task) {
        Object object = this.unwaitedSubmissionsLock;
        synchronized (object) {
            Future<V> ret = super.submit(task);
            ++this.unwaitedSubmissions;
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<V> submit(Runnable task, V result) {
        Object object = this.unwaitedSubmissionsLock;
        synchronized (object) {
            Future<V> ret = super.submit(task, result);
            ++this.unwaitedSubmissions;
            return ret;
        }
    }

    @Override
    public Future<V> take() throws InterruptedException {
        throw new IllegalStateException();
    }

    @Override
    public Future<V> poll() {
        throw new IllegalStateException();
    }

    @Override
    public Future<V> poll(long timeout, TimeUnit unit) throws InterruptedException {
        throw new IllegalStateException();
    }

    public void waitForCompletions() {
        this.waitForCompletions(null);
    }

    public void waitForCompletions(ResultProcessor<V> resultProcessor) {
        this.waitForCompletions(resultProcessor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompletions(ResultProcessor<V> resultProcessor, ExecutionExceptionHandler exceptionHandler) {
        long submittedCountCopy;
        Object object = this.unwaitedSubmissionsLock;
        synchronized (object) {
            submittedCountCopy = this.unwaitedSubmissions;
            this.unwaitedSubmissions = 0L;
        }
        try {
            int i = 0;
            while ((long)i < submittedCountCopy) {
                block9: {
                    Future f = super.take();
                    try {
                        if (resultProcessor != null) {
                            resultProcessor.processResult(f.get());
                        }
                    }
                    catch (ExecutionException e) {
                        log.debug((Object)"Execution exception", (Throwable)e);
                        if (exceptionHandler == null) break block9;
                        exceptionHandler.handleException(e);
                    }
                }
                ++i;
            }
        }
        catch (InterruptedException e) {
            log.debug((Object)"Interrupted waiting for completion service take", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public static interface ExecutionExceptionHandler {
        public void handleException(ExecutionException var1);
    }

    public static interface ResultProcessor<V> {
        public void processResult(V var1);
    }
}

