/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.httpclient;

import com.microsoft.tfs.core.clients.versioncontrol.internal.httpclient.CancellableFilePart;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.tasks.TaskMonitor;
import com.microsoft.tfs.util.tasks.TaskMonitorService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CancellableChunkPart
extends CancellableFilePart {
    private static final Log logger = LogFactory.getLog(CancellableChunkPart.class);
    final InputStream stream;
    final long chunkSize;

    public CancellableChunkPart(File file, InputStream stream, String contentType, long chunkSize) throws FileNotFoundException {
        super("content", "item", file, contentType, null);
        this.setCharSet(null);
        Check.isTrue(stream.markSupported(), "The stream does not support retry.");
        this.stream = stream;
        this.chunkSize = chunkSize;
    }

    @Override
    protected void sendData(OutputStream out) throws IOException {
        int len;
        TaskMonitor monitor = TaskMonitorService.getTaskMonitor();
        byte[] tmp = new byte[BUFFER_SIZE];
        this.stream.reset();
        monitor.begin("", 0);
        long dataLeft = this.chunkSize;
        while ((len = this.stream.read(tmp, 0, (int)Math.min((long)BUFFER_SIZE, Math.max(dataLeft, 0L)))) > 0) {
            if (monitor.isCanceled()) {
                throw new CancellableFilePart.SendDataCancellationException();
            }
            out.write(tmp, 0, len);
            dataLeft -= (long)len;
            monitor.worked(len);
        }
        monitor.done();
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    protected long lengthOfData() throws IOException {
        logger.trace((Object)"enter lengthOfData()");
        return this.chunkSize;
    }
}

