/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace;

import com.microsoft.tfs.jni.FileSystemAttributes;
import com.microsoft.tfs.jni.FileSystemUtils;
import java.io.File;

public class EnumeratedLocalItem {
    private final String name;
    private final String path;
    private final FileSystemAttributes attrs;
    private String serverItem;

    public EnumeratedLocalItem(File file, FileSystemAttributes attrs) {
        this.name = file.getName();
        this.path = file.getPath();
        this.attrs = attrs;
    }

    public EnumeratedLocalItem(File file) {
        this(file, FileSystemUtils.getInstance().getAttributes(file));
    }

    public String getFileName() {
        return this.name;
    }

    public String getFullPath() {
        return this.path;
    }

    public long getFileSize() {
        if (this.attrs.isSymbolicLink()) {
            return 0L;
        }
        return this.attrs.getSize();
    }

    public long getLastWriteTime() {
        if (!this.attrs.exists() || this.attrs.getModificationTime() == null) {
            return -1L;
        }
        return this.attrs.getModificationTime().getWindowsFilesystemTime();
    }

    public boolean isDirectory() {
        if (this.attrs.isSymbolicLink()) {
            return false;
        }
        return this.attrs.isDirectory();
    }

    public boolean isSymbolicLink() {
        return this.attrs.isSymbolicLink();
    }

    public String getServerItem() {
        return this.serverItem;
    }

    public void setServerItem(String value) {
        this.serverItem = value;
    }

    public boolean isExecutable() {
        if (this.isSymbolicLink()) {
            return false;
        }
        return this.attrs.isExecutable();
    }
}

