/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace;

import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.CommittedServerItemQuery;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.CommittedState;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLocalItem;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceVersionTable;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.util.NotYetImplementedException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class QueryLocalVersionsByTargetServerItemEnumerator
implements Iterator<WorkspaceLocalItem> {
    private WorkspaceLocalItem current;
    private CommittedServerItemQuery query;
    private Iterator<WorkspaceLocalItem> queryIt;
    private boolean enumeratedUncommittedItems;
    private int excludedItemIndex;
    private final WorkspaceVersionTable lv;
    private final String targetServerItem;
    private final RecursionType recursion;
    private final String pattern;
    private final boolean includeDeleted;
    private final Iterator<CommittedServerItemQuery> queries;

    public QueryLocalVersionsByTargetServerItemEnumerator(WorkspaceVersionTable lv, String targetServerItem, RecursionType recursion, String pattern, boolean includeDeleted, Iterable<CommittedServerItemQuery> queries) {
        this.lv = lv;
        this.targetServerItem = targetServerItem;
        this.recursion = recursion;
        this.pattern = pattern;
        this.includeDeleted = includeDeleted;
        this.queries = queries.iterator();
    }

    public boolean moveNext() {
        while (true) {
            if (null == this.queryIt) {
                if (this.queries.hasNext()) {
                    this.query = this.queries.next();
                    this.queryIt = this.lv.queryByServerItem(this.query.getCommittedServerItem(), this.query.getRecursionType(), this.pattern, CommittedState.COMMITTED, this.includeDeleted).iterator();
                    this.excludedItemIndex = 0;
                } else if (!this.enumeratedUncommittedItems) {
                    this.queryIt = this.lv.queryByServerItem(this.targetServerItem, this.recursion, this.pattern, CommittedState.UNCOMMITTED, this.includeDeleted).iterator();
                    this.enumeratedUncommittedItems = true;
                } else {
                    this.current = null;
                    return false;
                }
            }
            while (this.queryIt.hasNext()) {
                WorkspaceLocalItem currentItem = this.queryIt.next();
                boolean enumerateItem = true;
                while (null != this.query && this.excludedItemIndex < this.query.getExcludedItems().size()) {
                    if (ServerPath.isChild(this.query.getExcludedItems().get(this.excludedItemIndex), currentItem.getServerItem())) {
                        enumerateItem = false;
                        break;
                    }
                    if (ServerPath.compareTopDown(currentItem.getServerItem(), this.query.getExcludedItems().get(this.excludedItemIndex)) <= 0) break;
                    ++this.excludedItemIndex;
                }
                if (!enumerateItem) continue;
                this.current = currentItem;
                return true;
            }
            this.queryIt = null;
            this.query = null;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.current != null) {
            return true;
        }
        return this.moveNext();
    }

    @Override
    public WorkspaceLocalItem next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        WorkspaceLocalItem toReturn = this.current;
        this.moveNext();
        return toReturn;
    }

    @Override
    public void remove() {
        throw new NotYetImplementedException();
    }
}

