/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.localworkspace;

import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BaselineFolderState;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.jni.FileSystemAttributes;
import com.microsoft.tfs.jni.FileSystemUtils;
import com.microsoft.tfs.jni.PlatformMiscUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.Platform;
import java.io.File;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BaselineFolder {
    private static final Log log;
    private static String[] PARTITIONING_FOLDERS;
    private static String[] POTENTIAL_BASELINE_FOLDER_NAME;
    private static final int PARTITIONING_FOLDER_COUNT = 16;
    private static final String TF_FOLDER_NAME;
    private static final String GZ_EXTENSION = ".gz";
    private static final String RAW_EXTENSION = ".rw";
    public String partition;
    public String path;
    public BaselineFolderState state;

    public BaselineFolder(String partition, String path, BaselineFolderState state) {
        this.partition = partition;
        this.path = path;
        this.state = state;
    }

    public BaselineFolder clone() {
        return new BaselineFolder(this.partition, this.path, this.state);
    }

    public static BaselineFolder create(Workspace workspace, String localFolder) {
        Check.notNullOrEmpty(localFolder, "localFolder");
        File file = new File(localFolder);
        if (!file.exists()) {
            return null;
        }
        try {
            for (String proposedFolderName : POTENTIAL_BASELINE_FOLDER_NAME) {
                String proposedPath = LocalPath.combine(localFolder, proposedFolderName);
                File proposedFile = new File(proposedPath);
                if (proposedFile.exists()) continue;
                BaselineFolder.ensureBaselineDirectoryExists(workspace, proposedPath);
                BaselineFolder.createBaselineFolderStructure(proposedPath);
                return new BaselineFolder(BaselineFolder.getPartitionForPath(localFolder), proposedPath, BaselineFolderState.VALID);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static void createBaselineFolderStructure(String path) {
        for (int j = 0; j < 16; ++j) {
            String partitioningFolderPath = LocalPath.combine(path, PARTITIONING_FOLDERS[j]);
            File directory = new File(partitioningFolderPath);
            if (directory.exists()) continue;
            directory.mkdirs();
        }
    }

    public static void ensureLocalMetadataDirectoryExists(Workspace workspace) {
        BaselineFolder.ensureLocalMetadataDirectoryExists(workspace, null);
    }

    public static void ensureLocalMetadataDirectoryExists(Workspace workspace, String sourceDirectoryForAcl) {
        FileSystemAttributes attrs;
        File directory = new File(workspace.getLocalMetadataDirectory());
        if (directory.exists()) {
            return;
        }
        directory.mkdirs();
        if (Platform.isCurrentPlatform(Platform.WINDOWS)) {
            try {
                String ownerSID = FileSystemUtils.getInstance().getOwner(directory.getAbsolutePath());
                String currentSID = PlatformMiscUtils.getInstance().getCurrentIdentityUser();
                if (ownerSID.equals(PlatformMiscUtils.getInstance().getWellKnownSID(26, null))) {
                    try {
                        FileSystemUtils.getInstance().setOwner(directory.getAbsolutePath(), currentSID);
                    }
                    catch (Exception e) {
                        log.warn((Object)MessageFormat.format("Error changing owner on {0} to {1}", directory, currentSID), (Throwable)e);
                    }
                }
                String copyExplicitEntriesFromPath = null;
                if (sourceDirectoryForAcl != null && new File(sourceDirectoryForAcl).exists() && new File(sourceDirectoryForAcl).isDirectory()) {
                    copyExplicitEntriesFromPath = sourceDirectoryForAcl;
                }
                FileSystemUtils.getInstance().grantInheritableFullControl(directory.getAbsolutePath(), currentSID, copyExplicitEntriesFromPath);
            }
            catch (Exception e) {
                log.warn((Object)MessageFormat.format("Error proper ensuring owner of {0}", directory), (Throwable)e);
            }
        }
        if ((attrs = FileSystemUtils.getInstance().getAttributes(directory)) != null) {
            attrs.setNotContentIndexed(true);
            FileSystemUtils.getInstance().setAttributes(directory, attrs);
        }
    }

    public static void ensureBaselineDirectoryExists(Workspace workspace, String directoryPath) {
        FileSystemAttributes attrs;
        BaselineFolder.ensureLocalMetadataDirectoryExists(workspace);
        File directory = new File(directoryPath);
        if (directory.exists()) {
            return;
        }
        directory.mkdirs();
        if (Platform.isCurrentPlatform(Platform.WINDOWS)) {
            try {
                String ownerSID = FileSystemUtils.getInstance().getOwner(directory.getAbsolutePath());
                String currentSID = PlatformMiscUtils.getInstance().getCurrentIdentityUser();
                if (ownerSID.equals(PlatformMiscUtils.getInstance().getWellKnownSID(26, null))) {
                    try {
                        FileSystemUtils.getInstance().setOwner(directory.getAbsolutePath(), currentSID);
                    }
                    catch (Exception e) {
                        log.warn((Object)MessageFormat.format("Error changing owner on {0} to {1}", directory, currentSID), (Throwable)e);
                    }
                }
                FileSystemUtils.getInstance().copyExplicitDACLEntries(workspace.getLocalMetadataDirectory(), directory.getAbsolutePath());
            }
            catch (Exception e) {
                log.warn((Object)MessageFormat.format("Error proper ensuring owner of {0}", directory), (Throwable)e);
            }
        }
        if ((attrs = FileSystemUtils.getInstance().getAttributes(directory)) != null) {
            attrs.setNotContentIndexed(true);
            attrs.setHidden(true);
            FileSystemUtils.getInstance().setAttributes(directory, attrs);
        }
    }

    public static boolean isPotentialBaselineFolderName(String folderName) {
        for (String potentialFolderName : POTENTIAL_BASELINE_FOLDER_NAME) {
            if (!folderName.equalsIgnoreCase(potentialFolderName)) continue;
            return true;
        }
        return false;
    }

    public String getPathFromGUID(byte[] baselineFileGuid) {
        Check.notNull(this.path, "Should not call BaselineFolder.GetPathFromGuid on a BaselineFolder with a null Path");
        return BaselineFolder.getPathFromGUID(this.path, baselineFileGuid);
    }

    public static String getPathFromGUID(String baselineFolderRootPath, byte[] baselineFileGuid) {
        BaselineFolder.checkForValidBaselineFileGUID(baselineFileGuid);
        AtomicReference<String> outIndividualBaselineFolder = new AtomicReference<String>();
        return BaselineFolder.getPathFromGUID(baselineFolderRootPath, baselineFileGuid, outIndividualBaselineFolder);
    }

    public static String getPathFromGUID(String baselineFolderRootPath, byte[] baselineFileGuid, AtomicReference<String> individualBaselineFolder) {
        BaselineFolder.checkForValidBaselineFileGUID(baselineFileGuid);
        individualBaselineFolder.set(baselineFolderRootPath + File.separator + PARTITIONING_FOLDERS[(char)baselineFileGuid[0] % 16]);
        return individualBaselineFolder.get() + File.separator + new GUID(baselineFileGuid).getGUIDString();
    }

    public static void checkForValidBaselineFileGUID(byte[] baselineFileGuid) {
        Check.notNull(baselineFileGuid, "baselineFileGuid");
        Check.isTrue(baselineFileGuid.length == 16, "baselineFileGuid");
    }

    public String getPath() {
        return this.path;
    }

    public BaselineFolderState getState() {
        return this.state;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BaselineFolder) {
            BaselineFolder other = (BaselineFolder)obj;
            return this.partition.equals(other.partition) && this.path.equals(other.path) && this.state == other.state;
        }
        return false;
    }

    public int hashCode() {
        return this.partition.hashCode() * 17 + this.path.hashCode() * 11 + this.state.getValue() * 3;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BaselineFolder Partition('");
        sb.append(this.partition);
        sb.append("'), State('");
        sb.append(this.state);
        sb.append("'), + Path('");
        sb.append(this.path);
        sb.append("')");
        return sb.toString();
    }

    public static String getPartitionForPath(String localItem) {
        Check.notNullOrEmpty(localItem, "localItem");
        if (!LocalPath.isPathRooted(localItem)) {
            throw new IllegalArgumentException("getPartitionForPath: The path was not rooted.");
        }
        return LocalPath.getPathRoot(localItem);
    }

    public static String getBaselineFolderName() {
        return TF_FOLDER_NAME;
    }

    public static String getGzipExtension() {
        return GZ_EXTENSION;
    }

    public static String getRawExtension() {
        return RAW_EXTENSION;
    }

    public static int getPartitioningFolderCount() {
        return 16;
    }

    static {
        int i;
        log = LogFactory.getLog(BaselineFolder.class);
        TF_FOLDER_NAME = Platform.isCurrentPlatform(Platform.WINDOWS) ? "$tf" : ".tf";
        PARTITIONING_FOLDERS = new String[16];
        for (i = 0; i < 16; ++i) {
            BaselineFolder.PARTITIONING_FOLDERS[i] = Integer.toString(i);
        }
        POTENTIAL_BASELINE_FOLDER_NAME = new String[16];
        BaselineFolder.POTENTIAL_BASELINE_FOLDER_NAME[0] = TF_FOLDER_NAME;
        for (i = 1; i < 16; ++i) {
            BaselineFolder.POTENTIAL_BASELINE_FOLDER_NAME[i] = TF_FOLDER_NAME + Integer.toString(i);
        }
    }
}

