/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.localworkspace;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.Workstation;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ItemNotMappedException;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalWorkspaceProperties;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalWorkspaceTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.IgnoreEntry;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.IgnoreFile;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkingFolder;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.config.persistence.PersistenceStoreProvider;
import com.microsoft.tfs.util.Check;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class LocalItemExclusionEvaluator {
    public static final String IGNORE_FILE_NAME = ".tfignore";
    public static final String IGNORE_FILE_NAME_WITH_SEPARATOR_PREFIX = File.separator + IGNORE_FILE_NAME;
    private static final String DEFAULT_IGNORE_FILE_NAME = ".tfignore";
    private final String startLocalItem;
    private final int startLocalItemDepth;
    private final WorkingFolder[] workingFolders;
    private String startLocalItemWorkspaceRoot;
    private final List<IgnoreFile> ignoreFiles = new ArrayList<IgnoreFile>();
    private String currentDirectory;
    private boolean useOnlyStartLocalItemExclusions = false;

    public LocalItemExclusionEvaluator(Workspace workspace, String startLocalItem) {
        Check.notNull(workspace, "workspace");
        Check.notNullOrEmpty(startLocalItem, "startLocalItem");
        if (!workspace.isLocalPathMapped(startLocalItem)) {
            throw new ItemNotMappedException(MessageFormat.format(Messages.getString("LocalItemExclusionEvaluator.ItemNotMappedExceptionFormat"), startLocalItem));
        }
        this.workingFolders = workspace.getFolders();
        this.startLocalItem = startLocalItem;
        this.startLocalItemDepth = LocalPath.getFolderDepth(this.startLocalItem);
        this.initialize(Workstation.getCurrent(workspace.getClient().getConnection().getPersistenceStoreProvider()).getLocalItemExclusions(workspace.getClient()));
    }

    public LocalItemExclusionEvaluator(LocalWorkspaceProperties wp, String startLocalItem) {
        Check.notNull(wp, "wp");
        Check.notNullOrEmpty(startLocalItem, "startLocalItem");
        if (null == WorkingFolder.getServerItemForLocalItem(startLocalItem, wp.getWorkingFolders())) {
            throw new ItemNotMappedException(MessageFormat.format(Messages.getString("LocalItemExclusionEvaluator.ItemNotMappedExceptionFormat"), startLocalItem));
        }
        this.workingFolders = wp.getWorkingFolders();
        this.startLocalItem = startLocalItem;
        this.startLocalItemDepth = LocalPath.getFolderDepth(this.startLocalItem);
        VersionControlClient client = LocalWorkspaceTransaction.getCurrent().getWorkspace().getClient();
        PersistenceStoreProvider storeProvider = client.getConnection().getPersistenceStoreProvider();
        this.initialize(Workstation.getCurrent(storeProvider).getLocalItemExclusions(client));
    }

    private void initialize(String[] globalExclusions) {
        for (String workspaceRoot : WorkingFolder.getWorkspaceRoots(this.workingFolders)) {
            if (!LocalPath.isChild(workspaceRoot, this.startLocalItem)) continue;
            this.startLocalItemWorkspaceRoot = workspaceRoot;
            break;
        }
        if (null == this.startLocalItemWorkspaceRoot) {
            throw new ItemNotMappedException(MessageFormat.format(Messages.getString("LocalItemExclusionEvaluator.ItemNotMappedExceptionFormat"), this.startLocalItem));
        }
        String currentItem = LocalPath.getParent(this.startLocalItem);
        if (currentItem != null && !LocalPath.equals(currentItem, this.startLocalItem)) {
            while (LocalPath.isChild(this.startLocalItemWorkspaceRoot, currentItem)) {
                IgnoreFile ignoreFile = IgnoreFile.load(currentItem);
                if (null != ignoreFile) {
                    this.ignoreFiles.add(ignoreFile);
                }
                String itemParent = LocalPath.getParent(currentItem);
                if (currentItem == null || LocalPath.equals(itemParent, currentItem)) break;
                currentItem = itemParent;
            }
            this.currentDirectory = currentItem;
        }
        IgnoreFile globalExclusionList = new IgnoreFile("");
        for (String globalExclusion : globalExclusions) {
            globalExclusionList.addEntry(new IgnoreEntry(globalExclusion));
        }
        this.ignoreFiles.add(globalExclusionList);
        Collections.reverse(this.ignoreFiles);
    }

    public boolean isUseOnlyStartLocalItemExclusions() {
        return this.useOnlyStartLocalItemExclusions;
    }

    public void setUseOnlyStartLocalItemExclusions(boolean value) {
        this.useOnlyStartLocalItemExclusions = value;
    }

    public boolean isExcluded(String localItem) {
        return this.isExcluded(localItem, false, null, null);
    }

    public boolean isExcluded(String localItem, boolean isFolder) {
        return this.isExcluded(localItem, isFolder, null, null);
    }

    public boolean isExcluded(String localItem, boolean isFolder, AtomicReference<String> appliedExclusion, AtomicReference<String> ignoreFilePath) {
        if (appliedExclusion != null) {
            appliedExclusion.set(null);
        }
        if (ignoreFilePath != null) {
            ignoreFilePath.set(null);
        }
        Check.isTrue(LocalPath.isChild(this.startLocalItem, localItem), "localItem must be a child of the startLocalItem");
        this.prepareStackForLocalItem(localItem);
        for (int i = this.ignoreFiles.size() - 1; i >= 0; --i) {
            AtomicReference<String> innerAppliedExclusion;
            Boolean isExcluded;
            IgnoreFile ignoreFile = this.ignoreFiles.get(i);
            if (null == ignoreFile || (isExcluded = ignoreFile.isExcluded(localItem, isFolder, this.startLocalItem, innerAppliedExclusion = new AtomicReference<String>())) == null) continue;
            if (appliedExclusion != null) {
                appliedExclusion.set(innerAppliedExclusion.get());
            }
            if (ignoreFilePath != null) {
                if (0 == i) {
                    ignoreFilePath.set("");
                } else {
                    ignoreFilePath.set(ignoreFile.getFullPath());
                }
            }
            return isExcluded;
        }
        return false;
    }

    private void prepareStackForLocalItem(String localItemToCheck) {
        int popCount;
        if (null == this.currentDirectory && (this.useOnlyStartLocalItemExclusions || LocalPath.equals(localItemToCheck, this.startLocalItem))) {
            return;
        }
        if (null != this.currentDirectory && LocalPath.isDirectChild(this.currentDirectory, localItemToCheck)) {
            return;
        }
        String newCurrentDirectory = LocalPath.getParent(localItemToCheck);
        if (LocalPath.equals(newCurrentDirectory, localItemToCheck)) {
            newCurrentDirectory = null;
        }
        String commonPath = null;
        if (null != this.currentDirectory && null != newCurrentDirectory) {
            commonPath = LocalPath.getCommonPathPrefix(localItemToCheck, this.currentDirectory);
        }
        int currentFolderDepth = 0;
        int commonFolderDepth = 0;
        if (null != this.currentDirectory) {
            currentFolderDepth = LocalPath.getFolderDepth(this.currentDirectory);
        }
        if (null != commonPath) {
            commonFolderDepth = LocalPath.getFolderDepth(commonPath);
        }
        if ((popCount = currentFolderDepth - commonFolderDepth) > 0) {
            for (int i = 0; i < popCount; ++i) {
                this.ignoreFiles.remove(this.ignoreFiles.size() - 1);
            }
        }
        this.currentDirectory = commonPath;
        if (null != newCurrentDirectory) {
            ArrayList<IgnoreFile> ignoreFilesToAdd = new ArrayList<IgnoreFile>();
            String currentItem = newCurrentDirectory;
            while ((null == this.currentDirectory || currentItem.length() != this.currentDirectory.length()) && LocalPath.isChild(this.startLocalItemWorkspaceRoot, currentItem)) {
                ignoreFilesToAdd.add(IgnoreFile.load(currentItem));
                String itemParent = LocalPath.getParent(currentItem);
                if (LocalPath.equals(itemParent, currentItem)) break;
                currentItem = itemParent;
            }
            Collections.reverse(ignoreFilesToAdd);
            this.ignoreFiles.addAll(ignoreFilesToAdd);
            this.currentDirectory = newCurrentDirectory;
        }
    }
}

