/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.AutoResolveOptions;
import com.microsoft.tfs.core.clients.versioncontrol.GetItemsOptions;
import com.microsoft.tfs.core.clients.versioncontrol.MergeSummary;
import com.microsoft.tfs.core.clients.versioncontrol.PropertiesMergeSummary;
import com.microsoft.tfs.core.clients.versioncontrol.PropertyConstants;
import com.microsoft.tfs.core.clients.versioncontrol.ResolutionOptions;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.WebServiceLevel;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ConflictOptions;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ConflictType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.DeletedState;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.FileType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemSet;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingSet;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Resolution;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.specs.DownloadSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.VersionedFileSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.WorkspaceSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.ChangesetVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.WorkspaceVersionSpec;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.util.FileEncoding;
import com.microsoft.tfs.core.util.UserNameUtil;
import com.microsoft.tfs.jni.FileSystemTime;
import com.microsoft.tfs.jni.FileSystemUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.HashUtils;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import ms.tfs.versioncontrol.clientservices._03._ChangeType;
import ms.tfs.versioncontrol.clientservices._03._Conflict;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Conflict
extends WebServiceObjectWrapper
implements Comparable<Conflict> {
    private static final Log log = LogFactory.getLog(Conflict.class);
    private String localPath;
    private String serverPath;
    private String mergedFileName = null;
    private ResolutionOptions resolutionOptions = null;
    private MergeSummary mergeSummary = null;
    private PropertiesMergeSummary propertiesMergeSummary = null;
    private String fileName;
    private PropertyValue[] yourProperties;
    private PropertyValue[] theirProperties;
    private PropertyValue[] baseProperties;
    private boolean autoResolved;
    private byte[] localHashValue;
    private long localFileLastModifiedDateUsedForHashValue;
    private long localFileLastModifiedDateUsedForThreeWayMerge;
    private Boolean mergeValidForFileType;

    public Conflict(_Conflict conflict) {
        super(conflict);
    }

    public Conflict(Conflict conflict) {
        this(Conflict.cloneWebServiceObject(conflict.getWebServiceObject()));
    }

    private static _Conflict cloneWebServiceObject(_Conflict conflict) {
        Check.notNull(conflict, "conflict");
        return new _Conflict(conflict.getCid(), conflict.getPcid(), conflict.getYchg() != null ? (_ChangeType)conflict.getYchg().clone() : null, conflict.getYchgEx(), conflict.getYsitem(), conflict.getYsitemsrc(), conflict.getYenc(), conflict.getYprop(), conflict.getYtype(), conflict.getYver(), conflict.getYitemid(), conflict.getYdid(), conflict.getYlchg() != null ? (_ChangeType)conflict.getYlchg().clone() : null, conflict.getYlchgEx(), conflict.getYlmver(), conflict.getBsitem(), conflict.getBenc(), conflict.getBprop(), conflict.getBitemid(), conflict.getBver(), conflict.getBhash() != null ? (byte[])conflict.getBhash().clone() : null, conflict.getBdid(), conflict.getBtype(), conflict.getBchg() != null ? (_ChangeType)conflict.getBchg().clone() : null, conflict.getBchgEx(), conflict.getTitemid(), conflict.getTver(), conflict.getTsitem(), conflict.getTenc(), conflict.getTprop(), conflict.getThash() != null ? (byte[])conflict.getThash().clone() : null, conflict.getTdid(), conflict.getTtype(), conflict.getTlmver(), conflict.getTverf(), conflict.getTctyp(), conflict.isIsc(), conflict.getTsn(), conflict.getTson(), conflict.getSrclitem(), conflict.getTgtlitem(), conflict.getCtype(), conflict.getReason(), conflict.isIsnamecflict(), conflict.isIsforced(), conflict.getRes(), conflict.isIsresolved(), conflict.getBdurl(), conflict.getTdurl(), conflict.getYdurl(), conflict.getCopt());
    }

    public _Conflict getWebServiceObject() {
        return (_Conflict)this.webServiceObject;
    }

    @Override
    public int compareTo(Conflict other) {
        int num;
        if (this.getYourServerItem() != null && other.getYourServerItem() != null && (num = ServerPath.compareTopDown(this.getYourServerItem(), other.getYourServerItem())) != 0) {
            return num;
        }
        if (this.getTheirServerItem() != null && other.getTheirServerItem() != null && (num = ServerPath.compareTopDown(this.getTheirServerItem(), other.getTheirServerItem())) != 0) {
            return num;
        }
        if (this.getConflictID() > other.getConflictID()) {
            return 1;
        }
        if (this.getConflictID() < other.getConflictID()) {
            return -1;
        }
        return 0;
    }

    public ChangeType getBaseChangeType() {
        return new ChangeType(this.getWebServiceObject().getBchg(), this.getWebServiceObject().getBchgEx());
    }

    public int getBaseDeletionID() {
        return this.getWebServiceObject().getBdid();
    }

    public FileEncoding getBaseEncoding() {
        return new FileEncoding(this.getWebServiceObject().getBenc());
    }

    public int getBasePropertyID() {
        return this.getWebServiceObject().getBprop();
    }

    public byte[] getBaseHashValue() {
        return this.getWebServiceObject().getBhash();
    }

    public int getBaseItemID() {
        return this.getWebServiceObject().getBitemid();
    }

    public ItemType getBaseItemType() {
        return ItemType.fromWebServiceObject(this.getWebServiceObject().getBtype());
    }

    public String getBaseServerItem() {
        return this.getWebServiceObject().getBsitem();
    }

    public int getBaseVersion() {
        return this.getWebServiceObject().getBver();
    }

    public int getConflictID() {
        return this.getWebServiceObject().getCid();
    }

    public int getPendingChangeID() {
        return this.getWebServiceObject().getPcid();
    }

    public int getReason() {
        return this.getWebServiceObject().getReason();
    }

    public Resolution getResolution() {
        return Resolution.fromWebServiceObject(this.getWebServiceObject().getRes());
    }

    public String getSourceLocalItem() {
        return LocalPath.tfsToNative(this.getWebServiceObject().getSrclitem());
    }

    public String getTargetLocalItem() {
        return LocalPath.tfsToNative(this.getWebServiceObject().getTgtlitem());
    }

    public ChangeType getTheirChangeType() {
        return new ChangeType(ChangeType.NONE.getWebServiceObject(), this.getWebServiceObject().getTctyp());
    }

    public int getTheirDeletionID() {
        return this.getWebServiceObject().getTdid();
    }

    public FileEncoding getTheirEncoding() {
        return new FileEncoding(this.getWebServiceObject().getTenc());
    }

    public int getTheirPropertyID() {
        return this.getWebServiceObject().getTprop();
    }

    public byte[] getTheirHashValue() {
        return this.getWebServiceObject().getThash();
    }

    public int getTheirItemID() {
        return this.getWebServiceObject().getTitemid();
    }

    public ItemType getTheirItemType() {
        return ItemType.fromWebServiceObject(this.getWebServiceObject().getTtype());
    }

    public int getTheirLastMergedVersion() {
        return this.getWebServiceObject().getTlmver();
    }

    public String getTheirServerItem() {
        return this.getWebServiceObject().getTsitem();
    }

    public int getTheirVersion() {
        return this.getWebServiceObject().getTver();
    }

    public int getTheirVersionFrom() {
        return this.getWebServiceObject().getTverf();
    }

    public ConflictType getType() {
        return ConflictType.fromWebServiceObject(this.getWebServiceObject().getCtype());
    }

    public ChangeType getYourChangeType() {
        return new ChangeType(this.getWebServiceObject().getYchg(), this.getWebServiceObject().getYchgEx());
    }

    public int getYourDeletionID() {
        return this.getWebServiceObject().getYdid();
    }

    public FileEncoding getYourEncoding() {
        return new FileEncoding(this.getWebServiceObject().getYenc());
    }

    public int getYourPropertyID() {
        return this.getWebServiceObject().getYprop();
    }

    public int getYourItemID() {
        return this.getWebServiceObject().getYitemid();
    }

    public ItemType getYourItemType() {
        return ItemType.fromWebServiceObject(this.getWebServiceObject().getYtype());
    }

    public int getYourLastMergedVersion() {
        return this.getWebServiceObject().getYlmver();
    }

    public ChangeType getYourLocalChangeType() {
        return new ChangeType(this.getWebServiceObject().getYlchg(), this.getWebServiceObject().getYlchgEx());
    }

    public String getYourServerItem() {
        return this.getWebServiceObject().getYsitem();
    }

    public String getYourServerItemSource() {
        return this.getWebServiceObject().getYsitemsrc();
    }

    public int getYourVersion() {
        return this.getWebServiceObject().getYver();
    }

    public ConflictOptions getConflictOptions() {
        return ConflictOptions.fromIntFlags(this.getWebServiceObject().getCopt());
    }

    public boolean isForced() {
        return this.getWebServiceObject().isIsforced();
    }

    public boolean isNamespaceConflict() {
        return this.getWebServiceObject().isIsnamecflict();
    }

    public boolean isShelvesetConflict() {
        return this.getWebServiceObject().isIsc();
    }

    public boolean isResolved() {
        return this.getWebServiceObject().isIsresolved();
    }

    public void setBaseChangeType(ChangeType baseChangeType) {
        this.getWebServiceObject().setBchg(baseChangeType.getWebServiceObject());
    }

    public void setBaseDeletionID(int baseDeletionID) {
        this.getWebServiceObject().setBdid(baseDeletionID);
    }

    public void setBaseEncoding(int baseEncoding) {
        this.getWebServiceObject().setBenc(baseEncoding);
    }

    public void setBaseHashValue(byte[] baseHashValue) {
        this.getWebServiceObject().setBhash(baseHashValue);
    }

    public void setBaseItemID(int baseItemID) {
        this.getWebServiceObject().setBitemid(baseItemID);
    }

    public void setBaseItemType(ItemType baseItemType) {
        this.getWebServiceObject().setBtype(baseItemType.getWebServiceObject());
    }

    public void setBaseServerItem(String baseServerItem) {
        this.getWebServiceObject().setBsitem(baseServerItem);
    }

    public void setBaseVersion(int baseVersion) {
        this.getWebServiceObject().setBver(baseVersion);
    }

    public void setConflictID(int conflictID) {
        this.getWebServiceObject().setCid(conflictID);
    }

    public void setForced(boolean isForced) {
        this.getWebServiceObject().setIsforced(isForced);
    }

    public void setNamespaceConflict(boolean isNamespaceConflict) {
        this.getWebServiceObject().setIsnamecflict(isNamespaceConflict);
    }

    public void setResolved(boolean isResolved) {
        this.getWebServiceObject().setIsresolved(isResolved);
    }

    public void setPendingChangeID(int pendingChangeID) {
        this.getWebServiceObject().setPcid(pendingChangeID);
    }

    public void setReason(int reason) {
        this.getWebServiceObject().setReason(reason);
    }

    public void setResolution(Resolution resolution) {
        this.getWebServiceObject().setRes(resolution.getWebServiceObject());
    }

    public void setSourceLocalItem(String sourceLocalItem) {
        this.getWebServiceObject().setSrclitem(LocalPath.nativeToTFS(sourceLocalItem));
    }

    public void setTargetLocalItem(String targetLocalItem) {
        this.getWebServiceObject().setTgtlitem(LocalPath.nativeToTFS(targetLocalItem));
    }

    public void setTheirDeletionID(int theirDeletionID) {
        this.getWebServiceObject().setTdid(theirDeletionID);
    }

    public void setTheirEncoding(int theirEncoding) {
        this.getWebServiceObject().setTenc(theirEncoding);
    }

    public void setTheirHashValue(byte[] theirHashValue) {
        this.getWebServiceObject().setThash(theirHashValue);
    }

    public void setTheirItemID(int theirItemID) {
        this.getWebServiceObject().setTitemid(theirItemID);
    }

    public void setTheirItemType(ItemType theirItemType) {
        this.getWebServiceObject().setTtype(theirItemType.getWebServiceObject());
    }

    public void setTheirLastMergedVersion(int theirLastMergedVersion) {
        this.getWebServiceObject().setTlmver(theirLastMergedVersion);
    }

    public void setTheirServerItem(String theirServerItem) {
        this.getWebServiceObject().setTsitem(theirServerItem);
    }

    public void setTheirVersion(int theirVersion) {
        this.getWebServiceObject().setTver(theirVersion);
    }

    public void setType(ConflictType type) {
        this.getWebServiceObject().setCtype(type.getWebServiceObject());
    }

    public void setYourChangeType(ChangeType yourChangeType) {
        this.getWebServiceObject().setYchg(yourChangeType.getWebServiceObject());
    }

    public void setYourDeletionID(int yourDeletionID) {
        this.getWebServiceObject().setYdid(yourDeletionID);
    }

    public void setYourEncoding(int yourEncoding) {
        this.getWebServiceObject().setYenc(yourEncoding);
    }

    public void setYourItemID(int yourItemID) {
        this.getWebServiceObject().setYitemid(yourItemID);
    }

    public void setYourItemType(ItemType yourItemType) {
        this.getWebServiceObject().setYtype(yourItemType.getWebServiceObject());
    }

    public void setYourLastMergedVersion(int yourLastMergedVersion) {
        this.getWebServiceObject().setYlmver(yourLastMergedVersion);
    }

    public void setYourLocalChangeType(ChangeType yourLocalChangeType) {
        this.getWebServiceObject().setYlchg(yourLocalChangeType.getWebServiceObject());
    }

    public void setYourServerItem(String yourServerItem) {
        this.getWebServiceObject().setYsitem(yourServerItem);
    }

    public void setYourServerItemSource(String yourServerItemSource) {
        this.getWebServiceObject().setYsitemsrc(yourServerItemSource);
    }

    public void setYourVersion(int yourVersion) {
        this.getWebServiceObject().setYver(yourVersion);
    }

    public void setConflictOptions(ConflictOptions options) {
        this.getWebServiceObject().setCopt(options.toIntFlags());
    }

    public String getBaseDownloadURL() {
        return this.getWebServiceObject().getBdurl();
    }

    public String getTheirDownloadURL() {
        return this.getWebServiceObject().getTdurl();
    }

    public String getYourDownloadURL() {
        return this.getWebServiceObject().getYdurl();
    }

    public String getTheirShelvesetName() {
        return this.getWebServiceObject().getTsn();
    }

    public String getTheirShelvesetOwnerName() {
        return this.getWebServiceObject().getTson();
    }

    public String getMergedFileName() {
        return this.mergedFileName;
    }

    public void setMergedFileName(String file) {
        this.mergedFileName = file == null || file.length() == 0 ? null : LocalPath.canonicalize(file);
    }

    public void setResolutionOptions(ResolutionOptions options) {
        this.resolutionOptions = options == null ? new ResolutionOptions() : options;
    }

    public ResolutionOptions getResolutionOptions() {
        if (this.resolutionOptions == null) {
            this.resolutionOptions = new ResolutionOptions();
        }
        return this.resolutionOptions;
    }

    public void setContentMergeSummary(MergeSummary summary) {
        this.mergeSummary = summary;
    }

    public MergeSummary getContentMergeSummary() {
        return this.mergeSummary;
    }

    public boolean canMergeContent() {
        boolean isNamespace;
        boolean isGetCheckin = this.getType() == ConflictType.GET || this.getType() == ConflictType.CHECKIN;
        boolean bl = isNamespace = isGetCheckin && this.isNamespaceConflict();
        if (this.getYourItemType() == ItemType.FOLDER || isNamespace) {
            return false;
        }
        if (this.getYourChangeType().contains(ChangeType.EDIT) && this.getBaseChangeType().contains(ChangeType.EDIT)) {
            return true;
        }
        if (this.getType() == ConflictType.MERGE && this.getBaseChangeType().contains(ChangeType.EDIT)) {
            if (this.getYourLocalChangeType().contains(ChangeType.EDIT)) {
                return true;
            }
            if (this.isForced()) {
                return true;
            }
            if (!(this.getBaseChangeType().contains(ChangeType.ROLLBACK) || this.getTheirLastMergedVersion() == this.getBaseVersion() && this.getYourLastMergedVersion() == this.getYourVersion())) {
                return true;
            }
        }
        return false;
    }

    public String getLocalPath() {
        if (this.localPath == null) {
            this.localPath = this.getSourceLocalItem() != null && this.getSourceLocalItem().length() > 0 ? this.getSourceLocalItem() : (this.getTargetLocalItem() != null ? this.getTargetLocalItem() : "");
        }
        return this.localPath;
    }

    public String getServerPath() {
        if (this.serverPath == null) {
            this.serverPath = this.getYourServerItemSource() != null && this.getYourServerItemSource().length() > 0 ? this.getYourServerItemSource() : (this.getYourServerItem() != null && this.getYourServerItem().length() > 0 ? this.getYourServerItem() : (this.getTheirServerItem() != null ? this.getTheirServerItem() : ""));
        }
        return this.serverPath;
    }

    public String getTheirShelvesetDisplayName(Workspace workspace) {
        String shelvesetName = null;
        if (this.isShelvesetConflict()) {
            shelvesetName = this.getTheirShelvesetName() == null || this.getTheirShelvesetName().length() == 0 ? Messages.getString("Conflict.ShelvesetDeletedDisplayName") : (UserNameUtil.equals(workspace.getClient().getConnection().getAuthorizedIdentity().getDisplayName(), this.getTheirShelvesetOwnerName()) ? this.getTheirShelvesetName() : new WorkspaceSpec(this.getTheirShelvesetName(), this.getTheirShelvesetOwnerName()).toString());
        }
        return shelvesetName;
    }

    public void downloadBaseFile(VersionControlClient client, String absolutePath) {
        Check.notNull(client, "client");
        Check.notNull(absolutePath, "absolutePath");
        Check.notNull(this.getBaseDownloadURL(), "getBaseDownloadURL()");
        client.downloadFile(new DownloadSpec(this.getBaseDownloadURL()), new File(absolutePath), true);
    }

    public void downloadTheirFile(VersionControlClient client, String absolutePath) {
        Check.notNull(client, "client");
        Check.notNull(absolutePath, "absolutePath");
        Check.notNull(this.getTheirDownloadURL(), "getTheirDownloadURL()");
        client.downloadFile(new DownloadSpec(this.getTheirDownloadURL()), new File(absolutePath), true);
    }

    public void downloadYourFile(VersionControlClient client, String absolutePath) {
        Check.notNull(client, "client");
        Check.notNull(absolutePath, "absolutePath");
        client.downloadFile(new DownloadSpec(this.getYourDownloadURL()), new File(absolutePath), true);
    }

    public boolean theirFileExists() {
        return this.getTheirDownloadURL() != null;
    }

    public boolean requiresExplicitAcceptMerge() {
        boolean baselessUndelete = this.isBaseless() | (ConflictType.MERGE.equals(this.getType()) && this.getTheirLastMergedVersion() != this.getBaseVersion() && !this.isShelvesetConflict()) && this.getBaseChangeType().contains(ChangeType.UNDELETE);
        return this.getBaseChangeType().contains(ChangeType.DELETE) || this.getYourChangeType().contains(ChangeType.DELETE) || this.getYourLocalChangeType().contains(ChangeType.DELETE) || baselessUndelete;
    }

    public boolean isEncodingMismatched() {
        return this.getTheirEncoding().getCodePage() != this.getYourEncoding().getCodePage();
    }

    public boolean isBaseless() {
        return ConflictType.MERGE.equals(this.getType()) && this.getBaseItemID() == 0;
    }

    public boolean isBinary() {
        boolean anyBinary = this.getTheirEncoding().getCodePage() == -1 || this.getYourEncoding().getCodePage() == -1 || !this.isBaseless() && this.getBaseEncoding().getCodePage() == -1;
        return anyBinary;
    }

    public boolean isBasicMergeAllowed(Workspace workspace) {
        if (!ItemType.FILE.equals(this.getYourItemType())) {
            return false;
        }
        if (this.isBinary() && !this.isEncodingChanged()) {
            return false;
        }
        if (this.getConflictOptions().contains(ConflictOptions.DISALLOW_AUTO_MERGE)) {
            return false;
        }
        if (!this.mergeValidForFileType(workspace)) {
            return false;
        }
        if (this.isFromDeletedShelveset()) {
            return false;
        }
        return !this.isVersionConflictAndServerItemDoesNotExist();
    }

    public boolean isEncodingChanged() {
        if (!this.isLocalOrTargetFileInVersionControl()) {
            return false;
        }
        if (!(this.isBaseless() || this.getYourChangeType().contains(ChangeType.ENCODING) || this.getBaseChangeType().contains(ChangeType.ENCODING) || this.canMergeContent())) {
            return false;
        }
        return this.isEncodingMismatched();
    }

    public boolean isPropertyConflict() {
        return (this.getYourChangeType().combine(this.getYourLocalChangeType()).contains(ChangeType.PROPERTY) || this.isBaseless()) && this.getBaseChangeType().contains(ChangeType.PROPERTY);
    }

    public boolean isLocalOrTargetFileInVersionControl() {
        return this.getYourVersion() != 0;
    }

    private boolean mergeValidForFileType(Workspace workspace) {
        if (this.mergeValidForFileType == null) {
            FileType fileType = workspace.getClient().queryCachedFileType(this.getFileExtension());
            this.mergeValidForFileType = fileType == null || fileType.isAllowMultipleCheckout();
        }
        return this.mergeValidForFileType;
    }

    public String getFileName() {
        if (this.fileName == null) {
            String localPath = this.getLocalPath();
            String serverPath = this.getServerPath();
            this.fileName = localPath != null && localPath.length() > 0 ? LocalPath.getFileName(localPath) : (serverPath != null && serverPath.length() > 0 ? ServerPath.getFileName(serverPath) : "");
        }
        return this.fileName;
    }

    public String getFileExtension() {
        String fileExtension = "";
        String fileName = this.getFileName();
        if (fileName != null && fileName.length() > 0) {
            fileExtension = LocalPath.getFileExtension(fileName);
        }
        if (fileExtension.startsWith(".")) {
            fileExtension = fileExtension.substring(1);
        }
        return fileExtension;
    }

    public boolean isAutoResolved() {
        return this.autoResolved;
    }

    public void setAutoResolved(boolean autoResolved) {
        this.autoResolved = autoResolved;
    }

    public boolean isFromDeletedShelveset() {
        return this.isShelvesetConflict() && (this.getTheirShelvesetName() == null || this.getTheirShelvesetName().length() == 0 || this.getTheirShelvesetOwnerName() == null || this.getTheirShelvesetOwnerName().length() == 0);
    }

    public boolean isVersionConflictAndServerItemDoesNotExist() {
        return this.isVersionGetCheckinConflict() && ChangeType.NONE.equals(this.getBaseChangeType()) && this.getTheirVersion() == 0 && this.getTheirServerItem() == null && this.getTheirDeletionID() == 0;
    }

    public boolean isVersionGetCheckinConflict() {
        return !this.isNamespaceConflict() && !this.isRollbackConflict() && (!ConflictType.MERGE.equals(this.getType()) || this.isShelvesetConflict());
    }

    public boolean isRollbackConflict() {
        return this.getBaseChangeType().contains(ChangeType.ROLLBACK);
    }

    public boolean isNameChanged() {
        if (!this.isLocalOrTargetFileInVersionControl()) {
            return false;
        }
        if (ConflictType.MERGE.equals(this.getType())) {
            return this.isTheirNameChanged();
        }
        return this.isYourNameChanged() || this.isTheirNameChanged();
    }

    public boolean isYourNameChanged() {
        return this.getYourChangeType() != null && this.getYourChangeType().contains(ChangeType.RENAME) || this.getYourLocalChangeType() != null && this.getYourLocalChangeType().contains(ChangeType.RENAME);
    }

    public boolean isTheirNameChanged() {
        return this.getBaseChangeType() != null && this.getBaseChangeType().contains(ChangeType.RENAME);
    }

    public boolean isNameChangeIsRedundant() {
        return this.isVersionGetCheckinConflict() && this.getYourServerItem().equals(this.getTheirServerItem());
    }

    public boolean hasNoLocalRenames() {
        return !this.getYourChangeType().combine(this.getYourLocalChangeType()).contains(ChangeType.RENAME);
    }

    public boolean isValidForAutoMerge(Workspace workspace) {
        return this.isBasicMergeAllowed(workspace) && !this.isEncodingChanged() && (!this.isNameChanged() || this.hasNoLocalRenames()) && !this.requiresExplicitAcceptMerge() && !this.isNamespaceConflict();
    }

    public boolean isAutoMergeApplicable(AutoResolveOptions resolveOptions) {
        if (this.getContentMergeSummary() == null) {
            return false;
        }
        if (AutoResolveOptions.NONE.equals(resolveOptions)) {
            return false;
        }
        if (this.hasNoContentChange()) {
            return true;
        }
        if (resolveOptions.contains(AutoResolveOptions.ONLY_LOCAL_TARGET) && this.hasLocalTargetContentChangeOnly()) {
            return true;
        }
        if (resolveOptions.contains(AutoResolveOptions.ONLY_SERVER_SOURCE) && this.hasSourceServerContentChangeOnly()) {
            return true;
        }
        return resolveOptions.contains(AutoResolveOptions.ALL_CONTENT) && !this.hasConflictingContentChange();
    }

    public long getLocalFileLastModifiedDateUsedForHashValue() {
        return this.localFileLastModifiedDateUsedForHashValue;
    }

    public void setLocalFileLastModifiedDateUsedForHashValue(long localFileLastModifiedDateUsedForHashValue) {
        this.localFileLastModifiedDateUsedForHashValue = localFileLastModifiedDateUsedForHashValue;
    }

    public void updateLocalHashValue() {
        File localFile;
        if (this.getLocalHashValue() == null && this.getLocalPath() != null && this.getLocalPath().length() > 0 && (localFile = new File(this.getLocalPath())).exists()) {
            try {
                this.localHashValue = HashUtils.hashFile(localFile, "MD5");
                this.setLocalFileLastModifiedDateUsedForHashValue(this.getLocalFileLastModifiedDate());
            }
            catch (Exception e) {
                log.warn((Object)"Could not determine local file hash value for conflict", (Throwable)e);
            }
        }
    }

    private boolean hasNoContentChange() {
        if (this.getContentMergeSummary() != null) {
            return this.getContentMergeSummary().getTotalConflictingLines() == 0 && this.getContentMergeSummary().getLatestChangedLines() == 0 && this.getContentMergeSummary().getLocalChangedLines() == 0;
        }
        return false;
    }

    public boolean isRedundant(boolean quick, Workspace workspace) {
        boolean redundant;
        if (!this.mayBeRedundant(workspace)) {
            return false;
        }
        if (this.contentMayHaveChanged()) {
            this.resetChangeSummaryIfLocalFileModified();
            if (this.getContentMergeSummary() != null) {
                redundant = this.hasNoContentChange();
            } else {
                if (!quick) {
                    this.updateLocalHashValue();
                }
                byte[] theirHashValue = this.getTheirHashValue();
                byte[] localHashValue = this.getLocalHashValue();
                redundant = theirHashValue != null && localHashValue != null && theirHashValue.length != 0 ? Arrays.equals(theirHashValue, localHashValue) : false;
            }
        } else {
            redundant = true;
        }
        if (this.isPropertyConflict()) {
            this.mergeProperties(workspace);
            if (redundant) {
                redundant = this.getPropertiesMergeSummary().isRedundant();
            }
        }
        return redundant;
    }

    private boolean mayBeRedundant(Workspace workspace) {
        ChangeType coreYours;
        if (workspace.getClient().getServiceLevel().getValue() < WebServiceLevel.TFS_2010.getValue()) {
            return false;
        }
        if (!this.isVersionGetCheckinConflict()) {
            return false;
        }
        if (this.getYourItemType() != this.getTheirItemType()) {
            return false;
        }
        ChangeType changesToCompare = ChangeType.ALL.remove(ChangeType.LOCK.combine(ChangeType.EDIT.combine(ChangeType.RENAME)));
        ChangeType coreTheirs = this.getTheirChangeType().retain(changesToCompare);
        if (!coreTheirs.equals(coreYours = this.isShelvesetConflict() && ConflictType.MERGE.equals(this.getType()) ? this.getYourLocalChangeType().retain(changesToCompare) : this.getYourChangeType().retain(changesToCompare))) {
            return false;
        }
        if (this.isNameChanged() && (this.getTheirServerItem() == null || this.getTheirServerItem().length() == 0 || this.getYourServerItem() == null || this.getYourServerItem().length() == 0 || !ServerPath.equals(this.getTheirServerItem(), this.getYourServerItem(), false))) {
            return false;
        }
        return !this.isEncodingChanged() || this.getTheirEncoding().getCodePage() == this.getYourEncoding().getCodePage();
    }

    public void resetChangeSummaryIfLocalFileModified() {
        if (this.getContentMergeSummary() != null && (this.getLocalFileLastModifiedDate() != this.getLocalFileLastModifiedDateUsedForThreeWayMerge() || this.getLocalFileLastModifiedDateUsedForThreeWayMerge() == 0L)) {
            this.setContentMergeSummary(null);
            this.cleanUpMergedResultFile();
        }
    }

    public boolean hasLocalTargetContentChangeOnly() {
        if (this.getContentMergeSummary() != null) {
            return this.getContentMergeSummary().getTotalConflictingLines() == 0 && this.getContentMergeSummary().getLatestChangedLines() == 0 && this.getContentMergeSummary().getLocalChangedLines() != 0;
        }
        return false;
    }

    public boolean hasSourceServerContentChangeOnly() {
        if (this.getContentMergeSummary() != null) {
            return this.getContentMergeSummary().getTotalConflictingLines() == 0 && this.getContentMergeSummary().getLocalChangedLines() == 0 && this.getContentMergeSummary().getLatestChangedLines() != 0;
        }
        return false;
    }

    public boolean hasConflictingContentChange() {
        if (this.getContentMergeSummary() != null) {
            return this.getContentMergeSummary().getTotalConflictingLines() != 0;
        }
        return false;
    }

    public boolean hasConflictingPropertyChange() {
        if (this.propertiesMergeSummary != null) {
            return this.propertiesMergeSummary.getTotalConflicts() != 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpMergedResultFile() {
        if (this.getMergedFileName() != null && this.getMergedFileName().length() > 0) {
            try {
                new File(this.getMergedFileName()).delete();
            }
            catch (Exception exception) {
            }
            finally {
                this.setMergedFileName(null);
            }
        }
    }

    private boolean contentMayHaveChanged() {
        return this.getYourChangeType().combine(this.getTheirChangeType().combine(this.getYourLocalChangeType())).containsAny(ChangeType.EDIT.combine(ChangeType.BRANCH)) && (ItemType.FILE.equals(this.getYourItemType()) || ItemType.FILE.equals(this.getTheirItemType()));
    }

    public byte[] getLocalHashValue() {
        if (this.getLocalFileLastModifiedDate() != this.getLocalFileLastModifiedDateUsedForHashValue() || this.getLocalFileLastModifiedDateUsedForHashValue() == 0L) {
            this.localHashValue = null;
        }
        return this.localHashValue;
    }

    public void setLocalHashValue(byte[] localHashValue) {
        this.localHashValue = localHashValue;
    }

    private long getLocalFileLastModifiedDate() {
        try {
            FileSystemTime fileTime;
            if (this.getLocalPath() != null && this.getLocalPath().length() > 0 && (fileTime = FileSystemUtils.getInstance().getAttributes(this.getLocalPath()).getModificationTime()) != null) {
                return fileTime.getWindowsFilesystemTime();
            }
            return 0L;
        }
        catch (Exception e) {
            log.warn((Object)"Could not determine local file last modified date", (Throwable)e);
            return 0L;
        }
    }

    private long getLocalFileLastModifiedDateUsedForThreeWayMerge() {
        return this.localFileLastModifiedDateUsedForThreeWayMerge;
    }

    public void setLocalFileLastModifiedDateUsedForThreeWayMerge(long localFileLastModifiedDateUsedForThreeWayMerge) {
        this.localFileLastModifiedDateUsedForThreeWayMerge = localFileLastModifiedDateUsedForThreeWayMerge;
    }

    public PropertiesMergeSummary mergeProperties(Workspace workspace) {
        if (!this.isPropertyConflict()) {
            return null;
        }
        if (this.propertiesMergeSummary == null) {
            if (this.getYourProperties() == null || this.getTheirProperties() == null || this.getBaseProperties() == null) {
                this.downloadProperties(workspace);
            }
            this.propertiesMergeSummary = PropertiesMergeSummary.calculateSummary(this.getBaseProperties(), this.getYourProperties(), this.getTheirProperties());
        }
        return this.propertiesMergeSummary;
    }

    public PropertiesMergeSummary getPropertiesMergeSummary() {
        return this.propertiesMergeSummary;
    }

    public PropertyValue[] getYourProperties() {
        return this.yourProperties;
    }

    public PropertyValue[] getTheirProperties() {
        return this.theirProperties;
    }

    public PropertyValue[] getBaseProperties() {
        return this.baseProperties;
    }

    public void downloadProperties(Workspace workspace) {
        PendingSet[] pendingSets;
        VersionSpec yourVersion = null;
        String yourServerPath = null;
        if (this.isVersionGetCheckinConflict() || this.isShelvesetConflict()) {
            yourVersion = new WorkspaceVersionSpec(workspace);
            yourServerPath = this.getYourServerItem();
        } else {
            yourVersion = new ChangesetVersionSpec(this.getYourVersion());
            yourServerPath = this.getServerPath();
        }
        this.yourProperties = this.downloadPropertiesHelper(workspace, yourServerPath, yourVersion);
        if (this.getBaseServerItem() != null && this.getBaseServerItem().length() > 0) {
            this.baseProperties = this.downloadPropertiesHelper(workspace, this.getBaseServerItem(), new ChangesetVersionSpec(this.getBaseVersion()));
        }
        this.theirProperties = !this.isShelvesetConflict() || !ConflictType.MERGE.equals(this.getType()) ? this.downloadPropertiesHelper(workspace, this.getTheirServerItem(), new ChangesetVersionSpec(this.getTheirVersion())) : ((pendingSets = workspace.getClient().queryShelvedChanges(null, null, this.getTheirShelvesetName(), this.getTheirShelvesetOwnerName(), new ItemSpec[]{new ItemSpec(this.getTheirServerItem(), RecursionType.NONE)}, false, PropertyConstants.QUERY_ALL_PROPERTIES_FILTERS)).length > 0 && pendingSets[0].getPendingChanges().length > 0 ? pendingSets[0].getPendingChanges()[0].getPropertyValues() : new PropertyValue[0]);
    }

    private PropertyValue[] downloadPropertiesHelper(Workspace workspace, String serverItem, VersionSpec version) {
        ItemSet[] itemSets = workspace.getClient().getItems(new ItemSpec[]{new ItemSpec(serverItem, RecursionType.NONE)}, version, DeletedState.ANY, ItemType.ANY, GetItemsOptions.NONE, PropertyConstants.QUERY_ALL_PROPERTIES_FILTERS);
        if (itemSets.length > 0 && itemSets[0].getItems().length > 0) {
            return itemSets[0].getItems()[0].getPropertyValues();
        }
        return new PropertyValue[0];
    }

    public String getDetailedMessage(boolean asConflict) {
        if (this.getType() == ConflictType.MERGE) {
            String target;
            String source;
            if (this.getBaseChangeType().contains(ChangeType.ROLLBACK)) {
                source = VersionedFileSpec.formatForPath(this.getBaseServerItem(), new ChangesetVersionSpec(this.getTheirVersionFrom()), new ChangesetVersionSpec(this.getBaseVersion()));
            } else if (!this.getBaseChangeType().contains(ChangeType.MERGE)) {
                source = null;
            } else if (this.getBaseChangeType().contains(ChangeType.BRANCH)) {
                ChangesetVersionSpec sourceVersionTo = new ChangesetVersionSpec(this.getTheirVersion());
                source = VersionedFileSpec.formatForPath(this.getTheirServerItem(), sourceVersionTo);
            } else {
                ChangesetVersionSpec sourceVersionFrom = this.getTheirVersion() > 0 ? new ChangesetVersionSpec(this.getTheirVersion()) : new ChangesetVersionSpec(this.getBaseVersion());
                ChangesetVersionSpec sourceVersionTo = new ChangesetVersionSpec(this.getTheirVersion());
                source = VersionedFileSpec.formatForPath(this.getTheirServerItem(), sourceVersionFrom, sourceVersionTo);
            }
            if (this.getBaseChangeType().contains(ChangeType.BRANCH) || this.getYourLocalChangeType().contains(ChangeType.BRANCH) || this.getYourLocalChangeType().contains(ChangeType.ADD)) {
                target = this.getYourServerItemSource();
            } else {
                ChangesetVersionSpec targetVersionPended = new ChangesetVersionSpec(this.getYourVersion());
                target = VersionedFileSpec.formatForPath(this.getYourServerItemSource(), targetVersionPended);
            }
            String message = asConflict ? MessageFormat.format(Messages.getString("Conflict.MergeConflictFormat"), this.getBaseChangeType().toUIString(false), source, target) : (source == null ? MessageFormat.format(Messages.getString("Conflict.MergeAssociatedPendingChangeFormat"), this.getBaseChangeType().toUIString(false), target) : MessageFormat.format(Messages.getString("Conflict.MergePendedFormat"), this.getBaseChangeType().toUIString(false), source, target));
            return message;
        }
        String path = null;
        if (this.getTargetLocalItem() != null) {
            path = this.getTargetLocalItem();
        } else if (this.getSourceLocalItem() != null) {
            path = this.getSourceLocalItem();
        }
        if (path == null || path.length() == 0) {
            path = this.getTheirServerItem();
        }
        return MessageFormat.format(Messages.getString("Conflict.MergeAssociatedPendingChangeFormat"), this.getYourChangeType().combine(this.getYourLocalChangeType()).toUIString(false), path);
    }
}

