/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions.internal;

import com.microsoft.tfs.core.clients.versioncontrol.ILocalVersionUpdate;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.util.Check;
import ms.tfs.versioncontrol.clientservices._03._ServerItemLocalVersionUpdate;

public final class ServerItemLocalVersionUpdate
extends WebServiceObjectWrapper {
    public ServerItemLocalVersionUpdate() {
        this(new _ServerItemLocalVersionUpdate());
    }

    public ServerItemLocalVersionUpdate(_ServerItemLocalVersionUpdate update) {
        super(update);
    }

    public ServerItemLocalVersionUpdate(ILocalVersionUpdate sourceUpdate) {
        super(new _ServerItemLocalVersionUpdate());
        Check.notNullOrEmpty(sourceUpdate.getSourceServerItem(), "sourceUpdate.getSourceServerItem()");
        this.setSourceServerItem(sourceUpdate.getSourceServerItem());
        this.setLocalVersion(sourceUpdate.getVersionLocal());
        this.setTargetLocalItem(sourceUpdate.getTargetLocalItem());
    }

    public _ServerItemLocalVersionUpdate getWebServiceObject() {
        return (_ServerItemLocalVersionUpdate)this.webServiceObject;
    }

    public boolean isCommitted() {
        return this.getLocalVersion() != 0;
    }

    public synchronized int getItemID() {
        return this.getWebServiceObject().getItemid();
    }

    public synchronized void setItemID(int id) {
        this.getWebServiceObject().setItemid(id);
    }

    public synchronized String getTargetLocalItem() {
        return LocalPath.tfsToNative(this.getWebServiceObject().getTlocal());
    }

    public synchronized void setTargetLocalItem(String item) {
        this.getWebServiceObject().setTlocal(LocalPath.nativeToTFS(item));
    }

    public synchronized int getLocalVersion() {
        return this.getWebServiceObject().getLver();
    }

    public synchronized void setLocalVersion(int version) {
        this.getWebServiceObject().setLver(version);
    }

    public synchronized String getSourceServerItem() {
        return this.getWebServiceObject().getSitem();
    }

    public synchronized void setSourceServerItem(String item) {
        this.getWebServiceObject().setSitem(item);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof ServerItemLocalVersionUpdate)) {
            return false;
        }
        ServerItemLocalVersionUpdate other = (ServerItemLocalVersionUpdate)o;
        return this.isCommitted() == other.isCommitted() && ServerPath.equals(this.getSourceServerItem(), other.getSourceServerItem(), true);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

