/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem;

import com.microsoft.tfs.core.clients.workitem.WorkItem;
import com.microsoft.tfs.core.clients.workitem.link.LinkFactory;
import com.microsoft.tfs.core.clients.workitem.link.RelatedLink;
import com.microsoft.tfs.core.clients.workitem.wittype.WorkItemType;

public class WorkItemUtils {
    public static WorkItem createRelatedWorkItem(WorkItem inputWorkItem, WorkItemType workItemType, int linkTypeId, String newTitle, String comment, boolean readOnly) {
        WorkItem newWorkItem = inputWorkItem.getClient().newWorkItem(workItemType);
        if (newTitle == null) {
            newTitle = "";
        }
        newWorkItem.getFields().getField("System.Title").setValue(newTitle);
        newWorkItem.getFields().getField("System.AreaId").setValue(inputWorkItem.getFields().getField("System.AreaId").getValue());
        newWorkItem.getFields().getField("System.AssignedTo").setValue(inputWorkItem.getFields().getField("System.AssignedTo").getValue());
        newWorkItem.getFields().getField("System.IterationId").setValue(inputWorkItem.getFields().getField("System.IterationId").getValue());
        RelatedLink relatedLink = LinkFactory.newRelatedLink(newWorkItem, inputWorkItem, linkTypeId, comment, readOnly);
        newWorkItem.getLinks().add(relatedLink);
        return newWorkItem;
    }

    public static String doubleToString(Double value) {
        if (value == null) {
            return null;
        }
        if ((double)value.intValue() == value) {
            return Integer.toString(value.intValue());
        }
        return value.toString();
    }

    public static String objectToString(Object value) {
        if (value instanceof Double) {
            return WorkItemUtils.doubleToString((Double)value);
        }
        return value.toString();
    }
}

