/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.events;

import com.microsoft.tfs.core.clients.workitem.events.WorkItemSaveEvent;
import com.microsoft.tfs.core.clients.workitem.events.WorkItemSaveListener;
import com.microsoft.tfs.util.listeners.ListenerCategory;
import com.microsoft.tfs.util.listeners.ListenerRunnable;
import com.microsoft.tfs.util.listeners.MultiListenerList;

public class WorkItemEventEngine {
    private final MultiListenerList listeners = new MultiListenerList();
    private static final ListenerCategory WORK_ITEM_SAVE = new ListenerCategory(WorkItemSaveListener.class);

    public void addWorkItemSaveListener(WorkItemSaveListener listener) {
        this.listeners.addListener(listener, WORK_ITEM_SAVE);
    }

    public void removeWorkItemSaveListener(WorkItemSaveListener listener) {
        this.listeners.removeListener(listener, WORK_ITEM_SAVE);
    }

    public void fireWorkItemSaveEvent(final WorkItemSaveEvent e) {
        this.listeners.getListenerList(WORK_ITEM_SAVE, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((WorkItemSaveListener)listener).onWorkItemSave(e);
                return true;
            }
        });
    }
}

