/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.metadata.dao;

import com.microsoft.tfs.util.GUID;
import java.sql.ResultSet;
import java.sql.SQLException;

public class NodeMetadata {
    public static final String SELECT_STRING = "select AreaID,ParentID,TypeID,StructureType,Name,GUID from Hierarchy";
    private final int id;
    private final int parentId;
    private final int nodeType;
    private final int structureType;
    private final String name;
    private final GUID guid;

    public static NodeMetadata fromRow(ResultSet rset) throws SQLException {
        int id = rset.getInt(1);
        int parentId = rset.getInt(2);
        int nodeType = rset.getInt(3);
        int structureType = rset.getInt(4);
        String name = rset.getString(5);
        String guidString = rset.getString(6);
        GUID guid = guidString.equals("0") ? GUID.EMPTY : new GUID(guidString);
        return new NodeMetadata(id, parentId, nodeType, structureType, name, guid);
    }

    public NodeMetadata(int id, int parentId, int nodeType, int structureType, String name, GUID guid) {
        this.id = id;
        this.parentId = parentId;
        this.nodeType = nodeType;
        this.structureType = structureType;
        this.name = name;
        this.guid = guid;
    }

    public GUID getGUID() {
        return this.guid;
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public int getParentID() {
        return this.parentId;
    }

    public int getStructureType() {
        return this.structureType;
    }
}

