/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.query;

import com.microsoft.tfs.core.clients.workitem.WorkItemQueryUtils;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.project.ProjectImpl;
import com.microsoft.tfs.core.clients.workitem.internal.query.QueryImpl;
import com.microsoft.tfs.core.clients.workitem.internal.query.StoredQueryProviderImpl;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeSelect;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Parser;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.SyntaxException;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.WIQLAdapter;
import com.microsoft.tfs.core.clients.workitem.project.Project;
import com.microsoft.tfs.core.clients.workitem.query.InvalidQueryTextException;
import com.microsoft.tfs.core.clients.workitem.query.Query;
import com.microsoft.tfs.core.clients.workitem.query.QueryScope;
import com.microsoft.tfs.core.clients.workitem.query.StoredQuery;
import com.microsoft.tfs.core.clients.workitem.query.WorkItemCollection;
import com.microsoft.tfs.util.GUID;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;

public class StoredQueryImpl
implements StoredQuery {
    private Date creationTime;
    private boolean deleted;
    private String queryDescription;
    private String initialQueryDescription;
    private GUID guid;
    private boolean dirty;
    private boolean saved;
    private Date lastWriteTime;
    private String owner;
    ProjectImpl project;
    int projectId;
    private String queryName;
    private String initialQueryName;
    StoredQueryProviderImpl queryProvider;
    private QueryScope queryScope;
    private String queryText;
    private String initialQueryText;
    private long rowVersion;
    WITContext witContext;
    private Boolean isParsable = null;

    public StoredQueryImpl(GUID guid, String queryName, String queryText, QueryScope queryScope, int projectId, ProjectImpl project, boolean deleted, WITContext witContext) {
        this.guid = guid;
        this.queryName = queryName;
        this.queryText = queryText;
        this.queryScope = queryScope;
        this.projectId = projectId;
        this.project = project;
        this.deleted = deleted;
        this.witContext = witContext;
        this.initialQueryName = queryName;
        this.initialQueryText = queryText;
        this.saved = true;
    }

    public StoredQueryImpl(GUID guid, String queryName, String queryText, String queryDescription, String owner, Date creationTime, Date lastWriteTime, QueryScope queryScope, int projectId, ProjectImpl project, boolean deleted, long rowVersion, StoredQueryProviderImpl queryProvider, WITContext witContext) {
        this.guid = guid;
        this.queryName = queryName;
        this.queryText = queryText;
        this.queryDescription = queryDescription;
        this.owner = owner;
        this.creationTime = creationTime;
        this.lastWriteTime = lastWriteTime;
        this.queryScope = queryScope;
        this.projectId = projectId;
        this.project = project;
        this.deleted = deleted;
        this.rowVersion = rowVersion;
        this.queryProvider = queryProvider;
        this.witContext = witContext;
        this.initialQueryName = queryName;
        this.initialQueryText = queryText;
        this.initialQueryDescription = queryDescription;
        this.saved = true;
    }

    public StoredQueryImpl(QueryScope scope, String name, String text, String description) throws InvalidQueryTextException {
        this.setName(name);
        this.setDescription(description);
        this.setQueryText(text);
        this.setQueryScope(scope);
        this.initialQueryName = this.queryName;
        this.initialQueryText = this.queryText;
        this.initialQueryDescription = this.queryDescription;
        this.saved = false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof StoredQueryImpl) {
            StoredQueryImpl other = (StoredQueryImpl)obj;
            if (this.guid == null) {
                return this == other;
            }
            return this.guid.equals(other.guid);
        }
        return false;
    }

    public int hashCode() {
        return this.guid == null ? 0 : this.guid.hashCode();
    }

    @Override
    public int compareTo(StoredQuery other) {
        if (this == other) {
            return 0;
        }
        int compValue = this.queryScope.getValue() - other.getQueryScope().getValue();
        if (compValue == 0) {
            compValue = this.queryName.compareToIgnoreCase(other.getName());
        }
        return compValue;
    }

    public String toString() {
        return MessageFormat.format("{0} / {1} / {2}", this.queryName, this.queryScope, this.guid == null ? "<no guid>" : this.guid);
    }

    @Override
    public void reset() {
        this.queryName = this.initialQueryName;
        this.queryText = this.initialQueryText;
        this.queryDescription = this.initialQueryDescription;
        this.dirty = false;
    }

    @Override
    public void update() {
        if (this.queryProvider == null) {
            throw new IllegalStateException("cannot update an unassociated query");
        }
        if (this.dirty) {
            this.queryProvider.updateStoredQuery(this);
        }
        this.saved = true;
        this.dirty = false;
        this.initialQueryName = this.queryName;
        this.initialQueryText = this.queryText;
        this.initialQueryDescription = this.queryDescription;
    }

    @Override
    public Date getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getDescription() {
        return this.queryDescription;
    }

    @Override
    public void setDescription(String description) {
        if (this.saved && !this.descriptionsEqual(this.queryDescription, description)) {
            this.dirty = true;
        }
        if (description == null) {
            description = "";
        }
        if (description.length() > 256) {
            throw new IllegalArgumentException(MessageFormat.format("description is longer than the max length of {0}", 256));
        }
        this.queryDescription = description;
    }

    @Override
    public boolean isSaved() {
        if (this.saved) {
            return !this.dirty;
        }
        return false;
    }

    @Override
    public boolean isParsable() {
        if (this.isParsable == null) {
            try {
                Parser.parseSyntax(this.getQueryText());
                this.isParsable = Boolean.TRUE;
            }
            catch (SyntaxException e) {
                this.isParsable = Boolean.FALSE;
            }
        }
        return this.isParsable;
    }

    @Override
    public Date getLastWriteTime() {
        return this.lastWriteTime;
    }

    @Override
    public String getName() {
        return this.queryName;
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if ((name = name.trim()).length() < 1) {
            throw new IllegalArgumentException("name must not be empty");
        }
        if (name.length() > 256) {
            throw new IllegalArgumentException(MessageFormat.format("name is longer than the max length of {0}", 256));
        }
        if (this.saved && this.queryName.compareToIgnoreCase(name) != 0) {
            this.dirty = true;
        }
        this.queryName = name;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public GUID getQueryGUID() {
        return this.guid;
    }

    @Override
    public QueryScope getQueryScope() {
        return this.queryScope;
    }

    @Override
    public void setQueryScope(QueryScope scope) {
        if (this.saved) {
            throw new IllegalStateException("cannot change query scope once saved");
        }
        this.queryScope = scope;
    }

    @Override
    public String getQueryText() {
        return this.queryText;
    }

    @Override
    public void setQueryText(String text) throws InvalidQueryTextException {
        if (text == null) {
            throw new IllegalArgumentException("text must not be null");
        }
        if ((text = text.trim()).length() < 1) {
            throw new IllegalArgumentException("text must not be empty");
        }
        StoredQueryImpl.validateWIQL(this.witContext, text);
        if (this.saved && this.queryText.compareToIgnoreCase(text) != 0) {
            this.dirty = true;
            this.isParsable = null;
        }
        this.queryText = text;
    }

    @Override
    public Query createQuery(Map<String, Object> queryContext) {
        if (this.witContext == null) {
            throw new IllegalStateException("unassociated stored query");
        }
        return new QueryImpl(this.witContext, this.getQueryText(), queryContext);
    }

    @Override
    public WorkItemCollection runQuery(Map<String, Object> queryContext) {
        return this.createQuery(queryContext).runQuery();
    }

    private boolean descriptionsEqual(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static void validateWIQL(WITContext witContext, String queryText) throws InvalidQueryTextException {
        try {
            NodeSelect selectNode = Parser.parseSyntax(queryText);
            if (witContext == null) {
                selectNode.bind(null, null, null);
            } else {
                WIQLAdapter psExternal = new WIQLAdapter(witContext);
                psExternal.setContext(WorkItemQueryUtils.makeContext("", ""));
                selectNode.bind(psExternal, null, null);
            }
        }
        catch (SyntaxException ex) {
            throw new InvalidQueryTextException(ex.getDetails(), queryText, ex);
        }
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public long getRowVersion() {
        return this.rowVersion;
    }

    public void updateAfterSave(GUID guid, Date updateTime) {
        this.guid = guid;
        this.lastWriteTime = updateTime;
        this.creationTime = updateTime;
        this.saved = true;
        this.dirty = false;
    }

    public void updateAfterUpdate(Date updateTime) {
        this.lastWriteTime = updateTime;
    }

    public int getProjectID() {
        return this.projectId;
    }

    public void setProjectID(int projectId) {
        this.projectId = projectId;
    }

    public void setProject(ProjectImpl project) {
        this.project = project;
    }

    public void setWITContext(WITContext witContext) {
        this.witContext = witContext;
    }

    public void setQueryProvider(StoredQueryProviderImpl queryProvider) {
        this.queryProvider = queryProvider;
    }
}

