/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.revision;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.fields.FieldCollectionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.fields.FieldDefinitionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.fields.FieldImpl;
import com.microsoft.tfs.core.clients.workitem.internal.revision.RevisionCollectionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.revision.RevisionFieldImpl;
import com.microsoft.tfs.core.clients.workitem.revision.Revision;
import com.microsoft.tfs.core.clients.workitem.revision.RevisionField;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RevisionImpl
implements Revision {
    private final List<RevisionFieldImpl> revisionFields = new ArrayList<RevisionFieldImpl>();
    private final Map<String, RevisionFieldImpl> fieldsByReferenceName = new HashMap<String, RevisionFieldImpl>();
    private final Map<Integer, RevisionFieldImpl> fieldsById = new HashMap<Integer, RevisionFieldImpl>();
    private int revisionNumber;
    private final WITContext context;
    private RevisionCollectionImpl revisionCollection;

    public static RevisionImpl createFromFieldCollection(FieldCollectionImpl fieldCollection, WITContext context, int revisionCount, RevisionCollectionImpl revisionCollection) {
        RevisionImpl revision = new RevisionImpl(context);
        revision.revisionNumber = revisionCount;
        revision.revisionCollection = revisionCollection;
        FieldDefinitionImpl[] fieldDefinitions = context.getWorkItemFieldUsages().getFieldDefinitions();
        for (int i = 0; i < fieldDefinitions.length; ++i) {
            FieldDefinitionImpl fieldDefinition = fieldDefinitions[i];
            if (!fieldDefinition.isUsedInPhysicalType() || !fieldCollection.hasField(fieldDefinition.getID())) continue;
            FieldImpl field = fieldCollection.getFieldInternal(fieldDefinition.getID());
            revision.addField(new RevisionFieldImpl(field.getOriginalValue(), field.getValue(), fieldDefinition, revision));
        }
        return revision;
    }

    private RevisionImpl(WITContext context) {
        this.context = context;
    }

    @Override
    public RevisionField[] getFields() {
        return this.revisionFields.toArray(new RevisionField[0]);
    }

    @Override
    public RevisionField getField(int id) {
        Integer key = new Integer(id);
        return this.fieldsById.get(key);
    }

    @Override
    public RevisionField getField(String referenceName) {
        return this.fieldsByReferenceName.get(referenceName);
    }

    @Override
    public Date getRevisionDate() {
        RevisionField field = this.getField(3);
        if (field != null) {
            return (Date)field.getValue();
        }
        return (Date)this.getField(-4).getValue();
    }

    @Override
    public String getTagLine() {
        String newState;
        String oldState;
        if (this.revisionNumber == 0) {
            return MessageFormat.format(Messages.getString("RevisionImpl.CreatedByPersonFormat"), (String)this.getField(9).getValue());
        }
        String changedBy = (String)this.getField(9).getValue();
        String authorizedAs = (String)this.getField(-1).getValue();
        boolean onBehalfOf = false;
        if (authorizedAs != null && !authorizedAs.equals(changedBy)) {
            onBehalfOf = true;
        }
        if (!(oldState = (String)this.getField(2).getOriginalValue()).equals(newState = (String)this.getField(2).getValue())) {
            if (onBehalfOf) {
                return MessageFormat.format(Messages.getString("RevisionImpl.EditedOldStateToNewStateByPersonOnBehalfOfPersonFormat"), oldState, newState, authorizedAs, changedBy);
            }
            return MessageFormat.format(Messages.getString("RevisionImpl.EditedOldStateToNewStateByPersonFormat"), oldState, newState, changedBy);
        }
        if (onBehalfOf) {
            return MessageFormat.format(Messages.getString("RevisionImpl.EditedByPersonOnBehalfOfPersonFormat"), authorizedAs, changedBy);
        }
        return MessageFormat.format(Messages.getString("RevisionImpl.EditedBtPersonFormat"), changedBy);
    }

    public void addField(RevisionFieldImpl field) {
        this.revisionFields.add(field);
        this.fieldsByReferenceName.put(field.getFieldDefinition().getReferenceName(), field);
        this.fieldsById.put(new Integer(field.getFieldDefinition().getID()), field);
    }

    public RevisionImpl createCopyForPreviousRevision() {
        RevisionImpl copy = new RevisionImpl(this.context);
        copy.revisionNumber = this.revisionNumber - 1;
        copy.revisionCollection = this.revisionCollection;
        for (RevisionFieldImpl field : this.revisionFields) {
            copy.addField(RevisionFieldImpl.createCopy(field, copy));
        }
        return copy;
    }

    public RevisionFieldImpl getFieldInternal(String fieldReferenceName) {
        return this.fieldsByReferenceName.get(fieldReferenceName);
    }

    public RevisionFieldImpl getFieldInternal(int id) {
        return this.fieldsById.get(new Integer(id));
    }

    public void convertToInitialRevision() {
        for (RevisionFieldImpl field : this.revisionFields) {
            field.setOriginalValue(null);
        }
    }

    public WITContext getContext() {
        return this.context;
    }

    public RevisionImpl getNextRevision() {
        int nextIx = this.revisionNumber + 1;
        if (nextIx < this.revisionCollection.size()) {
            return this.revisionCollection.getRevisionInternal(nextIx);
        }
        return null;
    }
}

