/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.rowset;

import com.microsoft.tfs.core.clients.workitem.internal.WorkItemImpl;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.BaseRowSetHandler;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.PageResultsRowSetHandler;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PageResultsLargeTextRowSetHandler
extends BaseRowSetHandler {
    private final PageResultsRowSetHandler pageHandler;
    private final Map<Integer, LongTextRowCollection> workItemIdToLongTextRowCollection = new HashMap<Integer, LongTextRowCollection>();

    public PageResultsLargeTextRowSetHandler(PageResultsRowSetHandler handler) {
        this.pageHandler = handler;
    }

    @Override
    protected void doHandleRow() {
        LongTextRow row = new LongTextRow(this.getDateValue("AddedDate"), this.getIntValue("FldID"), this.getIntValue("ID"), this.getStringValue("Words"));
        Integer key = new Integer(row.workItemId);
        LongTextRowCollection collection = this.workItemIdToLongTextRowCollection.get(key);
        if (collection == null) {
            collection = new LongTextRowCollection();
            this.workItemIdToLongTextRowCollection.put(key, collection);
        }
        collection.add(row);
    }

    @Override
    public void handleEndParsing() {
        for (Integer key : this.workItemIdToLongTextRowCollection.keySet()) {
            int workItemId = key;
            WorkItemImpl workItem = this.pageHandler.getByID(workItemId);
            if (workItem == null) continue;
            LongTextRowCollection collection = this.workItemIdToLongTextRowCollection.get(key);
            LongTextRow[] values = collection.values();
            for (int i = 0; i < values.length; ++i) {
                workItem.getFieldsInternal().addOriginalFieldValueFromServer(values[i].fieldId, values[i].text, true);
            }
        }
    }

    private static class LongTextRow {
        public final Date addedDate;
        public final int fieldId;
        public final int workItemId;
        public final String text;

        public LongTextRow(Date addedDate, int fieldId, int workItemId, String text) {
            this.addedDate = addedDate;
            this.fieldId = fieldId;
            this.workItemId = workItemId;
            this.text = text;
        }
    }

    private static class LongTextRowCollection {
        private final Map<Integer, LongTextRow> fieldIdToLongTextRow = new HashMap<Integer, LongTextRow>();

        private LongTextRowCollection() {
        }

        public void add(LongTextRow newRow) {
            Integer key = new Integer(newRow.fieldId);
            LongTextRow existingRow = this.fieldIdToLongTextRow.get(key);
            if (existingRow == null || newRow.addedDate.after(existingRow.addedDate)) {
                this.fieldIdToLongTextRow.put(key, newRow);
            }
        }

        public LongTextRow[] values() {
            return this.fieldIdToLongTextRow.values().toArray(new LongTextRow[this.fieldIdToLongTextRow.size()]);
        }
    }
}

