/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.rowset;

import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.WorkItemImpl;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.RowSetParseHandler;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PageResultsRowSetHandler
implements RowSetParseHandler {
    private static String[] PAGE_WORK_ITEMS_FIELD_NAMES_V1 = new String[]{"System.Id", "System.Rev", "System.AreaId", "System.WorkItemType", "System.ChangedDate"};
    private static String[] PAGE_WORK_ITEMS_FIELD_NAMES_V2 = new String[]{"System.Id", "System.Rev", "System.AreaId", "System.WorkItemType", "System.AuthorizedDate"};
    private final List<String> columnNames = new ArrayList<String>();
    private final Map<Integer, WorkItemImpl> workItems = new HashMap<Integer, WorkItemImpl>();
    private final WITContext witContext;

    public PageResultsRowSetHandler(WITContext witContext) {
        this.witContext = witContext;
    }

    public static String[] getPageWorkItemsFieldNames(WITContext witContext) {
        return witContext.getFieldDefinitions().contains("System.AuthorizedDate") ? PAGE_WORK_ITEMS_FIELD_NAMES_V2 : PAGE_WORK_ITEMS_FIELD_NAMES_V1;
    }

    @Override
    public void handleBeginParsing() {
        this.columnNames.clear();
        this.workItems.clear();
    }

    @Override
    public void handleTableName(String tableName) {
    }

    @Override
    public void handleColumn(String name, String type) {
        this.columnNames.add(name);
    }

    @Override
    public void handleFinishedColumns() {
        for (String requiredFieldReferenceName : PageResultsRowSetHandler.getPageWorkItemsFieldNames(this.witContext)) {
            if (this.columnNames.contains(requiredFieldReferenceName)) continue;
            throw new IllegalStateException(MessageFormat.format("required field [{0}] was not contained in page results columns: [{1}]", requiredFieldReferenceName, this.columnNames));
        }
    }

    @Override
    public void handleRow(String[] rowValues) {
        WorkItemImpl workItem = new WorkItemImpl(this.witContext);
        for (int i = 0; i < rowValues.length; ++i) {
            String fieldReferenceName = this.columnNames.get(i);
            String fieldValueAsString = rowValues[i];
            workItem.getFieldsInternal().addOriginalFieldValueFromServer(fieldReferenceName, fieldValueAsString, true);
        }
        this.workItems.put(new Integer(workItem.getFields().getID()), workItem);
    }

    @Override
    public void handleEndParsing() {
    }

    public WorkItemImpl getByID(Integer id) {
        return this.workItems.get(id);
    }

    public WorkItemImpl getByID(int id) {
        return this.getByID(new Integer(id));
    }
}

